/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.model;

import io.intino.magritte.compiler.model.NodeImpl;
import io.intino.magritte.lang.model.Aspect;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.Parameter;
import io.intino.magritte.lang.model.Rule;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.model.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NodeReference
implements Node {
    private Node container;
    private NodeImpl destination;
    private String reference;
    private String file;
    private int line;
    private String doc;
    private List<Tag> flags = new ArrayList<Tag>();
    private List<Tag> annotations = new ArrayList<Tag>();
    private List<String> uses = new ArrayList<String>();
    private boolean has;
    private String language;

    public NodeReference(String reference) {
        this.reference = reference;
    }

    public NodeReference(NodeImpl destination) {
        this.destination = destination;
        this.reference = destination.qualifiedName();
    }

    public String getReference() {
        return this.reference;
    }

    public NodeImpl destination() {
        return this.destination;
    }

    public void destination(NodeImpl destination) {
        this.destination = destination;
    }

    public String layerQualifiedName() {
        return ((NodeImpl)this.container).layerQualifiedName() + "$" + this.destination.name();
    }

    public String name() {
        return this.destination != null ? this.destination.name() : "";
    }

    public void name(String name) {
    }

    public String file() {
        return this.file;
    }

    public void file(String file) {
        this.file = file;
    }

    public String languageName() {
        return this.language;
    }

    public void languageName(String language) {
        this.language = language;
    }

    public int line() {
        return this.line;
    }

    public void line(int line) {
        this.line = line;
    }

    public String doc() {
        return this.doc;
    }

    public void doc(String doc) {
        this.doc = doc;
    }

    public boolean isSub() {
        return false;
    }

    public boolean isHas() {
        return this.has;
    }

    public void setHas(boolean has) {
        this.has = has;
    }

    public List<Node> subs() {
        return Collections.unmodifiableList(this.destination.subs());
    }

    public Node container() {
        return this.container;
    }

    public List<String> uses() {
        return this.uses;
    }

    public void container(Node container) {
        this.container = container;
    }

    public boolean isTerminal() {
        return this.is(Tag.Terminal);
    }

    public boolean isAbstract() {
        return this.is(Tag.Abstract);
    }

    public boolean isAspect() {
        return this.destination.isAspect();
    }

    public boolean isMetaAspect() {
        return this.destination.isMetaAspect();
    }

    public boolean is(Tag tag) {
        return this.destination.is(tag) || this.flags().contains(tag);
    }

    public boolean into(Tag tag) {
        return this.destination.into(tag) || this.annotations().contains(tag);
    }

    public List<Tag> annotations() {
        ArrayList<Tag> tags = new ArrayList<Tag>(this.destination.annotations());
        this.annotations.stream().filter(flag -> !tags.contains(flag)).forEach(tags::add);
        return Collections.unmodifiableList(tags);
    }

    public List<Tag> flags() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        this.flags.stream().filter(flag -> !tags.contains(flag)).forEach(tags::add);
        if (this.isHas()) {
            tags.addAll(this.destination.flags());
        }
        return Collections.unmodifiableList(tags);
    }

    public void addAnnotations(Tag ... annotations) {
        Collections.addAll(this.annotations, annotations);
    }

    public void addFlags(Tag ... flags) {
        Collections.addAll(this.flags, flags);
    }

    public void addUses(List<String> uses) {
        this.uses.addAll(uses);
    }

    public Node parent() {
        return null;
    }

    public String parentName() {
        return null;
    }

    public boolean isAnonymous() {
        return this.destination.isAnonymous();
    }

    public String qualifiedName() {
        return this.container.qualifiedName() + "." + this.destination.name();
    }

    public String type() {
        return this.destination.type();
    }

    public List<String> types() {
        return this.destination.types();
    }

    public List<String> secondaryTypes() {
        return this.destination.secondaryTypes();
    }

    public void type(String type) {
    }

    public void stashNodeName(String name) {
    }

    public Node resolve() {
        return this;
    }

    public boolean isReference() {
        return true;
    }

    public List<Parameter> parameters() {
        return Collections.emptyList();
    }

    public List<Node> siblings() {
        ArrayList components = new ArrayList(this.container.components());
        components.remove(this);
        return Collections.unmodifiableList(components);
    }

    public List<Node> components() {
        return Collections.unmodifiableList(this.destination.components());
    }

    public List<Rule> rulesOf(Node component) {
        return this.destination.rulesOf(component);
    }

    public boolean contains(Node nodeContainer) {
        return false;
    }

    public List<Variable> variables() {
        return Collections.unmodifiableList(this.destination.variables());
    }

    public List<Node> referenceComponents() {
        return Collections.unmodifiableList(this.destination.referenceComponents());
    }

    public Node destinyOfReference() {
        return this.destination;
    }

    public List<Node> children() {
        return Collections.unmodifiableList(this.destination.children());
    }

    public List<Aspect> appliedAspects() {
        return Collections.unmodifiableList(this.destination.appliedAspects());
    }

    public String toString() {
        return this.destination != null ? this.qualifiedName() : this.reference;
    }
}

