/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.core.operation.sourceunit;

import io.intino.magritte.compiler.core.CompilationUnit;
import io.intino.magritte.compiler.core.SourceUnit;
import io.intino.magritte.compiler.core.errorcollection.ErrorCollector;
import io.intino.magritte.compiler.core.errorcollection.SyntaxException;
import io.intino.magritte.compiler.core.errorcollection.TaraException;
import io.intino.magritte.compiler.core.errorcollection.message.Message;
import io.intino.magritte.compiler.core.operation.sourceunit.SourceUnitOperation;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParseOperation
extends SourceUnitOperation {
    private static final Logger LOG = Logger.getGlobal();
    private final CompilationUnit unit;
    private final ErrorCollector errorCollector;

    public ParseOperation(CompilationUnit unit) {
        this.unit = unit;
        this.errorCollector = unit.getErrorCollector();
    }

    @Override
    public void call(SourceUnit source) {
        try {
            if (this.unit.configuration().isVerbose()) {
                this.unit.configuration().out().println("@#$%@# Presentable:Parsing " + source.getName());
            }
            source.parse();
            this.errorCollector.failIfErrors();
        }
        catch (TaraException e) {
            if (e.getCause() instanceof SyntaxException) {
                LOG.log(Level.SEVERE, "Syntax error during Parsing: " + e.getMessage());
                this.errorCollector.addError(Message.create((SyntaxException)e.getCause(), source));
            }
            if (e instanceof SyntaxException) {
                LOG.log(Level.SEVERE, "Syntax error during Parsing: " + e.getMessage());
                this.errorCollector.addError(Message.create((SyntaxException)e, source));
            }
            LOG.log(Level.SEVERE, "Error during Parsing: " + e.getMessage());
            this.errorCollector.addError(Message.create(e.getMessage(), source));
        }
    }
}

