/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.core.operation;

import io.intino.Configuration;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.magritte.compiler.codegeneration.Format;
import io.intino.magritte.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.compiler.codegeneration.magritte.layer.AbstractGraphCreator;
import io.intino.magritte.compiler.codegeneration.magritte.layer.LayerFrameCreator;
import io.intino.magritte.compiler.codegeneration.magritte.layer.LayerTemplate;
import io.intino.magritte.compiler.codegeneration.magritte.layer.templates.GraphTemplate;
import io.intino.magritte.compiler.codegeneration.magritte.natives.NativesCreator;
import io.intino.magritte.compiler.core.CompilationUnit;
import io.intino.magritte.compiler.core.CompilerConfiguration;
import io.intino.magritte.compiler.core.errorcollection.CompilationFailedException;
import io.intino.magritte.compiler.core.operation.model.ModelOperation;
import io.intino.magritte.compiler.model.Model;
import io.intino.magritte.compiler.model.NodeImpl;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.Tag;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class LayerGenerationOperation
extends ModelOperation
implements TemplateTags {
    private static final Logger LOG = Logger.getGlobal();
    private static final String DOT = ".";
    private static final String JAVA = ".java";
    private static final String GRAPH = "Graph";
    private final CompilationUnit compilationUnit;
    private final CompilerConfiguration conf;
    private final File srcFolder;
    private File outFolder;
    private Template template;
    private Map<String, List<String>> outMap = new LinkedHashMap<String, List<String>>();

    public LayerGenerationOperation(CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
        this.conf = compilationUnit.configuration();
        this.outFolder = this.conf.getOutDirectory();
        this.srcFolder = this.conf.sourceDirectories().isEmpty() ? null : this.conf.sourceDirectories().get(0);
        this.template = Format.customize(new LayerTemplate());
    }

    @Override
    public void call(Model model) {
        try {
            if (this.conf.isVerbose()) {
                this.conf.out().println(this.prefix() + " Cleaning Old Layers...");
            }
            if (!this.conf.model().level().equals((Object)Configuration.Artifact.Model.Level.Solution)) {
                this.cleanOldLayers(model);
            }
            if (this.conf.isVerbose()) {
                this.conf.out().println(this.prefix() + " Generating Layers...");
            }
            if (!model.level().equals((Object)Configuration.Artifact.Model.Level.Solution)) {
                this.createLayers(model);
            }
            this.registerOutputs(this.writeNativeClasses(model));
            this.compilationUnit.addOutputItems(this.outMap);
            this.compilationUnit.compilationDifferentialCache().saveCache(model.components().stream().map(c -> ((NodeImpl)c).getHashCode()).collect(Collectors.toList()));
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, "Error during java className generation: " + e.getMessage(), e);
            throw new CompilationFailedException(this.compilationUnit.getPhase(), this.compilationUnit, e);
        }
    }

    private Map<String, String> writeNativeClasses(Model model) {
        return new NativesCreator(model, this.conf).create();
    }

    private void createLayers(Model model) {
        Map<String, Map<String, String>> layers = this.createLayerClasses(model);
        layers.values().forEach(this::writeLayers);
        this.registerOutputs(layers, this.writeAbstractGraph(new AbstractGraphCreator(model.language(), this.conf.model().outDsl(), this.conf.model().level(), this.conf.workingPackage(), this.conf.model().language().generationPackage()).create(model)));
        this.writeGraph(this.createGraph());
    }

    private void registerOutputs(Map<String, Map<String, String>> layers, String modelPath) {
        this.fillLayerInOutMap(layers);
        for (List<String> paths : this.outMap.values()) {
            paths.add(modelPath);
        }
    }

    private void registerOutputs(Map<String, String> nativeOuts) {
        for (Map.Entry<String, String> src : nativeOuts.entrySet()) {
            if (!this.outMap.containsKey(src.getValue())) {
                this.outMap.put(src.getValue(), new ArrayList());
            }
            this.outMap.get(src.getValue()).add(src.getKey());
        }
    }

    private void fillLayerInOutMap(Map<String, Map<String, String>> map) {
        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
            for (String out : entry.getValue().keySet()) {
                if (this.isUnderSource(new File(out))) continue;
                this.put(entry.getKey(), out);
            }
        }
    }

    private void put(String key, String value) {
        if (!this.outMap.containsKey(key)) {
            this.outMap.put(key, new ArrayList());
        }
        this.outMap.get(key).add(value);
    }

    private String createGraph() {
        FrameBuilder builder = new FrameBuilder(new String[]{"wrapper"});
        builder.add("generatedLanguage", (Object)this.conf.model().outDsl());
        builder.add("workingPackage", (Object)this.conf.workingPackage());
        return Format.customize(new GraphTemplate()).render((Object)builder.toFrame());
    }

    private Map<String, Map<String, String>> createLayerClasses(Model model) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (Node node : model.components()) {
            if (node.is(Tag.Instance) || !((NodeImpl)node).isDirty() || ((NodeImpl)node).isVirtual()) continue;
            this.renderNode(map, model, node);
        }
        return map;
    }

    private void renderNode(Map<String, Map<String, String>> map, Model model, Node node) {
        Map.Entry<String, Frame> layerFrame = new LayerFrameCreator(this.conf, node.languageName(), model).create(node);
        if (!map.containsKey(node.file())) {
            map.put(node.file(), new LinkedHashMap());
        }
        String destination = this.destination(layerFrame);
        map.get(node.file()).put(destination, !this.isModified(node) && new File(destination).exists() ? "" : this.render(layerFrame));
        this.renderFrame(map, node, model, layerFrame);
    }

    private boolean isModified(Node node) {
        return this.compilationUnit.compilationDifferentialCache().isModified((NodeImpl)node);
    }

    private void renderFrame(Map<String, Map<String, String>> map, Node node, Model model, Map.Entry<String, Frame> layerFrame) {
        if (node.is(Tag.Decorable)) {
            Map.Entry<String, Frame> frame = new LayerFrameCreator(this.conf, node.languageName(), model).createDecorable(node);
            File file = new File(this.srcDestiny(frame));
            if (file.exists() && node.isAbstract()) {
                this.checkAbstractDecorable(file);
            }
            map.get(node.file()).put(file.getAbsolutePath(), file.exists() ? "" : this.render(frame));
        } else {
            this.removeDecorable(layerFrame.getKey(), node.name());
        }
    }

    private void checkAbstractDecorable(File file) {
        try {
            String text = Files.readString(file.toPath());
            if (text.contains("public class")) {
                text = text.replaceFirst("public class", "public abstract class");
                Files.writeString(file.toPath(), (CharSequence)text, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void removeDecorable(String key, String name) {
        File parentFile = new File(this.outFolder, key.replace(DOT, File.separator) + JAVA).getParentFile();
        File file = new File(parentFile, Format.firstUpperCase().format(Format.javaValidName().format((Object)("abstract" + name))).toString() + JAVA);
        if (file.exists()) {
            file.delete();
        }
    }

    private String destination(Map.Entry<String, Frame> layerFrameMap) {
        return new File(this.outFolder, layerFrameMap.getKey().replace(DOT, File.separator) + JAVA).getAbsolutePath();
    }

    private String srcDestiny(Map.Entry<String, Frame> layerFrameMap) {
        return new File(this.srcFolder, layerFrameMap.getKey().replace(DOT, File.separator) + JAVA).getAbsolutePath();
    }

    private void writeLayers(Map<String, String> layersMap) {
        for (Map.Entry<String, String> entry : layersMap.entrySet()) {
            File file = new File(entry.getKey());
            if (entry.getValue().isEmpty() || this.isUnderSource(file) && file.exists()) continue;
            file.getParentFile().mkdirs();
            this.write(file, entry.getValue());
        }
    }

    private boolean isUnderSource(File file) {
        return file.getAbsolutePath().startsWith(this.srcFolder.getAbsolutePath());
    }

    private String writeAbstractGraph(String text) {
        File destiny = new File(new File(this.outFolder, this.conf.workingPackage().replace(DOT, File.separator)), "AbstractGraph.java");
        destiny.getParentFile().mkdirs();
        return this.write(destiny, text) ? destiny.getAbsolutePath() : null;
    }

    private void writeGraph(String text) {
        File destiny = new File(new File(this.conf.srcDirectory(), this.conf.workingPackage().toLowerCase().replace(DOT, File.separator)), Format.firstUpperCase().format(Format.javaValidName().format((Object)this.conf.model().outDsl())) + "Graph.java");
        if (!destiny.exists()) {
            this.write(destiny, text);
        }
    }

    private void cleanOldLayers(Model model) {
        String workingPackage = this.conf.workingPackage() == null ? this.conf.getModule() : this.conf.workingPackage();
        File out = new File(this.conf.getOutDirectory(), workingPackage.toLowerCase());
        List<File> layers = this.filterOld(this.collectAllLayers(out), out, model);
        layers.forEach(File::delete);
    }

    private List<File> filterOld(List<File> files, File base, Model model) {
        List<File> current = this.calculateCurrentLayers(base, model);
        return files.stream().filter(layer -> !current.contains(layer) && !this.isUnderSource((File)layer)).collect(Collectors.toList());
    }

    private List<File> calculateCurrentLayers(File base, Model model) {
        return model.components().stream().filter(n -> !n.is(Tag.Instance) && !n.isAnonymous()).map(node -> new File(this.calculateLayerPath((Node)node, base) + JAVA)).collect(Collectors.toList());
    }

    private String calculateLayerPath(Node node, File workingPackage) {
        return workingPackage.getPath() + File.separator + Format.javaValidName().format((Object)node.name()).toString();
    }

    private List<File> collectAllLayers(File out) {
        ArrayList<File> list = new ArrayList<File>();
        if (!out.isDirectory() && !out.getName().equals("Graph.java")) {
            list.add(out);
        } else if (!out.isDirectory()) {
            for (File file : Objects.requireNonNull(out.listFiles(f -> !"natives".equals(f.getName())))) {
                list.addAll(this.collectAllLayers(file));
            }
        }
        return list;
    }

    private boolean write(File file, String text) {
        try {
            file.getParentFile().mkdirs();
            BufferedWriter fileWriter = new BufferedWriter(new FileWriter(file));
            fileWriter.write(text);
            fileWriter.close();
            return true;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    private String render(Map.Entry<String, Frame> layerFrame) {
        return this.template.render((Object)layerFrame.getValue());
    }

    private String prefix() {
        return "@#$%@# Presentable:[" + this.conf.getModule() + " - " + this.conf.model().outDsl() + "]";
    }
}

