/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.core;

import io.intino.magritte.Language;
import io.intino.magritte.compiler.DifferentialCache;
import io.intino.magritte.compiler.core.CompilerConfiguration;
import io.intino.magritte.compiler.core.ModelResolutionOperation;
import io.intino.magritte.compiler.core.NativeTransformationOperation;
import io.intino.magritte.compiler.core.ProcessingUnit;
import io.intino.magritte.compiler.core.SourceUnit;
import io.intino.magritte.compiler.core.errorcollection.CompilationFailedException;
import io.intino.magritte.compiler.core.operation.LayerGenerationOperation;
import io.intino.magritte.compiler.core.operation.Operation;
import io.intino.magritte.compiler.core.operation.StashGenerationOperation;
import io.intino.magritte.compiler.core.operation.model.GenerateLanguageOperation;
import io.intino.magritte.compiler.core.operation.model.MetricResolutionOperation;
import io.intino.magritte.compiler.core.operation.model.ModelCollectionOperation;
import io.intino.magritte.compiler.core.operation.model.ModelDependencyResolutionOperation;
import io.intino.magritte.compiler.core.operation.model.ModelOperation;
import io.intino.magritte.compiler.core.operation.model.SemanticAnalysisOperation;
import io.intino.magritte.compiler.core.operation.module.ModuleUnitOperation;
import io.intino.magritte.compiler.core.operation.module.UnifyModelOperation;
import io.intino.magritte.compiler.core.operation.setup.SetupConfigurationOperation;
import io.intino.magritte.compiler.core.operation.setup.SetupOperation;
import io.intino.magritte.compiler.core.operation.sourceunit.MarkOperation;
import io.intino.magritte.compiler.core.operation.sourceunit.ModelGenerationOperation;
import io.intino.magritte.compiler.core.operation.sourceunit.ParseOperation;
import io.intino.magritte.compiler.core.operation.sourceunit.SourceUnitOperation;
import io.intino.magritte.compiler.model.Model;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public final class CompilationUnit
extends ProcessingUnit {
    private final DifferentialCache differentialCache;
    private Map<String, SourceUnit> sourceUnits;
    private Map<Language, Model> models = new HashMap<Language, Model>();
    private List<Operation>[] phaseOperations;
    private Map<String, List<String>> outputItems = new HashMap<String, List<String>>();

    public CompilationUnit(CompilerConfiguration configuration) {
        super(configuration, null);
        this.sourceUnits = new HashMap<String, SourceUnit>();
        this.phaseOperations = new LinkedList[11];
        this.differentialCache = new DifferentialCache(new File(configuration.intinoProjectDirectory(), "model" + File.separator + configuration.getModule()));
        IntStream.range(0, this.phaseOperations.length).forEach(i -> {
            this.phaseOperations[i] = new LinkedList<Operation>();
        });
        this.addPhaseOperations();
    }

    public static void cleanOut(CompilerConfiguration configuration) {
        String generationPackage = (configuration.workingPackage() == null ? configuration.getModule() : configuration.workingPackage()).replace(".", File.separator);
        File out = new File(configuration.getOutDirectory(), generationPackage.toLowerCase());
    }

    private void addPhaseOperations() {
        this.addPhaseOperation(new SetupConfigurationOperation(this), 1);
        this.addPhaseOperation(new ParseOperation(this), 2);
        this.addPhaseOperation(new ModelGenerationOperation(this), 3);
        this.addPhaseOperation(new UnifyModelOperation(this), 3);
        this.addPhaseOperation(new ModelDependencyResolutionOperation(this), 4);
        this.addPhaseOperation(new ModelResolutionOperation(), 5);
        this.addPhaseOperation(new SemanticAnalysisOperation(this), 6);
        this.addPhaseOperation(new MetricResolutionOperation(this), 7);
        this.addPhaseOperation(new NativeTransformationOperation(this), 7);
        this.addPhaseOperation(new LayerGenerationOperation(this), 8);
        this.addPhaseOperation(new StashGenerationOperation(this), 9);
        if (!this.configuration.isTest()) {
            this.addPhaseOperation(new GenerateLanguageOperation(this), 10);
        }
    }

    private void addPhaseOperation(Operation operation, int phase) {
        if (phase < 1 || phase > 10) {
            throw new IllegalArgumentException("phase " + phase + " is unknown");
        }
        if (!this.isExcludedPhase(phase)) {
            this.phaseOperations[phase].add(operation);
        }
    }

    private boolean isExcludedPhase(int phase) {
        return this.configuration.getExcludedPhases().contains(phase);
    }

    public void addOutputItems(Map<String, List<String>> paths) {
        this.outputItems.putAll(paths);
    }

    public SourceUnit addSource(SourceUnit source) {
        String name = source.getName();
        for (SourceUnit su : this.sourceUnits.values()) {
            if (!name.equals(su.getName())) continue;
            return su;
        }
        this.sourceUnits.put(name, source);
        return source;
    }

    public Map<String, SourceUnit> getSourceUnits() {
        return this.sourceUnits;
    }

    public void compile() throws CompilationFailedException {
        this.compile(11);
    }

    private void compile(int throughPhase) throws CompilationFailedException {
        this.gotoPhase(1);
        while (Math.min(throughPhase, 10) >= this.phase && this.phase <= 10) {
            this.processPhaseOperations(this.phase);
            this.completePhase();
            this.nextPhase();
            this.applyToSourceUnits(new MarkOperation(this));
        }
        this.errorCollector.failIfErrors();
    }

    private void applyToSourceUnits(SourceUnitOperation mark) throws CompilationFailedException {
        for (String name : this.sourceUnits.keySet()) {
            SourceUnit source = this.sourceUnits.get(name);
            if (source.phase >= this.phase && (source.phase != this.phase || source.phaseComplete)) continue;
            mark.call(source);
        }
        this.getErrorCollector().failIfErrors();
    }

    private void processPhaseOperations(int ph) {
        List<Operation> ops = this.phaseOperations[ph];
        ops.forEach(this::doPhaseOperation);
    }

    private void doPhaseOperation(Operation operation) {
        if (operation instanceof SourceUnitOperation) {
            this.applyToSourceUnits((SourceUnitOperation)operation);
        } else if (operation instanceof ModuleUnitOperation) {
            ((ModuleUnitOperation)operation).call(this.sourceUnits.values());
        } else if (operation instanceof ModelCollectionOperation) {
            ((ModelCollectionOperation)operation).call(this.models.values());
        } else if (operation instanceof ModelOperation) {
            this.models.values().forEach(((ModelOperation)operation)::call);
        } else if (operation instanceof SetupOperation) {
            ((SetupOperation)operation).call();
        }
    }

    public Map<Language, Model> models() {
        return this.models;
    }

    public void addModel(Language language, Model model) {
        this.models.put(language, model);
    }

    public Map<String, List<String>> getOutputItems() {
        return this.outputItems;
    }

    public DifferentialCache compilationDifferentialCache() {
        return this.differentialCache;
    }
}

