/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.semantic;

import io.intino.magritte.Checker;
import io.intino.magritte.Resolver;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.NodeRoot;
import io.intino.magritte.lang.semantics.errorcollector.SemanticException;
import io.intino.magritte.lang.semantics.errorcollector.SemanticFatalException;
import java.util.ArrayList;
import java.util.List;

public class SemanticAnalyzer {
    private final NodeRoot root;
    private final Resolver resolver;
    private Checker checker;
    private List<SemanticException> notifications;

    public SemanticAnalyzer(NodeRoot root) {
        this.root = root;
        this.resolver = new Resolver(root.language());
        this.checker = new Checker(root.language());
        this.notifications = new ArrayList<SemanticException>();
    }

    public void analyze() throws SemanticFatalException {
        this.resolveTypes((Node)this.root);
        this.checkNode((Node)this.root);
        if (!this.notifications.isEmpty()) {
            throw new SemanticFatalException(this.notifications);
        }
    }

    private void resolveTypes(Node node) {
        node.components().forEach(this::resolveNode);
    }

    private void check(Node node) {
        node.components().forEach(this::checkNode);
    }

    private void resolveNode(Node node) {
        this.resolver.resolve(node);
        if (!node.isReference()) {
            this.resolveTypes(node);
        }
    }

    private void checkNode(Node node) {
        block3: {
            try {
                this.checker.check(node);
                if (!node.isReference()) {
                    this.check(node);
                }
            }
            catch (SemanticFatalException e) {
                this.notifications.addAll(e.exceptions());
                if (this.hasFatal(e.exceptions()) || node.isReference()) break block3;
                this.check(node);
            }
        }
    }

    private boolean hasFatal(List<SemanticException> exceptions) {
        for (SemanticException exception : exceptions) {
            if (!exception.isFatal()) continue;
            return true;
        }
        return false;
    }
}

