/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.semantic;

import io.intino.magritte.Language;
import io.intino.magritte.compiler.codegeneration.Format;
import io.intino.magritte.compiler.core.errorcollection.TaraException;
import io.intino.magritte.dsl.Meta;
import io.intino.magritte.dsl.Proteo;
import io.intino.magritte.dsl.ProteoConstants;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.logging.Logger;

public class LanguageLoader {
    private static final Logger LOG = Logger.getGlobal();
    private static final String LANGUAGE_PACKAGE = "tara.dsl";

    private LanguageLoader() {
    }

    public static Language load(String name, String version, String languagesDirectory) throws TaraException {
        if (ProteoConstants.PROTEO.equalsIgnoreCase(name)) {
            return new Proteo();
        }
        if (ProteoConstants.META.equalsIgnoreCase(name)) {
            return new Meta();
        }
        String[] errorMessage = new String[]{"Impossible to create a language instance based in " + name};
        Language language = AccessController.doPrivileged(() -> {
            try {
                File jar = LanguageLoader.getLanguagePath(name, version, languagesDirectory);
                if (!jar.exists()) {
                    errorMessage[0] = "Language file not found: " + jar.getPath();
                }
                URLClassLoader cl = new URLClassLoader(new URL[]{jar.toURI().toURL()}, LanguageLoader.class.getClassLoader());
                Class<?> cls = cl.loadClass("tara.dsl." + Format.toCamelCase().format((Object)name));
                return (Language)cls.getConstructors()[0].newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException | MalformedURLException e1) {
                LOG.info(e1.getMessage());
                return null;
            }
        });
        if (language == null) {
            throw new TaraException(errorMessage[0]);
        }
        return language;
    }

    public static File getLanguagePath(String name, String version, String languagesDirectory) {
        String effectiveVersion = version.equals("LATEST") ? LanguageLoader.findLatestVersion(new File(languagesDirectory + File.separator + LanguageLoader.languageGroupId().toLowerCase() + name.toLowerCase())) : version;
        return new File(languagesDirectory + File.separator + LanguageLoader.languageGroupId().toLowerCase() + name.toLowerCase() + File.separator + effectiveVersion, name + "-" + effectiveVersion + ".jar");
    }

    private static String languageGroupId() {
        return "tara" + File.separator + "dsl" + File.separator;
    }

    private static String findLatestVersion(File languageDirectory) {
        File[] files = languageDirectory.listFiles(File::isDirectory);
        if (files == null || files.length == 0) {
            return "1.0.0";
        }
        return files[files.length - 1].getName();
    }
}

