/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.core;

import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.magritte.compiler.codegeneration.FileSystemUtils;
import io.intino.magritte.compiler.codegeneration.Format;
import io.intino.magritte.compiler.codegeneration.magritte.natives.NativeExtractor;
import io.intino.magritte.compiler.core.CompilationUnit;
import io.intino.magritte.compiler.core.ToNativeTransformerTemplate;
import io.intino.magritte.compiler.core.errorcollection.CompilationFailedException;
import io.intino.magritte.compiler.core.operation.model.ModelOperation;
import io.intino.magritte.compiler.model.Model;
import io.intino.magritte.lang.model.EmptyNode;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.NodeContainer;
import io.intino.magritte.lang.model.Parameter;
import io.intino.magritte.lang.model.Parametrized;
import io.intino.magritte.lang.model.Primitive;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.model.Valued;
import io.intino.magritte.lang.model.Variable;
import io.intino.magritte.lang.model.rules.variable.NativeRule;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class NativeTransformationOperation
extends ModelOperation {
    private final File resources;
    private final List<File> sources;

    NativeTransformationOperation(CompilationUnit unit) {
        this.resources = unit.configuration().resourcesDirectory();
        this.sources = unit.configuration().sourceDirectories();
    }

    @Override
    public void call(Model model) throws CompilationFailedException {
        for (Parameter parameter : this.findReactiveParameters((Parametrized)model)) {
            parameter.substituteValues(new ArrayList<Primitive.Expression>(Collections.singletonList(this.transformValueToExpression((Valued)parameter))));
        }
        for (Variable variable : this.findReactiveVariables((NodeContainer)model)) {
            variable.values(new ArrayList<Primitive.Expression>(Collections.singletonList(this.transformValueToExpression((Valued)variable))));
        }
        for (Valued valued : this.findMethodReferences((Node)model)) {
            valued.values(new ArrayList<Primitive.Expression>(Collections.singletonList(this.transformMethodReference(valued, new File(valued.file()).getName()))));
        }
    }

    private Primitive.Expression transformMethodReference(Valued v, String fileName) {
        return new Primitive.Expression(this.wrapMethodReference(v, fileName));
    }

    private String wrapMethodReference(Valued v, String fileName) {
        List value = v.values();
        return this.transformMethodReference(v.file(), (NativeRule)v.rule(), (Primitive.MethodReference)value.get(0), fileName);
    }

    private Primitive.Expression transformValueToExpression(Valued v) {
        return new Primitive.Expression(this.wrap(v));
    }

    private String wrap(Valued v) {
        if (v.values().get(0) instanceof EmptyNode) {
            return "null";
        }
        List result = v.values().stream().map(value -> this.wrapValue(v, value)).collect(Collectors.toList());
        return v.isMultiple() ? "java.util.Arrays.asList(" + String.join((CharSequence)", ", result) + ")" : (String)result.get(0);
    }

    private String wrapValue(Valued v, Object value) {
        Template template = new ToNativeTransformerTemplate().add("url", url -> url.toString().substring(this.resources.getAbsolutePath().length() + 1));
        FrameBuilder builder = new FrameBuilder(new String[]{v.type().name(), "native"});
        String toAdd = value.toString();
        if (value instanceof File) {
            toAdd = ((File)value).getAbsolutePath().replace("\\", "/");
        }
        builder.add("value", (Object)toAdd);
        return template.render((Object)builder.toFrame());
    }

    private String transformMethodReference(String file, NativeRule rule, Primitive.MethodReference value, String fileName) {
        String parameters = rule == null ? "" : this.namesOf(new NativeExtractor(rule.signature()).parameters());
        String packageOf = this.packageOf(new File(file).getParent());
        return (String)(!packageOf.isEmpty() ? packageOf + "." : "") + Format.javaValidName().format((Object)FileSystemUtils.getNameWithoutExtension(fileName)).toString() + "." + value.destiny() + "(self" + (String)(parameters.isEmpty() ? "" : ", " + parameters) + ");";
    }

    private String packageOf(String file) {
        String replace = file.replace(this.selectSource(file).getAbsolutePath(), "");
        return replace.isEmpty() ? "" : replace.substring(1).replace(File.separator, ".");
    }

    private File selectSource(String file) {
        for (File source : this.sources) {
            if (!file.startsWith(source.getAbsolutePath())) continue;
            return source;
        }
        return this.sources.get(0);
    }

    private String namesOf(String parameters) {
        return Format.nativeParameterWithoutType().format((Object)parameters).toString();
    }

    private Set<Parameter> findReactiveParameters(Parametrized parametrized) {
        Set<Parameter> parameters = parametrized.parameters().stream().filter(p -> p.flags().contains(Tag.Reactive) && !(p.values().get(0) instanceof Primitive.Expression) && !(p.values().get(0) instanceof Primitive.MethodReference)).collect(Collectors.toSet());
        if (parametrized instanceof Node && !((Node)parametrized).isReference()) {
            ((Node)parametrized).components().forEach(n -> parameters.addAll(this.findReactiveParameters((Parametrized)n)));
        }
        return parameters;
    }

    private Set<Variable> findReactiveVariables(NodeContainer node) {
        HashSet<Variable> parameters = new HashSet<Variable>();
        for (Node component : node.components()) {
            parameters.addAll(component.variables().stream().filter(v -> v.flags().contains(Tag.Reactive) && !v.values().isEmpty() && !(v.values().get(0) instanceof Primitive.Expression) && !(v.values().get(0) instanceof Primitive.MethodReference)).collect(Collectors.toList()));
            if (component.isReference()) continue;
            parameters.addAll(this.findReactiveVariables((NodeContainer)component));
        }
        return parameters;
    }

    private Set<Valued> findMethodReferences(Node node) {
        HashSet<Valued> valued = new HashSet<Valued>();
        valued.addAll(node.variables().stream().filter(v -> !v.values().isEmpty() && v.values().get(0) instanceof Primitive.MethodReference).collect(Collectors.toList()));
        valued.addAll(node.parameters().stream().filter(v -> !v.values().isEmpty() && v.values().get(0) instanceof Primitive.MethodReference).collect(Collectors.toList()));
        if (!node.isReference()) {
            for (Node component : node.components()) {
                valued.addAll(this.findMethodReferences(component));
            }
        }
        return valued;
    }
}

