/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.dependencyresolution;

import io.intino.magritte.Language;
import io.intino.magritte.compiler.core.errorcollection.DependencyException;
import io.intino.magritte.compiler.core.errorcollection.TaraException;
import io.intino.magritte.compiler.dependencyresolution.CustomRuleLoader;
import io.intino.magritte.compiler.dependencyresolution.ReferenceManager;
import io.intino.magritte.compiler.model.LanguageNodeReference;
import io.intino.magritte.compiler.model.Model;
import io.intino.magritte.compiler.model.NodeImpl;
import io.intino.magritte.compiler.model.NodeReference;
import io.intino.magritte.compiler.model.VariableReference;
import io.intino.magritte.lang.model.Element;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.NodeContainer;
import io.intino.magritte.lang.model.Parameter;
import io.intino.magritte.lang.model.Parametrized;
import io.intino.magritte.lang.model.Primitive;
import io.intino.magritte.lang.model.Rule;
import io.intino.magritte.lang.model.Variable;
import io.intino.magritte.lang.model.rules.CustomRule;
import io.intino.magritte.lang.model.rules.variable.ReferenceRule;
import io.intino.magritte.lang.model.rules.variable.VariableCustomRule;
import io.intino.magritte.lang.model.rules.variable.VariableRule;
import io.intino.magritte.lang.model.rules.variable.WordRule;
import io.intino.magritte.lang.semantics.InstanceContext;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DependencyResolver {
    private final File rulesDirectory;
    private final File semanticLib;
    private final File tempDirectory;
    private Model model;
    private ReferenceManager manager;
    private Map<String, Class<?>> loadedRules = new HashMap();
    private String workingPackage;
    private List<DependencyException> rulesNotLoaded = new ArrayList<DependencyException>();

    public DependencyResolver(Model model, String workingPackage, File rulesDirectory, File semanticLib, File tempDirectory) {
        this.model = model;
        this.workingPackage = workingPackage;
        this.rulesDirectory = rulesDirectory;
        this.semanticLib = semanticLib;
        this.tempDirectory = tempDirectory;
        this.manager = new ReferenceManager(this.model);
    }

    public void resolve() throws DependencyException {
        this.resolveParentReference((Node)this.model);
        this.resolveInNodes((Node)this.model);
    }

    public List<DependencyException> rulesNotLoaded() {
        return this.rulesNotLoaded;
    }

    private void resolveParentReference(Node node) throws DependencyException {
        if (node instanceof NodeReference) {
            return;
        }
        this.resolveParent(node);
        for (Node component : node.components()) {
            this.resolveParentReference(component);
        }
    }

    private void resolveInNodes(Node node) throws DependencyException {
        this.resolveCustomRules(node);
        for (Node component : node.components()) {
            this.resolve(component);
        }
    }

    private void resolve(Node node) throws DependencyException {
        if (!(node instanceof NodeImpl)) {
            return;
        }
        this.resolveNodesReferences(node);
        this.resolveVariables(node);
        this.resolveParametersReference((Parametrized)node);
        this.resolveInNodes(node);
    }

    private void resolveCustomRules(Node node) throws DependencyException {
        if (node.container() == null) {
            return;
        }
        for (Rule rule : node.container().rulesOf(node)) {
            if (!(rule instanceof CustomRule)) continue;
            this.loadCustomRule(node, (CustomRule)rule);
        }
    }

    private void resolveParametersReference(Parametrized parametrized) throws DependencyException {
        for (Parameter parameter : parametrized.parameters()) {
            this.resolveParameterValue((Node)parametrized, parameter);
        }
    }

    private void resolveParameterValue(Node node, Parameter parameter) throws DependencyException {
        if (parameter.values().isEmpty() || !this.areReferenceValues(parameter)) {
            return;
        }
        ArrayList<Object> nodes = new ArrayList<Object>();
        for (Object value : parameter.values()) {
            Node reference = this.resolveReferenceParameter(node, (Primitive.Reference)value);
            if (reference != null) {
                nodes.add(reference);
                continue;
            }
            if (!this.tryWithAnInstance((Primitive.Reference)value)) continue;
            nodes.add(value);
        }
        if (!nodes.isEmpty()) {
            parameter.type(Primitive.REFERENCE);
            parameter.substituteValues(nodes);
        }
    }

    private boolean tryWithAnInstance(Primitive.Reference value) {
        Language language = this.model.language();
        if (language != null && language.instances().containsKey(value.get())) {
            value.setToInstance(true);
            value.instanceTypes(((InstanceContext)language.instances().get(value.get())).types());
            value.path(((InstanceContext)language.instances().get(value.get())).path());
            return true;
        }
        return false;
    }

    private Node resolveReferenceParameter(Node node, Primitive.Reference value) throws DependencyException {
        return this.manager.resolveParameterReference(value, node);
    }

    private boolean areReferenceValues(Parameter parameter) {
        return parameter.values().get(0) instanceof Primitive.Reference;
    }

    private void resolveParent(Node node) throws DependencyException {
        if (node.parent() == null && node.parentName() != null) {
            Node parent = this.manager.resolveParent(node.parentName(), this.getNodeContainer((NodeContainer)node.container()));
            if (parent == null) {
                throw new DependencyException("reject.dependency.parent.node.not.found", (Element)node, new String[0]);
            }
            ((NodeImpl)node).setParent(parent);
            parent.addChild(node);
        }
    }

    private void resolveNodesReferences(Node node) throws DependencyException {
        for (Node nodeReference : node.referenceComponents()) {
            this.resolveNodeReference((NodeReference)nodeReference);
            this.resolveCustomRules(nodeReference);
        }
    }

    private void resolveNodeReference(NodeReference nodeReference) throws DependencyException {
        if (nodeReference.destination() != null) {
            return;
        }
        NodeImpl destiny = this.manager.resolve(nodeReference);
        if (destiny == null) {
            throw new DependencyException("reject.dependency.reference.node.not.found", (Element)nodeReference, new String[0]);
        }
        nodeReference.destination(destiny);
    }

    private void resolveVariables(Node container) throws DependencyException {
        for (Variable variable : container.variables()) {
            if (variable instanceof VariableReference) {
                this.resolveVariable((VariableReference)variable, container);
            }
            if (!(variable.rule() instanceof VariableCustomRule)) continue;
            this.loadCustomRule(variable);
        }
    }

    private void loadCustomRule(Variable variable) {
        VariableCustomRule rule = (VariableCustomRule)variable.rule();
        String source = rule.externalClass();
        File classFile = null;
        Class<?> aClass = null;
        try {
            aClass = this.loadedRules.containsKey(source) ? this.loadedRules.get(source) : ((classFile = CustomRuleLoader.compile((CustomRule)rule, this.workingPackage, this.rulesDirectory, this.semanticLib, this.tempDirectory)) != null ? CustomRuleLoader.load((CustomRule)rule, this.workingPackage, this.semanticLib, this.tempDirectory) : CustomRuleLoader.tryAsProvided((CustomRule)rule));
        }
        catch (TaraException e) {
            this.rulesNotLoaded.add(new DependencyException("impossible.load.rule.class", (Element)variable, rule.externalClass(), e.getMessage()));
            rule.qualifiedName(CustomRuleLoader.composeQualifiedName(this.workingPackage, rule.externalClass()));
        }
        if (aClass == null) {
            this.rulesNotLoaded.add(new DependencyException("impossible.load.rule.class", (Element)variable, rule.externalClass()));
            return;
        }
        this.loadedRules.put(source, aClass);
        if (classFile != null) {
            this.model.addRule(source, this.tempDirectory);
        }
        if (variable.type().equals((Object)Primitive.WORD)) {
            this.updateRule(variable, aClass);
        } else {
            rule.setLoadedClass(aClass);
            rule.classFile(classFile);
        }
    }

    private void loadCustomRule(Node node, CustomRule rule) throws DependencyException {
        Class<?> aClass;
        String source = rule.externalClass();
        File classFile = null;
        try {
            aClass = this.loadedRules.containsKey(source) ? this.loadedRules.get(source) : ((classFile = CustomRuleLoader.compile(rule, this.workingPackage, this.rulesDirectory, this.semanticLib, this.tempDirectory)) != null ? CustomRuleLoader.load(rule, this.workingPackage, this.semanticLib, this.tempDirectory) : CustomRuleLoader.tryAsProvided(rule));
        }
        catch (TaraException e) {
            throw new DependencyException("impossible.load.rule.class", (Element)node, rule.externalClass(), e.getMessage().split("\n")[0]);
        }
        if (aClass != null) {
            this.loadedRules.put(source, aClass);
            if (classFile != null) {
                this.model.addRule(source, this.tempDirectory);
            }
        } else {
            throw new DependencyException("impossible.load.rule.class", (Element)node, rule.externalClass());
        }
        rule.setLoadedClass(aClass);
        rule.classFile(classFile);
    }

    private void updateRule(Variable variable, Class<?> aClass) {
        if (aClass != null) {
            variable.rule((VariableRule)new WordRule(this.collectEnums(Arrays.asList(aClass.getDeclaredFields())), aClass.getSimpleName()));
        }
    }

    private List<String> collectEnums(List<Field> fields) {
        return fields.stream().filter(Field::isEnumConstant).map(Field::getName).collect(Collectors.toList());
    }

    private void resolveVariable(VariableReference variable, Node container) throws DependencyException {
        NodeImpl destiny = this.manager.resolve(variable, container);
        if (destiny != null) {
            variable.setDestiny(destiny);
        } else if (!this.tryAsLanguageReference(variable)) {
            throw new DependencyException("reject.reference.variable.not.found", (Element)container, variable.destinyName());
        }
        variable.rule((VariableRule)this.createReferenceRule(variable));
        this.resolveVariableDefaultValue(variable, container);
    }

    private void resolveVariableDefaultValue(VariableReference variable, Node container) throws DependencyException {
        if (variable.values().isEmpty() || !(variable.values().get(0) instanceof Primitive.Reference)) {
            return;
        }
        List collect = variable.values().stream().map(v -> (Primitive.Reference)v).collect(Collectors.toList());
        for (Primitive.Reference v2 : collect) {
            Node destiny = this.manager.resolve(v2.get(), container);
            if (destiny == null) {
                throw new DependencyException("reject.reference.variable.not.found", (Element)container, variable.destinyName());
            }
            v2.reference(destiny);
        }
    }

    private boolean tryAsLanguageReference(VariableReference variable) {
        Language language = this.model.language();
        if (language == null) {
            return false;
        }
        List types = language.types(variable.destinyName());
        if (types != null) {
            variable.setTypeReference();
            variable.setDestiny(new LanguageNodeReference(types, variable.destinyName()));
            return true;
        }
        return false;
    }

    private ReferenceRule createReferenceRule(VariableReference variable) {
        return new ReferenceRule(this.collectTypes(variable.destinyOfReference()));
    }

    private Set<String> collectTypes(Node node) {
        HashSet<String> set = new HashSet<String>();
        if (!node.isAbstract()) {
            set.add(node.qualifiedName());
        }
        for (Node child : node.children()) {
            set.addAll(this.collectTypes(child));
        }
        return set;
    }

    private Node getNodeContainer(NodeContainer reference) {
        NodeContainer container = reference;
        while (!(container instanceof NodeImpl) && container.container() != null) {
            container = container.container();
        }
        return (Node)container;
    }
}

