/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.codegeneration.magritte.layer;

import io.intino.Configuration;
import io.intino.magritte.Language;
import io.intino.magritte.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.compiler.model.NodeImpl;
import io.intino.magritte.compiler.model.VariableReference;
import io.intino.magritte.lang.model.Aspect;
import io.intino.magritte.lang.model.EmptyNode;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.Parameter;
import io.intino.magritte.lang.model.Primitive;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.model.Variable;
import io.intino.magritte.lang.model.rules.Size;
import io.intino.magritte.lang.semantics.Assumption;
import io.intino.magritte.lang.semantics.Constraint;
import io.intino.magritte.lang.semantics.constraints.parameter.ReferenceParameter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class TypesProvider
implements TemplateTags {
    private TypesProvider() {
    }

    static List<String> getTypes(Node node, Language language) {
        List<String> types = node.flags().stream().map(Enum::name).collect(Collectors.toList());
        Size size = node.container().sizeOf(node);
        if (size != null && size.isSingle()) {
            types.add("single");
        }
        if (TypesProvider.isOverriding(node)) {
            types.add("overriden");
        }
        types.addAll(TypesProvider.nodeAnnotations(node, language));
        return types;
    }

    private static boolean isOverriding(Node node) {
        return node.parent() != null && (node.container() instanceof NodeImpl && node.parent().container().equals((Object)node.container().parent()) || node.container().parent() != null && TypesProvider.containerContainsParent(node));
    }

    private static boolean containerContainsParent(Node node) {
        boolean contains = node.container().parent().contains(node.parent());
        return contains || TypesProvider.hasReference(node.container().parent(), node.parent());
    }

    private static boolean hasReference(Node node, Node component) {
        for (Node candidate : node.components()) {
            if (!candidate.isReference() || !candidate.destinyOfReference().equals((Object)component)) continue;
            return true;
        }
        return false;
    }

    static String[] getTypes(Aspect aspect) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("aspect");
        list.add(aspect.type());
        return list.toArray(new String[0]);
    }

    private static List<String> nodeAnnotations(Node node, Language language) {
        ArrayList<String> annotations = new ArrayList<String>();
        List assumptions = language.assumptions(node.type());
        if (assumptions == null) {
            return annotations;
        }
        for (Assumption assumption : assumptions) {
            String name = assumption.getClass().getInterfaces()[0].getSimpleName();
            if (!name.endsWith("Instance")) continue;
            annotations.add(name);
        }
        return annotations;
    }

    public static Set<String> getTypes(Variable variable, Configuration.Artifact.Model.Level type) {
        HashSet<String> types = new HashSet<String>();
        if (variable.values().isEmpty()) {
            types.add("required");
        }
        if (!variable.values().isEmpty() && (variable.values().get(0) instanceof EmptyNode || variable.values().get(0) == null)) {
            types.add("empty");
        }
        types.add(variable.getClass().getSimpleName());
        if (type.equals((Object)Configuration.Artifact.Model.Level.Product)) {
            types.add("terminal");
        }
        types.add("variable");
        if (variable instanceof VariableReference) {
            types.add("reference");
            if (variable.flags().contains(Tag.Concept)) {
                types.add("concept");
            }
        }
        if (variable.type().equals((Object)Primitive.OBJECT)) {
            types.add("objectVariable");
        }
        types.add(variable.type().getName());
        if (Primitive.isJavaPrimitive((String)variable.type().getName())) {
            types.add("primitive");
        }
        if (variable.isInherited()) {
            types.add("inherited");
        }
        if (variable.isOverriden()) {
            types.add("overriden");
        }
        if (variable.isMultiple()) {
            types.add("multiple");
        }
        types.addAll(variable.flags().stream().map(tag -> tag.name().toLowerCase()).collect(Collectors.toList()));
        return types;
    }

    public static String[] getTypes(Constraint.Parameter parameter, boolean isRequired) {
        HashSet<String> types = new HashSet<String>();
        types.add(parameter.getClass().getSimpleName());
        types.add("variable");
        if (parameter instanceof ReferenceParameter && !parameter.type().equals((Object)Primitive.WORD)) {
            types.add("reference");
        }
        types.add(parameter.type().getName());
        if (isRequired && parameter.flags().contains(Tag.Terminal)) {
            types.add("required");
        }
        if (parameter.size().max() > 1) {
            types.add("multiple");
        }
        types.addAll(parameter.flags().stream().map(Enum::name).collect(Collectors.toList()));
        return types.toArray(new String[0]);
    }

    public static String[] getTypes(Parameter parameter) {
        HashSet<String> types = new HashSet<String>();
        types.add(parameter.getClass().getSimpleName());
        types.add("variable");
        types.add("parameter");
        types.add(parameter.type().getName());
        if (parameter.values().size() > 1) {
            types.add("multiple");
        }
        types.addAll(parameter.flags().stream().map(Enum::name).collect(Collectors.toList()));
        return types.toArray(new String[0]);
    }
}

