/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.codegeneration.magritte;

import io.intino.magritte.compiler.codegeneration.Format;
import io.intino.magritte.compiler.model.NodeImpl;
import io.intino.magritte.compiler.model.NodeReference;
import io.intino.magritte.lang.model.Aspect;
import io.intino.magritte.lang.model.Node;

public class NameFormatter {
    public static final char DOT = '.';

    private NameFormatter() {
    }

    public static String getQn(Node node, String workingPackage) {
        return workingPackage.toLowerCase() + "." + Format.qualifiedName().format((Object)NameFormatter.layerQn(node)).toString();
    }

    private static String layerQn(Node node) {
        return node instanceof NodeReference ? ((NodeReference)node).layerQualifiedName() : ((NodeImpl)node).layerQualifiedName();
    }

    public static String getQn(Aspect aspect, String workingPackage) {
        return workingPackage.toLowerCase() + "." + Format.javaValidName().format((Object)aspect.type());
    }

    public static String decorableInnerClassQn(Node node, String workingPackage) {
        return workingPackage.toLowerCase() + "." + Format.javaClassNames().format((Object)((NodeImpl)node).layerQn()).toString();
    }

    public static String cleanQn(String qualifiedName) {
        return qualifiedName.replace("anonymous@", "").replace("[", "").replace("]", "").replace(":", "").replace("$", ".");
    }
}

