/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.dependencyresolution;

import io.intino.magritte.compiler.codegeneration.FileSystemUtils;
import io.intino.magritte.compiler.model.Model;
import io.intino.magritte.compiler.model.NodeImpl;
import io.intino.magritte.compiler.model.NodeReference;
import io.intino.magritte.compiler.model.VariableReference;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.NodeContainer;
import io.intino.magritte.lang.model.Primitive;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ReferenceManager {
    private Model model;

    ReferenceManager(Model model) {
        this.model = model;
    }

    public NodeImpl resolve(NodeReference reference) {
        return (NodeImpl)this.resolve(reference.getReference(), reference.container());
    }

    NodeImpl resolve(VariableReference variable, Node container) {
        Node result = this.resolve(variable.destinyName(), container);
        return result instanceof NodeReference ? ((NodeReference)result).destination() : (NodeImpl)result;
    }

    Node resolveParameterReference(Primitive.Reference value, Node node) {
        String[] path = value.get().split("\\.");
        List<Node> roots = this.findRoots(node, path).stream().filter(n -> !n.equals((Object)node)).collect(Collectors.toList());
        return this.selectFromOptions(node, path, roots);
    }

    Node resolve(String reference, Node node) {
        String[] path = reference.split("\\.");
        Collection<Node> roots = this.findRoots(node, path);
        return this.selectFromOptions(node, path, roots);
    }

    Node resolveParent(String reference, Node node) {
        return this.resolve(reference.split("\\."), this.searchPossibleRoots(node, reference.split("\\.")[0], true));
    }

    private Node selectFromOptions(Node node, String[] path, Collection<Node> roots) {
        return this.resolve(path, this.sortRootsByFile(roots, node.file()));
    }

    private Collection<Node> sortRootsByFile(Collection<Node> roots, String file) {
        List<Node> nodes = roots.stream().filter(node -> node.file().equals(file)).collect(Collectors.toList());
        roots.stream().filter(root -> !nodes.contains(root)).forEach(nodes::add);
        return nodes;
    }

    private Collection<Node> findRoots(Node node, String[] path) {
        Collection<Node> roots = this.searchPossibleRoots(node, path[0], false);
        if (!roots.isEmpty()) {
            return roots;
        }
        for (Node root : this.model.components()) {
            if (!FileSystemUtils.getNameWithoutExtension(new File(root.file()).getName()).equals(path[0]) || path.length == 1) continue;
            roots = this.searchPossibleRoots(root, path[1], false);
            break;
        }
        return roots;
    }

    private Node resolve(String[] path, Collection<Node> roots) {
        if (roots.isEmpty()) {
            return null;
        }
        if (roots.size() == 1 && path.length == 1) {
            return roots.iterator().next();
        }
        for (Node root : roots) {
            Node candidate = this.resolvePathInNode(path, root);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    private Node resolvePathInNode(String[] path, Node node) {
        Node reference = null;
        for (String name : path) {
            if (reference == null) {
                reference = this.areNamesake(node, name) ? node : null;
                continue;
            }
            List components = reference.component(name);
            if (components.isEmpty() && reference.parent() != null) {
                reference = (Node)reference.parent().component(name).get(0);
            } else {
                Node node2 = reference = components.isEmpty() ? null : (Node)components.get(0);
            }
            if (reference != null) continue;
            return null;
        }
        return reference;
    }

    private Collection<Node> searchPossibleRoots(Node node, String name, boolean parent) {
        LinkedHashSet<Node> set = new LinkedHashSet<Node>();
        this.namesake(name, set, (NodeContainer)node);
        this.addInContext(name, set, node, parent);
        this.addNodeSiblings(name, node, set);
        this.addRoots(name, set);
        return set;
    }

    private void addRoots(String name, Set<Node> set) {
        set.addAll(this.model.components().stream().filter(node -> this.areNamesake((Node)node, name)).collect(Collectors.toList()));
    }

    private void addNodeSiblings(String identifier, Node container, Set<Node> set) {
        if (container == null) {
            return;
        }
        set.addAll(container.components().stream().filter(node -> this.areNamesake((Node)node, identifier)).collect(Collectors.toList()));
    }

    private void addInContext(String name, Set<Node> set, Node node, boolean parent) {
        this.checkSiblings(name, set, node);
        for (Node container = node.container(); container != null; container = container.container()) {
            Node parentNode;
            this.namesake(name, set, (NodeContainer)container);
            this.checkSiblings(name, set, container);
            if (!parent || (parentNode = node.parent()) == null) continue;
            this.collectParentComponents(name, set, container, parentNode);
        }
    }

    private void checkSiblings(String name, Set<Node> set, Node container) {
        for (Node sibling : container.siblings()) {
            this.namesake(name, set, (NodeContainer)sibling);
        }
    }

    private void collectParentComponents(String identifier, Set<Node> set, Node container, Node parent) {
        set.addAll(parent.components().stream().filter(sibling -> this.areNamesake((Node)sibling, identifier) && !sibling.equals((Object)container)).collect(Collectors.toList()));
    }

    private void namesake(String name, Set<Node> set, NodeContainer container) {
        if (container instanceof NodeImpl && this.areNamesake((Node)container, name)) {
            set.add((Node)container);
        }
    }

    private boolean areNamesake(Node node, String name) {
        return name.equals(node.name());
    }
}

