/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.codegeneration.magritte.stash;

import io.intino.Configuration;
import io.intino.magritte.Language;
import io.intino.magritte.compiler.codegeneration.Format;
import io.intino.magritte.compiler.codegeneration.magritte.NameFormatter;
import io.intino.magritte.compiler.codegeneration.magritte.natives.NativeFormatter;
import io.intino.magritte.compiler.codegeneration.magritte.stash.StashHelper;
import io.intino.magritte.compiler.codegeneration.magritte.stash.VariableFactory;
import io.intino.magritte.compiler.core.CompilerConfiguration;
import io.intino.magritte.compiler.model.Model;
import io.intino.magritte.compiler.model.NodeImpl;
import io.intino.magritte.io.Concept;
import io.intino.magritte.io.Helper;
import io.intino.magritte.io.Node;
import io.intino.magritte.io.Stash;
import io.intino.magritte.lang.model.EmptyNode;
import io.intino.magritte.lang.model.Parameter;
import io.intino.magritte.lang.model.Primitive;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.model.Valued;
import io.intino.magritte.lang.model.Variable;
import io.intino.magritte.lang.model.rules.variable.NativeRule;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class StashCreator {
    private final List<io.intino.magritte.lang.model.Node> nodes;
    private final Language language;
    private final File resourceFolder;
    private final Configuration.Artifact.Model.Level level;
    private final boolean test;
    private final Stash stash = new Stash();
    private final String outDSL;
    private final String workingPackage;

    public StashCreator(List<io.intino.magritte.lang.model.Node> nodes, Language language, String outDSL, CompilerConfiguration conf) {
        this.nodes = nodes;
        this.language = language;
        this.outDSL = Format.javaValidName().format(Format.firstUpperCase().format((Object)outDSL)).toString();
        this.workingPackage = conf.workingPackage();
        this.resourceFolder = conf.resourcesDirectory();
        this.level = conf.model().level();
        this.test = conf.isTest();
        this.stash.language = language.languageName();
        this.stash.path = new File(nodes.get(0).file()).getName().split("\\.")[0] + ".stash";
    }

    private static String toSystemIndependentName(String fileName) {
        return fileName.replace('\\', '/');
    }

    public Stash create() {
        this.nodes.forEach(node -> this.create((io.intino.magritte.lang.model.Node)node, null));
        this.stash.contentRules = this.collectContents(this.nodes.stream().filter(node -> !node.is(Tag.Component) && !node.isAspect() && !node.is(Tag.Instance)).collect(Collectors.toList()));
        return this.stash;
    }

    private void create(io.intino.magritte.lang.model.Node node, Concept container) {
        if (node.isReference()) {
            return;
        }
        if (node.is(Tag.Instance)) {
            if (container == null) {
                this.stash.nodes.add(this.createNode(node));
            } else {
                container.nodes.add(this.createNode(node));
            }
        } else {
            this.createConcept(node);
        }
    }

    private void createConcept(io.intino.magritte.lang.model.Node node) {
        if (node.isAspect()) {
            this.stash.concepts.addAll(this.createAspectConcept(node));
        } else {
            List<io.intino.magritte.lang.model.Node> nodeList = this.collectTypeComponents(node.components());
            Concept concept = Helper.newConcept((String)StashHelper.name(node, this.workingPackage), (boolean)node.isAbstract(), (boolean)node.type().equals("MetaConcept"), (node.isAspect() || node.isMetaAspect() ? 1 : 0) != 0, (node.container() instanceof Model && !node.is(Tag.Component) ? 1 : 0) != 0, (String)this.className(node), (String)(node.parent() != null ? Format.qualifiedName().format((Object)((NodeImpl)node.parent()).layerQualifiedName()).toString() : null), StashHelper.collectTypes(node, this.language), this.collectContents(nodeList), this.variablesOf(node), this.parametersOf(node), Collections.emptyList());
            this.stash.concepts.add(concept);
            for (io.intino.magritte.lang.model.Node component : node.components()) {
                this.create(component, concept);
            }
        }
    }

    private List<Concept> createAspectConcept(io.intino.magritte.lang.model.Node aspectNode) {
        ArrayList<Concept> concepts = new ArrayList<Concept>();
        Concept concept = new Concept();
        concepts.add(concept);
        concept.isMetaConcept = aspectNode.type().equals("MetaConcept");
        concept.isAbstract = aspectNode.isAbstract();
        concept.isAspect = true;
        concept.name = StashHelper.name(aspectNode, this.workingPackage);
        concept.className = this.aspectClassName(aspectNode);
        concept.types = StashHelper.collectTypes(aspectNode, this.language);
        concept.parent = this.calculateParent(aspectNode);
        concept.variables = this.variablesOf(aspectNode);
        concept.parameters = this.parametersOf(aspectNode);
        concept.contentRules = this.collectContents(this.collectTypeComponents(aspectNode.components()));
        for (io.intino.magritte.lang.model.Node component : aspectNode.components()) {
            this.create(component, concept);
        }
        return concepts;
    }

    private String className(io.intino.magritte.lang.model.Node node) {
        return this.workingPackage + "." + Format.withDollar().format(Format.noPackage().format((Object)NameFormatter.getQn(node, this.workingPackage))).toString();
    }

    private String aspectClassName(io.intino.magritte.lang.model.Node aspectNode) {
        return this.workingPackage + "." + Format.withDollar().format((Object)Format.noPackage().format((Object)NameFormatter.getQn(aspectNode, this.workingPackage)).toString());
    }

    private String calculateParent(io.intino.magritte.lang.model.Node node) {
        return node.parent() != null ? ((NodeImpl)node.parent()).layerQn() : null;
    }

    private Concept createChildAspectType(io.intino.magritte.lang.model.Node aspectNode, io.intino.magritte.lang.model.Node node, Concept parent) {
        Concept child = new Concept();
        child.name = StashHelper.name(aspectNode, this.workingPackage);
        child.parent = parent.name;
        child.isAbstract = aspectNode.isAbstract();
        child.className = this.aspectClassName(aspectNode);
        ArrayList<String> childTypes = new ArrayList<String>(parent.types);
        childTypes.add(parent.name);
        child.types = new ArrayList(childTypes);
        child.contentRules = parent.contentRules;
        return child;
    }

    private List<io.intino.magritte.lang.model.Node> collectTypeComponents(List<io.intino.magritte.lang.model.Node> nodes) {
        return nodes.stream().filter(component -> !component.is(Tag.Instance)).collect(Collectors.toList());
    }

    private List<Concept.Content> collectContents(List<io.intino.magritte.lang.model.Node> nodes) {
        return nodes.stream().filter(node -> !node.isAspect() && !node.is(Tag.Instance)).map(n -> new Concept.Content(n.isReference() ? ((NodeImpl)n.destinyOfReference()).layerQualifiedName() : ((NodeImpl)n).layerQualifiedName(), n.container().sizeOf(n).min(), n.container().sizeOf(n).max())).collect(Collectors.toList());
    }

    private List<Node> createNodes(List<io.intino.magritte.lang.model.Node> nodes) {
        return nodes.stream().map(this::createNode).collect(Collectors.toList());
    }

    private Node createNode(io.intino.magritte.lang.model.Node node) {
        Node instanceNode = new Node();
        instanceNode.name = this.buildReferenceName(node);
        instanceNode.layers = StashHelper.collectTypes(node, this.language);
        instanceNode.variables.addAll(this.parametersOf(node));
        instanceNode.nodes.addAll(this.createNodes(node.components()));
        return instanceNode;
    }

    private boolean isNotEmpty(Valued v) {
        return !v.values().isEmpty() && v.values().get(0) != null && !(v.values().get(0) instanceof EmptyNode);
    }

    private List<io.intino.magritte.io.Variable> variablesOf(io.intino.magritte.lang.model.Node node) {
        return node.variables().stream().filter(v -> this.isNotEmpty((Valued)v) && !v.isInherited()).map(this::transformTaraVariableToStashVariable).collect(Collectors.toList());
    }

    private List<io.intino.magritte.io.Variable> parametersOf(io.intino.magritte.lang.model.Node node) {
        return node.parameters().stream().filter(this::isNotEmpty).map(this::createVariableFromParameter).collect(Collectors.toList());
    }

    private io.intino.magritte.io.Variable transformTaraVariableToStashVariable(Variable modelVariable) {
        io.intino.magritte.io.Variable variable = VariableFactory.get(modelVariable.type());
        if (variable == null) {
            return null;
        }
        variable.name = modelVariable.name();
        variable.values = modelVariable.isReference() && !(modelVariable.values().get(0) instanceof Primitive.Expression) ? this.buildReferenceValues(modelVariable.values()) : (modelVariable.values().get(0) instanceof Primitive.Expression ? this.createNativeReference(modelVariable) : (modelVariable.type().equals((Object)Primitive.RESOURCE) && modelVariable.values().get(0).toString().startsWith("$") ? StashHelper.buildResourceValue(modelVariable.values(), modelVariable.file()) : this.getValue(modelVariable)));
        return variable;
    }

    private io.intino.magritte.io.Variable createVariableFromParameter(Parameter parameter) {
        io.intino.magritte.io.Variable variable = VariableFactory.get(parameter.type());
        if (variable == null) {
            return null;
        }
        variable.name = parameter.name();
        variable.values = parameter.hasReferenceValue() ? this.buildReferenceValues(parameter.values()) : (parameter.values().get(0) instanceof Primitive.Expression ? this.createNativeReference(parameter) : (parameter.type().equals((Object)Primitive.RESOURCE) && parameter.values().get(0).toString().startsWith("$") ? StashHelper.buildResourceValue(parameter.values(), parameter.file()) : this.getValue(parameter)));
        return variable;
    }

    private List<Object> createNativeReference(Variable variable) {
        String aPackage = NativeFormatter.calculatePackage(variable.container());
        return new ArrayList<Object>(Collections.singletonList(this.reactivePrefix((Valued)variable) + this.workingPackage.toLowerCase() + ".natives." + (String)(aPackage.isEmpty() ? "" : aPackage + ".") + Format.javaValidName().format(Format.firstUpperCase().format((Object)variable.name())).toString() + "_" + variable.getUID()));
    }

    private List<Object> createNativeReference(Parameter parameter) {
        String aPackage = NativeFormatter.calculatePackage(parameter.container());
        return new ArrayList<Object>(Collections.singletonList(this.reactivePrefix((Valued)parameter) + this.workingPackage.toLowerCase() + ".natives." + (String)(aPackage.isEmpty() ? "" : aPackage + ".") + Format.javaValidName().format(Format.firstUpperCase().format((Object)parameter.name())).toString() + "_" + parameter.getUID()));
    }

    private String reactivePrefix(Valued variable) {
        return variable.type().equals((Object)Primitive.FUNCTION) || variable.flags().contains(Tag.Reactive) ? "" : "$@";
    }

    private List<Object> getValue(Variable variable) {
        if (variable.values().get(0) instanceof EmptyNode) {
            return new ArrayList<Object>();
        }
        return new ArrayList<Object>(StashHelper.hasToBeConverted(variable.values(), variable.type()) ? this.convert((Valued)variable) : (variable.rule() instanceof NativeRule ? this.formatNativeReferenceOfVariable(variable.values()) : variable.values()));
    }

    private List<Object> formatNativeReferenceOfVariable(List<Object> values) {
        return values.stream().map(value -> "$@" + value.toString()).collect(Collectors.toList());
    }

    private List<Object> getValue(Parameter parameter) {
        if (parameter.values().get(0) instanceof EmptyNode) {
            return new ArrayList<Object>();
        }
        return new ArrayList<Object>(StashHelper.hasToBeConverted(parameter.values(), parameter.type()) ? this.convert((Valued)parameter) : parameter.values());
    }

    private List<?> convert(Valued valued) {
        Primitive type = valued.type();
        if (type.equals((Object)Primitive.WORD)) {
            return Primitive.WORD.convert(valued.values().toArray());
        }
        if (type.equals((Object)Primitive.LONG) && this.areIntegers(valued)) {
            return valued.values().stream().map(v -> (long)((Integer)v)).collect(Collectors.toList());
        }
        if (type.equals((Object)Primitive.INSTANT)) {
            return Primitive.INSTANT.convert(valued.values().toArray(new String[0]));
        }
        if (type.equals((Object)Primitive.RESOURCE)) {
            return valued.values().stream().map(o -> this.relative((File)o)).collect(Collectors.toList());
        }
        return type.convert(valued.values().toArray(new String[0]));
    }

    private boolean areIntegers(Valued valued) {
        return valued.values().stream().allMatch(v -> v instanceof Integer);
    }

    private String relative(File file) {
        String resources;
        String path = StashCreator.toSystemIndependentName(file.getAbsolutePath());
        return path.equals(resources = StashCreator.toSystemIndependentName(this.resourceFolder.getAbsolutePath())) ? path : path.substring(resources.length() + 1);
    }

    private List<Object> buildReferenceValues(List<Object> values) {
        if (values.get(0) instanceof EmptyNode) {
            return new ArrayList<Object>();
        }
        return values.stream().map(this::buildReferenceName).collect(Collectors.toList());
    }

    private String buildReferenceName(Object o) {
        if (o instanceof Primitive.Reference && !((Primitive.Reference)o).isToInstance()) {
            return this.nodeStashQualifiedName(((Primitive.Reference)o).reference());
        }
        if (o instanceof io.intino.magritte.lang.model.Node) {
            return this.nodeStashQualifiedName((io.intino.magritte.lang.model.Node)o);
        }
        return StashHelper.buildInstanceReference(o);
    }

    private String nodeStashQualifiedName(io.intino.magritte.lang.model.Node node) {
        return (String)(node.is(Tag.Instance) ? this.getStash(node) + "#" : "") + ((NodeImpl)node).layerQn();
    }

    private String getStash(io.intino.magritte.lang.model.Node node) {
        return this.test || this.level.compareLevelWith(Configuration.Artifact.Model.Level.Solution) == 0 ? this.getStashByNode(node) : this.outDSL;
    }

    private String getStashByNode(io.intino.magritte.lang.model.Node node) {
        String file = new File(node.file()).getName();
        return file.substring(0, file.lastIndexOf("."));
    }
}

