/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.codegeneration.magritte.layer;

import io.intino.Configuration;
import io.intino.itrules.Adapter;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.FrameBuilderContext;
import io.intino.magritte.Language;
import io.intino.magritte.Resolver;
import io.intino.magritte.compiler.codegeneration.Format;
import io.intino.magritte.compiler.codegeneration.magritte.Generator;
import io.intino.magritte.compiler.codegeneration.magritte.NameFormatter;
import io.intino.magritte.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.compiler.codegeneration.magritte.layer.GraphTemplate;
import io.intino.magritte.compiler.codegeneration.magritte.layer.LayerVariableAdapter;
import io.intino.magritte.compiler.model.Model;
import io.intino.magritte.compiler.model.NodeImpl;
import io.intino.magritte.dsl.Meta;
import io.intino.magritte.dsl.Proteo;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.model.Variable;
import io.intino.magritte.lang.model.rules.Size;
import java.util.Collection;
import java.util.stream.Collectors;

public class AbstractGraphCreator
extends Generator
implements TemplateTags {
    private final Configuration.Artifact.Model.Level modelLevel;

    public AbstractGraphCreator(Language language, String outDSL, Configuration.Artifact.Model.Level modelLevel, String workingPackage, String languageWorkingPackage) {
        super(language, outDSL, workingPackage, languageWorkingPackage);
        this.modelLevel = modelLevel;
    }

    public String create(Model model) {
        FrameBuilder builder = new FrameBuilder(new String[]{"graph"});
        builder.add("workingPackage", (Object)this.workingPackage);
        builder.add("name", (Object)this.outDsl);
        this.collectMainNodes(model).stream().filter(node -> node.name() != null).forEach(node -> builder.add("node", (Object)this.createRootNodeFrame((Node)node, model.sizeOf((Node)node))));
        return Format.customize(new GraphTemplate()).render((Object)builder.toFrame());
    }

    private Frame createRootNodeFrame(Node node, Size size) {
        FrameBuilder builder = new FrameBuilder(new String[]{"node"});
        if (size.isSingle()) {
            builder.add("single");
        }
        if (node.isTerminal()) {
            builder.add("concept");
        }
        if (node.is(Tag.Instance)) {
            builder.add("instance");
        }
        if (node.isAbstract()) {
            builder.add("abstract");
        }
        String qn = NameFormatter.getQn(node, this.workingPackage.toLowerCase());
        builder.add("qn", (Object)qn);
        builder.add("stashQn", (Object)qn);
        builder.add("generatedLanguage", (Object)this.outDsl);
        this.addType(node, size, builder);
        builder.add("name", (Object)node.name());
        node.variables().stream().filter(variable -> variable.values().isEmpty()).forEach(variable -> builder.add("variable", (Object)this.frameOf((Variable)variable)));
        this.addTerminalVariables(node, (FrameBuilderContext)builder);
        return builder.toFrame();
    }

    private void addType(Node node, Size rule, FrameBuilder builder) {
        if (!(this.language instanceof Proteo) && !(this.language instanceof Meta)) {
            builder.add("conceptLayer", (Object)this.language.doc(node.type()).layer());
        }
        builder.add("type", (Object)this.nodeType(node, rule));
    }

    private String nodeType(Node node, Size rule) {
        return Resolver.shortType((String)node.type()) + (!rule.isSingle() ? "List" : "");
    }

    private Frame frameOf(Variable variable) {
        return new FrameBuilder(new String[]{"variable", variable.type().getName()}).put(Variable.class, (Adapter)new LayerVariableAdapter(this.language, this.outDsl, this.modelLevel, this.workingPackage, this.languageWorkingPackage)).append((Object)variable).toFrame();
    }

    private Collection<Node> collectMainNodes(Model model) {
        return model.components().stream().filter(n -> !n.is(Tag.Component) && !n.into(Tag.Component) && !n.is(Tag.Feature) && !n.into(Tag.Feature) && !((NodeImpl)n).isVirtual()).collect(Collectors.toList());
    }
}

