/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.core.operation.model;

import io.intino.magritte.compiler.core.CompilationUnit;
import io.intino.magritte.compiler.core.CompilerConfiguration;
import io.intino.magritte.compiler.core.SourceUnit;
import io.intino.magritte.compiler.core.errorcollection.DependencyException;
import io.intino.magritte.compiler.core.errorcollection.message.DependencyErrorMessage;
import io.intino.magritte.compiler.core.errorcollection.message.WarningMessage;
import io.intino.magritte.compiler.core.operation.model.ModelOperation;
import io.intino.magritte.compiler.dependencyresolution.DependencyResolver;
import io.intino.magritte.compiler.dependencyresolution.InheritanceResolver;
import io.intino.magritte.compiler.dependencyresolution.NativeResolver;
import io.intino.magritte.compiler.dependencyresolution.TerminalResolver;
import io.intino.magritte.compiler.model.Model;
import io.intino.magritte.lang.model.Element;
import java.util.Collection;
import java.util.logging.Logger;

public class ModelDependencyResolutionOperation
extends ModelOperation {
    private static final Logger LOG = Logger.getGlobal();
    private final CompilationUnit unit;

    public ModelDependencyResolutionOperation(CompilationUnit unit) {
        this.unit = unit;
    }

    @Override
    public void call(Model model) {
        try {
            CompilerConfiguration conf = this.unit.configuration();
            if (conf.isVerbose()) {
                this.unit.configuration().out().println("@#$%@# Presentable:[" + conf.getModule() + " - " + conf.model().outDsl() + "] Resolving dependencies...");
            }
            DependencyResolver dependencyResolver = new DependencyResolver(model, conf.workingPackage(), conf.rulesDirectory(), conf.getSemanticRulesLib(), conf.getTempDirectory());
            dependencyResolver.resolve();
            this.notifyRulesNotLoaded(dependencyResolver);
            new InheritanceResolver(model).resolve();
            new TerminalResolver(model, conf.model().level()).resolve();
            new NativeResolver(model, conf.functionsDirectory()).resolve();
        }
        catch (DependencyException e) {
            LOG.severe("Error during dependency resolution: " + e.getMessage());
            this.unit.getErrorCollector().addError(DependencyErrorMessage.create(e, this.unit.getSourceUnits().get(e.getElement().file())), true);
        }
    }

    private void notifyRulesNotLoaded(DependencyResolver dependencyResolver) {
        for (DependencyException entry : dependencyResolver.rulesNotLoaded()) {
            SourceUnit sourceFromFile = this.getSourceFromFile(this.unit.getSourceUnits().values(), entry.getElement());
            this.unit.getErrorCollector().addWarning(new WarningMessage(3, entry.getMessage(), sourceFromFile, entry.getLine(), entry.getElement().column()));
        }
    }

    private SourceUnit getSourceFromFile(Collection<SourceUnit> values, Element origin) {
        if (origin == null) {
            return null;
        }
        for (SourceUnit value : values) {
            if (!value.getName().equals(origin.file())) continue;
            return value;
        }
        return null;
    }
}

