/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.core.operation.model;

import io.intino.magritte.compiler.codegeneration.lang.LanguageSerializer;
import io.intino.magritte.compiler.core.CompilationUnit;
import io.intino.magritte.compiler.core.errorcollection.CompilationFailedException;
import io.intino.magritte.compiler.core.errorcollection.TaraException;
import io.intino.magritte.compiler.core.operation.model.ModelCollectionOperation;
import io.intino.magritte.compiler.model.Model;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenerateLanguageOperation
extends ModelCollectionOperation {
    private static final Logger LOG = Logger.getGlobal();
    private final CompilationUnit unit;

    public GenerateLanguageOperation(CompilationUnit unit) {
        this.unit = unit;
    }

    @Override
    public void call(Collection<Model> models) {
        try {
            if (this.unit.configuration().model().level().isSolution()) {
                return;
            }
            if (this.unit.configuration().isVerbose()) {
                this.unit.configuration().out().println("@#$%@# Presentable:[" + this.unit.configuration().getModule() + " - " + this.unit.configuration().model().outDsl() + "] Generating language...");
            }
            new LanguageSerializer(this.unit.configuration(), models).serialize();
            this.unit.getErrorCollector().failIfErrors();
        }
        catch (TaraException e) {
            LOG.log(Level.SEVERE, "Error during language generation: " + e.getMessage() + "\n", e);
            throw new CompilationFailedException(10, this.unit, e);
        }
    }
}

