/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.core.operation;

import io.intino.Configuration;
import io.intino.magritte.Language;
import io.intino.magritte.compiler.codegeneration.Format;
import io.intino.magritte.compiler.codegeneration.magritte.stash.StashCreator;
import io.intino.magritte.compiler.core.CompilationUnit;
import io.intino.magritte.compiler.core.CompilerConfiguration;
import io.intino.magritte.compiler.core.errorcollection.CompilationFailedException;
import io.intino.magritte.compiler.core.errorcollection.TaraException;
import io.intino.magritte.compiler.core.operation.model.ModelOperation;
import io.intino.magritte.compiler.model.Model;
import io.intino.magritte.io.Stash;
import io.intino.magritte.io.StashSerializer;
import io.intino.magritte.lang.model.Node;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StashGenerationOperation
extends ModelOperation {
    public static final String STASH = ".stash";
    private static final Logger LOG = Logger.getLogger(StashGenerationOperation.class.getName());
    private final CompilationUnit compilationUnit;
    private final CompilerConfiguration conf;
    private String outDSL;

    public StashGenerationOperation(CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
        this.conf = compilationUnit.configuration();
    }

    @Override
    public void call(Model model) {
        this.outDSL = this.conf.model().level().isSolution() ? this.conf.getModule() : this.conf.model().outDsl();
        try {
            if (this.conf.isVerbose()) {
                this.conf.out().println("@#$%@# Presentable:[" + this.conf.getModule() + " - " + this.conf.model().outDsl() + "] Generating Stashes...");
            }
            if (this.conf.isTest() || this.conf.model().level().equals((Object)Configuration.Artifact.Model.Level.Solution)) {
                this.createSeparatedStashes(model);
            } else {
                this.createFullStash(model);
            }
        }
        catch (TaraException e) {
            LOG.log(Level.SEVERE, "Error during stash generation: " + e.getMessage(), e);
            throw new CompilationFailedException(this.compilationUnit.getPhase(), this.compilationUnit, e);
        }
    }

    private void createSeparatedStashes(Model model) throws TaraException {
        for (List<Node> nodes : this.pack(model)) {
            if (nodes.isEmpty()) continue;
            this.writeStashTo(this.stashDestiny(new File(nodes.get(0).file())), this.stashOf(nodes, model.language()));
        }
    }

    private void createFullStash(Model model) throws TaraException {
        if (model.components().isEmpty()) {
            return;
        }
        this.writeStashTo(this.stashDestiny(new File(model.components().get(0).file())), this.stashOf(model.components(), model.language()));
    }

    private Stash stashOf(List<Node> nodes, Language language) throws TaraException {
        try {
            return new StashCreator(nodes, language, this.outDSL, this.conf).create();
        }
        catch (Throwable e) {
            throw new TaraException("Error creating stashes: " + e.getMessage());
        }
    }

    private void writeStashTo(File taraFile, Stash stash) {
        byte[] content = StashSerializer.serialize((Stash)stash);
        File file = this.stashDestiny(taraFile);
        stash.path = file.getName();
        file.getParentFile().mkdirs();
        try (FileOutputStream stream = new FileOutputStream(file);){
            stream.write(content);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error writing stashes: " + e.getMessage(), e);
            throw new CompilationFailedException(this.compilationUnit.getPhase(), this.compilationUnit, e);
        }
        file.getPath();
    }

    private File stashDestiny(File taraFile) {
        File destiny = this.conf.resourcesDirectory();
        destiny.mkdirs();
        return this.conf.isTest() || this.conf.model().level().isSolution() ? new File(destiny, taraFile.getName().split("\\.")[0] + STASH) : new File(destiny, Format.firstUpperCase().format((Object)this.conf.model().outDsl()).toString() + STASH);
    }

    private List<List<Node>> pack(Model model) {
        HashMap<String, List<Node>> nodes = new HashMap<String, List<Node>>();
        for (Node node : model.components()) {
            if (!nodes.containsKey(node.file())) {
                nodes.put(node.file(), new ArrayList());
            }
            ((List)nodes.get(node.file())).add(node);
        }
        return this.pack(nodes);
    }

    private List<List<Node>> pack(Map<String, List<Node>> nodes) {
        return new ArrayList<List<Node>>(nodes.values());
    }
}

