/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.codegeneration.magritte.layer;

import io.intino.Configuration;
import io.intino.itrules.Adapter;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.FrameBuilderContext;
import io.intino.magritte.Language;
import io.intino.magritte.Resolver;
import io.intino.magritte.compiler.codegeneration.magritte.Generator;
import io.intino.magritte.compiler.codegeneration.magritte.NameFormatter;
import io.intino.magritte.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.compiler.codegeneration.magritte.layer.TypesProvider;
import io.intino.magritte.compiler.model.Model;
import io.intino.magritte.compiler.model.NodeImpl;
import io.intino.magritte.compiler.model.NodeReference;
import io.intino.magritte.dsl.Meta;
import io.intino.magritte.dsl.Proteo;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.Rule;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.model.Variable;
import io.intino.magritte.lang.model.rules.Size;
import io.intino.magritte.lang.semantics.Constraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class NodeAdapter
extends Generator
implements Adapter<Node>,
TemplateTags {
    private final Model model;
    private final Configuration.Artifact.Model.Level level;
    private Node initNode;
    private FrameBuilderContext context;

    NodeAdapter(String outDsl, Model model, Configuration.Artifact.Model.Level level, Language language, Node initNode, String workingPackage, String languageWorkingPackage) {
        super(language, outDsl, workingPackage, languageWorkingPackage);
        this.model = model;
        this.level = level;
        this.initNode = initNode;
    }

    public void adapt(Node node, FrameBuilderContext context) {
        this.context = context;
        TypesProvider.getTypes(node, this.language).forEach(arg_0 -> ((FrameBuilderContext)context).add(arg_0));
        context.add("modelType", (Object)(this.level == Configuration.Artifact.Model.Level.Platform ? "Platform" : "Product"));
        this.addNodeInfo(node, context);
        this.addVariables(node, context);
        this.addComponents(node, context);
        this.addNonAbstractCreates(node, context);
        this.addAspectClasses(node, context);
        this.addAllowedAspects(node, context);
        if (node.isAspect()) {
            this.addAspectConstrains(node, context);
            this.addTargetComponents(node, context);
            this.addAspect(node, node.container(), context);
        }
        this.addParent(node, context);
    }

    private void addAspectClasses(Node node, FrameBuilderContext context) {
        if (node.isReference()) {
            return;
        }
        this.aspectNodes(node).forEach(aspectNode -> this.addAspectSlot(context, (Node)aspectNode));
    }

    private Stream<Node> aspectNodes(Node node) {
        return node.components().stream().filter(n -> !n.isReference() && n.isAspect());
    }

    private void addAspectSlot(FrameBuilderContext context, Node aspectNode) {
        context.add("node", (Object)FrameBuilder.from((FrameBuilderContext)context).append((Object)aspectNode).add("aspect").toFrame());
    }

    private void addAspect(Node aspect, Node target, FrameBuilderContext context) {
        String qn = NameFormatter.cleanQn(NameFormatter.getQn(target, this.workingPackage));
        FrameBuilder builder = new FrameBuilder().add("aspect").add("name", (Object)target.name()).add("qn", (Object)qn).add("generatedLanguage", (Object)this.outDsl);
        if (aspect.isSub() && aspect.parent() != null) {
            builder.add("overriden");
        }
        context.add("aspect", (Object)builder.toFrame());
        context.add("core", (Object)new FrameBuilder().add("core").add("qn", (Object)qn).add("name", (Object)target.name()).toFrame());
    }

    private void addTargetComponents(Node node, FrameBuilderContext context) {
        node.container().components().stream().filter(c -> !c.isAspect()).forEach(c -> {
            if (!this.isOverriden((Node)c, node)) {
                FrameBuilder builder = FrameBuilder.from((FrameBuilderContext)context).append(c).add("target");
                if ((c instanceof NodeReference && !((NodeReference)c).isHas() || c instanceof NodeImpl) && c.destinyOfReference().parent() != null) {
                    builder.add("inherited").add("parentRef", (Object)c.destinyOfReference().parent().qualifiedName());
                }
                builder.add("targetContainer", (Object)node.container().name());
                if (node.container().sizeOf(c).isSingle()) {
                    builder.add("single");
                }
                context.add("node", (Object)builder.toFrame());
            }
        });
    }

    private void addNodeInfo(Node node, FrameBuilderContext context) {
        boolean decorable;
        context.add("generatedLanguage", (Object)this.outDsl).add("workingPackage", (Object)this.workingPackage);
        if (this.initNode != null && !node.equals((Object)this.initNode)) {
            context.add("inner", (Object)true);
        }
        if (node.doc() != null) {
            context.add("doc", (Object)node.doc());
        }
        if (node.container() != null) {
            context.add("containerName", (Object)node.container().name());
        }
        this.addType(context, node);
        this.addName(this.context, node);
        boolean bl = decorable = node.is(Tag.Decorable) || NodeAdapter.isInDecorable(node);
        if (node.isAbstract() || decorable) {
            context.add("abstract", (Object)true);
        }
        if (decorable) {
            context.add("decorable", (Object)true);
        }
        node.flags().stream().filter(this.isLayerInterface()).forEach(tag -> context.add("flag", tag));
        if (node.parent() != null) {
            context.add("child");
        }
        if (node.components().stream().anyMatch(c -> c.is(Tag.Instance))) {
            context.add("metaType", (Object)(this.languageWorkingPackage + "." + this.metaType(node)));
        }
    }

    private void addNonAbstractCreates(Node node, FrameBuilderContext context) {
        if (node instanceof NodeReference) {
            return;
        }
        List components = node.components();
        components.stream().filter(c -> !c.isAnonymous()).forEach(c -> {
            ArrayList children = new ArrayList();
            this.collectChildren((Node)c).stream().filter(n -> !n.isAnonymous() && !n.isAbstract() && !n.isAspect() && !components.contains(n)).forEach(n -> children.add(this.createFrame(n.isReference() ? n.destinyOfReference() : n)));
            for (FrameBuilder child : children) {
                context.add("create", (Object)child.add("node").add("owner").toFrame());
            }
        });
    }

    private FrameBuilder createFrame(Node node) {
        FrameBuilder builder = new FrameBuilder(new String[]{"reference", "create"});
        TypesProvider.getTypes(node, this.language).forEach(arg_0 -> ((FrameBuilder)builder).add(arg_0));
        this.addName((FrameBuilderContext)builder, node);
        this.addVariables(node, (FrameBuilderContext)builder);
        return builder;
    }

    private List<Node> collectChildren(Node parent) {
        HashSet<Node> set = new HashSet<Node>();
        for (Node child : parent.children()) {
            set.add(child);
            set.addAll(this.collectChildren(child));
        }
        return new ArrayList<Node>(set);
    }

    private void addType(FrameBuilderContext frame, Node node) {
        if (!(this.language instanceof Proteo) && !(this.language instanceof Meta)) {
            frame.add("conceptLayer", (Object)this.language.doc(node.type()).layer());
            frame.add("type", (Object)this.nodeType(node, this.sizeConstraint(node)));
        }
    }

    private Size sizeConstraint(Node node) {
        Constraint.Component constraint = this.language.constraints(node.container().type()).stream().filter(c -> c instanceof Constraint.Component && ((Constraint.Component)c).type().equals(node.type())).findFirst().orElse(null);
        if (constraint == null) {
            return Size.MULTIPLE();
        }
        return (Size)constraint.rules().stream().filter(rule -> rule instanceof Size).findFirst().orElse((Rule)Size.MULTIPLE());
    }

    private String nodeType(Node node, Size size) {
        return Resolver.shortType((String)node.type()) + (!size.isSingle() ? "List" : "");
    }

    private void addAllowedAspects(Node node, FrameBuilderContext context) {
        this.allowedAspects(node).forEach(aspect -> {
            FrameBuilder builder = new FrameBuilder(new String[]{"availableAspect"});
            builder.add("name", (Object)aspect.name());
            if (aspect.isAbstract()) {
                builder.add("abstract");
            }
            if (node.isAbstract()) {
                builder.add("abstract", (Object)"null");
            }
            String qn = NameFormatter.cleanQn(NameFormatter.getQn(aspect, this.workingPackage));
            builder.add("qn", (Object)qn);
            builder.add("stashQn", (Object)qn);
            aspect.variables().stream().filter(v -> v.size().isRequired()).forEach(variable -> builder.add("variable", (Object)FrameBuilder.from((FrameBuilderContext)context).append(variable).add("required").add("container", (Object)(NodeAdapter.isInDecorable(node) ? node.qualifiedName() : node.name())).toFrame()));
            context.add("availableAspect", (Object)builder.toFrame());
        });
    }

    private Collection<Node> allowedAspects(Node node) {
        HashSet<Node> nodes = new HashSet<Node>();
        for (Node aspectNode : node.components().stream().filter(Node::isAspect).collect(Collectors.toList())) {
            if (aspectNode.isReference()) continue;
            nodes.add(aspectNode);
            nodes.addAll(this.collectChildren(aspectNode));
        }
        return nodes;
    }

    private void addName(FrameBuilderContext context, Node node) {
        if (node.name() != null) {
            context.add("name", (Object)node.name());
        }
        String qn = NameFormatter.cleanQn(this.buildQN(node));
        context.add("qn", (Object)qn).add("stashQn", (Object)qn);
    }

    private String buildQN(Node node) {
        return NameFormatter.getQn(node instanceof NodeReference ? ((NodeReference)node).destination() : node, this.workingPackage.toLowerCase());
    }

    private void addVariables(Node node, FrameBuilderContext context) {
        node.variables().forEach(v -> {
            FrameBuilder builder = FrameBuilder.from((FrameBuilderContext)this.context).add("owner").append(v).add("container", (Object)(NodeAdapter.isInDecorable(node) ? this.completeName(node) : node.name()));
            context.add("variable", (Object)builder.toFrame());
        });
        if (node.isAspect()) {
            node.container().variables().stream().filter(variable -> !variable.isInherited() && !this.isOverriden(node, (Variable)variable)).forEach(variable -> context.add("variable", (Object)FrameBuilder.from((FrameBuilderContext)context).append(variable).add("target").add("container", (Object)(NodeAdapter.isInDecorable(node) ? this.completeName(node) : node.name())).toFrame()));
            node.aspectConstraints().forEach(c -> c.node().variables().forEach(v -> context.add("variable", (Object)FrameBuilder.from((FrameBuilderContext)context).append(v).add("target").add("container", (Object)(NodeAdapter.isInDecorable(node) ? this.completeName(node) : node.name())).toFrame())));
        }
        this.addTerminalVariables(node, context);
    }

    private String completeName(Node node) {
        return node.qualifiedName();
    }

    private boolean isOverriden(Node node, Variable variable) {
        return node.variables().stream().anyMatch(var -> var.name().equals(variable.name()));
    }

    private boolean isOverriden(Node targetNodeComponent, Node aspectNode) {
        return aspectNode.components().stream().anyMatch(component -> component.name() != null && component.name().equals(targetNodeComponent.name()));
    }

    private void addAspectConstrains(Node node, FrameBuilderContext context) {
        node.aspectConstraints().forEach(c -> context.add("constraint", (Object)new FrameBuilder(new String[]{"constraint"}).add("name", (Object)c.node().name()).add("qn", (Object)NameFormatter.cleanQn(NameFormatter.getQn(c.node(), this.workingPackage))).toFrame()));
    }

    void setInitNode(Node initNode) {
        this.initNode = initNode;
    }
}

