/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler.codegeneration.lang;

import io.intino.Configuration;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.magritte.Language;
import io.intino.magritte.compiler.codegeneration.magritte.Generator;
import io.intino.magritte.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.compiler.model.VariableReference;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.Parameter;
import io.intino.magritte.lang.model.Rule;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.model.Variable;
import io.intino.magritte.lang.model.rules.Size;
import io.intino.magritte.lang.model.rules.variable.NativeRule;
import io.intino.magritte.lang.model.rules.variable.VariableCustomRule;
import io.intino.magritte.lang.model.rules.variable.VariableRule;
import io.intino.magritte.lang.semantics.Constraint;
import io.intino.magritte.lang.semantics.constraints.parameter.ReferenceParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class LanguageParameterAdapter
extends Generator
implements TemplateTags {
    private final Language language;
    private final Configuration.Artifact.Model.Level level;

    LanguageParameterAdapter(Language language, String outDSL, String workingPackage, String languageWorkingPackage, Configuration.Artifact.Model.Level level) {
        super(language, outDSL, workingPackage, languageWorkingPackage);
        this.language = language;
        this.level = level;
    }

    static int terminalParameters(Language language, Node node) {
        int index = 0;
        List constraints = language.constraints(node.type());
        if (constraints == null) {
            return 0;
        }
        for (Constraint c : constraints) {
            if (!LanguageParameterAdapter.isSuitableParameter(node, c)) continue;
            ++index;
        }
        return index;
    }

    private static boolean isSuitableParameter(Node node, Constraint c) {
        return c instanceof Constraint.Parameter && LanguageParameterAdapter.isTerminal((Constraint.Parameter)c) && !LanguageParameterAdapter.isRedefined((Constraint.Parameter)c, node.variables()) && !LanguageParameterAdapter.isRequired((Constraint.Parameter)c) && !LanguageParameterAdapter.isFilled(node, (Constraint.Parameter)c);
    }

    private static boolean isTerminal(Constraint.Parameter constraint) {
        for (Tag flag : constraint.flags()) {
            if (!flag.equals((Object)Tag.Terminal)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRequired(Constraint.Parameter constraint) {
        return constraint.size().isRequired();
    }

    private static boolean isRedefined(Constraint.Parameter constraint, List<? extends Variable> variables) {
        for (Variable variable : variables) {
            if (!variable.name().equals(constraint.name())) continue;
            return true;
        }
        return false;
    }

    private static boolean isFilled(Node node, Constraint.Parameter constraint) {
        for (Parameter parameter : node.parameters()) {
            if (!parameter.name().equals(constraint.name()) || constraint.size() != null && !constraint.size().accept(parameter.values())) continue;
            return true;
        }
        return false;
    }

    void addParameterConstraint(FrameBuilder frame, String aspect, int position, Variable variable, String relation) {
        if (variable instanceof VariableReference) {
            frame.add(relation, (Object)this.referenceParameter(position, aspect, variable, relation));
        } else {
            frame.add(relation, (Object)this.primitiveParameter(position, aspect, variable, relation));
        }
    }

    int addTerminalParameterConstraints(Node node, FrameBuilder constraintsFrame) {
        int index = 0;
        List constraints = this.language.constraints(node.type());
        if (constraints == null) {
            return 0;
        }
        for (Constraint c : constraints) {
            if (!LanguageParameterAdapter.isSuitableParameter(node, c)) continue;
            this.addTerminalParameter(constraintsFrame, (Constraint.Parameter)c, index, "constraint");
            ++index;
        }
        return index;
    }

    private void addTerminalParameter(FrameBuilder builder, Constraint.Parameter parameter, int position, String type) {
        if (parameter instanceof ReferenceParameter) {
            builder.add(type, (Object)this.referenceParameter((ReferenceParameter)parameter, position, type));
        } else {
            builder.add(type, (Object)this.primitiveParameter(parameter, position, type));
        }
    }

    private void addDefaultInfo(int position, Variable variable, FrameBuilder frame) {
        FrameBuilder ruleFrame;
        Frame rule;
        frame.add("position", (Object)position);
        frame.add("tags", (Object)this.getFlags(variable));
        frame.add("scope", (Object)this.workingPackage);
        frame.add("size", (Object)(this.isTerminal(variable) ? this.transformSizeRuleOfTerminalNode(variable) : new FrameBuilder().append((Object)variable.size()).toFrame()));
        Frame frame2 = rule = variable.rule() == null || variable.rule() instanceof VariableCustomRule && ((VariableCustomRule)variable.rule()).loadedClass() == null ? null : this.ruleToFrame((Rule)variable.rule()).toFrame();
        if (rule != null) {
            frame.add("rule", (Object)rule);
        } else if (variable.flags().contains(Tag.Reactive) && (ruleFrame = this.ruleToFrame((Rule)new NativeRule("", "", Collections.emptyList()))) != null) {
            frame.add("rule", (Object)ruleFrame.toFrame());
        }
    }

    private boolean isTerminal(Variable variable) {
        return variable.isTerminal() && !variable.container().isTerminal() && Configuration.Artifact.Model.Level.Product.compareLevelWith(this.level) > 0;
    }

    private Frame transformSizeRuleOfTerminalNode(Variable variable) {
        Size rule = variable.size();
        Size size = new Size(0, rule.max(), rule);
        return new FrameBuilder().append((Object)size).toFrame();
    }

    private Frame referenceParameter(int i, String aspect, Variable variable, String relation) {
        FrameBuilder builder = new FrameBuilder(new String[]{relation, "parameter", "reference"}).add("name", (Object)variable.name()).add("aspect", (Object)aspect).add("type", (Object)variable.destinyOfReference().qualifiedName());
        this.addDefaultInfo(i, variable, builder);
        return builder.toFrame();
    }

    private Frame primitiveParameter(int i, String aspect, Variable variable, String relation) {
        FrameBuilder builder = new FrameBuilder(new String[]{relation, "parameter"}).add("name", (Object)variable.name()).add("aspect", (Object)aspect).add("type", (Object)variable.type());
        this.addDefaultInfo(i, variable, builder);
        return builder.toFrame();
    }

    private Frame referenceParameter(ReferenceParameter parameter, int position, String type) {
        FrameBuilder builder = new FrameBuilder(new String[]{type, "parameter", "reference"}).add("name", (Object)parameter.name()).add("aspect", (Object)parameter.aspect());
        this.addDefaultInfo((Constraint.Parameter)parameter, builder, position);
        return builder.toFrame();
    }

    private Frame primitiveParameter(Constraint.Parameter parameter, int position, String type) {
        FrameBuilder builder = new FrameBuilder(new String[]{type, "parameter"}).add("aspect", (Object)parameter.aspect()).add("name", (Object)parameter.name()).add("type", (Object)parameter.type());
        this.addDefaultInfo(parameter, builder, position);
        return builder.toFrame();
    }

    private void addDefaultInfo(Constraint.Parameter parameter, FrameBuilder frame, int position) {
        frame.add("size", (Object)new FrameBuilder().append((Object)new Size(1, parameter.size().max())).toFrame());
        frame.add("position", (Object)position);
        frame.add("tags", (Object)this.getFlags(parameter));
        Frame rule = this.calculateRule(parameter);
        if (rule != null) {
            frame.add("rule", (Object)rule);
        }
    }

    private Frame calculateRule(Constraint.Parameter parameter) {
        VariableRule rule = parameter.rule();
        if (rule == null) {
            return null;
        }
        FrameBuilder builder = this.ruleToFrame((Rule)rule);
        return builder.add(parameter.type().getName()).toFrame();
    }

    private String[] getFlags(Variable variable) {
        return (String[])variable.flags().stream().map(Enum::name).toArray(String[]::new);
    }

    private String[] getFlags(Constraint.Parameter variable) {
        ArrayList<Tag> flags = new ArrayList<Tag>();
        for (Tag tag : variable.flags()) {
            if (tag.equals((Object)Tag.Terminal)) {
                flags.add(Tag.Instance);
                continue;
            }
            flags.add(tag);
        }
        return (String[])flags.stream().map(Enum::name).toArray(String[]::new);
    }
}

