/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.compiler;

import io.intino.magritte.compiler.core.CompilationUnit;
import io.intino.magritte.compiler.core.CompilerMessage;
import io.intino.magritte.compiler.core.SourceUnit;
import io.intino.magritte.compiler.core.errorcollection.CompilationFailedException;
import io.intino.magritte.compiler.core.errorcollection.DependencyException;
import io.intino.magritte.compiler.core.errorcollection.ErrorCollector;
import io.intino.magritte.compiler.core.errorcollection.MultipleCompilationErrorsException;
import io.intino.magritte.compiler.core.errorcollection.SemanticException;
import io.intino.magritte.compiler.core.errorcollection.SyntaxException;
import io.intino.magritte.compiler.core.errorcollection.TaraRuntimeException;
import io.intino.magritte.compiler.core.errorcollection.message.DependencyErrorMessage;
import io.intino.magritte.compiler.core.errorcollection.message.ExceptionMessage;
import io.intino.magritte.compiler.core.errorcollection.message.Message;
import io.intino.magritte.compiler.core.errorcollection.message.SemanticErrorMessage;
import io.intino.magritte.compiler.core.errorcollection.message.SimpleMessage;
import io.intino.magritte.compiler.core.errorcollection.message.SyntaxErrorMessage;
import io.intino.magritte.compiler.core.errorcollection.message.WarningMessage;
import io.intino.magritte.lang.model.Element;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class TaraCompiler {
    private static final String LINE_AT = " @ line ";
    private static final Logger LOG = Logger.getGlobal();
    private final List<CompilerMessage> collector;

    public TaraCompiler(List<CompilerMessage> collector) {
        this.collector = collector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OutputItem> compile(CompilationUnit unit) {
        ArrayList<OutputItem> compiledFiles = new ArrayList<OutputItem>();
        try {
            unit.compile();
            this.addCompiledFiles(unit, compiledFiles);
        }
        catch (CompilationFailedException e) {
            this.processCompilationException(e);
        }
        catch (TaraRuntimeException e) {
            this.processException(e);
        }
        finally {
            this.addWarnings(unit.getErrorCollector(), this.collector);
        }
        return compiledFiles;
    }

    private void addCompiledFiles(CompilationUnit compilationUnit, List<OutputItem> compiledFiles) {
        for (Map.Entry<String, List<String>> entry : compilationUnit.getOutputItems().entrySet()) {
            compiledFiles.addAll(entry.getValue().stream().map(outFile -> new OutputItem((String)entry.getKey(), (String)outFile)).collect(Collectors.toList()));
        }
    }

    private void addWarnings(ErrorCollector errorCollector, List collector) {
        for (int i = 0; i < errorCollector.getWarningCount(); ++i) {
            WarningMessage warning = errorCollector.getWarning(i);
            collector.add(new CompilerMessage("warning", warning.getMessage(), ((SourceUnit)warning.getOwner()).getName(), warning.line(), warning.column()));
        }
    }

    private void processCompilationException(Exception exception) {
        if (exception instanceof MultipleCompilationErrorsException) {
            MultipleCompilationErrorsException errorsException = (MultipleCompilationErrorsException)exception;
            ErrorCollector errorCollector = errorsException.getErrorCollector();
            for (int i = 0; i < errorCollector.getErrorCount(); ++i) {
                this.processException(errorCollector.getError(i));
            }
        } else {
            this.processException(exception);
        }
    }

    private void processException(Message message) {
        if (message instanceof SyntaxErrorMessage) {
            this.addErrorMessage(((SyntaxErrorMessage)message).getCause());
        } else if (message instanceof SemanticErrorMessage) {
            this.addErrorMessage(((SemanticErrorMessage)message).getCause());
        } else if (message instanceof DependencyErrorMessage) {
            this.addErrorMessage(((DependencyErrorMessage)message).getCause());
        } else if (message instanceof ExceptionMessage) {
            this.processException(((ExceptionMessage)message).getCause());
        } else if (message instanceof SimpleMessage) {
            this.addErrorMessage((SimpleMessage)message, this.collector);
        } else {
            this.addMessageWithoutLocation(this.collector, "An unknown error occurred: " + message, true);
        }
    }

    private void processException(Throwable e) {
        if (e instanceof TaraRuntimeException) {
            this.addErrorMessage((TaraRuntimeException)e);
            return;
        }
        LOG.severe(e.getMessage());
        this.addMessageWithoutLocation(this.collector, e.getMessage(), true);
    }

    private void addMessageWithoutLocation(List collector, String message, boolean error) {
        collector.add(new CompilerMessage(error ? "error" : "warning", message, null, -1, -1));
    }

    private void addErrorMessage(SyntaxException exception) {
        String message = exception.getMessage();
        String justMessage = message.substring(0, message.lastIndexOf(LINE_AT));
        this.collector.add(new CompilerMessage("error", justMessage, exception.getSourceLocator(), exception.getLine(), exception.getStartColumn()));
    }

    private void addErrorMessage(SemanticException error) {
        if (error.getErrors()[0].origin() != null) {
            Element[] origins;
            String message = error.getMessage().contains(LINE_AT) ? error.getMessage().substring(0, error.getMessage().lastIndexOf(LINE_AT)) : error.getMessage();
            for (Element element : origins = error.getErrors()[0].origin()) {
                this.collector.add(new CompilerMessage("error", message, element.file(), element.line(), 1));
            }
        } else {
            String message = error.getMessage();
            this.collector.add(new CompilerMessage("error", message, null, -1, -1));
        }
    }

    private void addErrorMessage(DependencyException exception) {
        String message = exception.getMessage();
        String justMessage = message.substring(0, message.lastIndexOf(LINE_AT));
        this.collector.add(new CompilerMessage("error", justMessage, exception.getElement().file(), exception.getLine(), 1));
    }

    private void addErrorMessage(TaraRuntimeException exception) {
        Element element = exception.getElement();
        this.collector.add(element != null ? new CompilerMessage("error", exception.getMessageWithoutLocationText(), element.file(), element.line(), -1) : new CompilerMessage("error", exception.getMessageWithoutLocationText(), "null", -1, -1));
    }

    private void addErrorMessage(SimpleMessage message, List collector) {
        this.addMessageWithoutLocation(collector, message.getMessage(), true);
    }

    public static class OutputItem {
        private final String myOutputPath;
        private final String mySourceFileName;

        OutputItem(String sourceFileName, String outputFilePath) {
            this.myOutputPath = outputFilePath;
            this.mySourceFileName = sourceFileName;
        }

        public String getOutputPath() {
            return this.myOutputPath;
        }

        public String getSourceFile() {
            return this.mySourceFileName;
        }
    }
}

