/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.parser.antlr;

import java.util.Arrays;

public class BlockManager {
    private int level = 0;
    private int tabSize = 4;
    private Token[] tokens = new Token[0];

    public void reset() {
        this.tokens = new Token[0];
        this.level = 0;
    }

    public void newlineAndSpaces(String text) {
        int newLevel = this.spacesLength(text) / this.tabSize;
        this.tokens = this.indentationTokens(newLevel - this.level, true);
        this.level = newLevel;
    }

    private int spacesLength(String text) {
        int value = 0;
        for (int i = 0; i < text.length(); ++i) {
            value += text.charAt(i) == '\t' ? this.tabSize : 1;
        }
        return value;
    }

    private Token[] indentationTokens(int size, boolean addLastNewline) {
        if (size > 0) {
            return this.create(Token.NEWLINE_INDENT);
        }
        int length = !addLastNewline ? Math.abs(size * 2) : Math.abs(size * 2) + 1;
        return this.createDedents(length);
    }

    private Token[] createDedents(int size) {
        Token[] actions = new Token[size];
        for (int i = 0; i < actions.length; ++i) {
            actions[i] = i % 2 == 0 ? Token.NEWLINE : Token.DEDENT;
        }
        return actions;
    }

    private Token[] create(Token token) {
        return new Token[]{token};
    }

    public Token[] actions() {
        return Arrays.copyOf(this.tokens, this.tokens.length);
    }

    public void openBracket(int size) {
        this.tokens = this.indentationTokens(size, false);
        this.level += size;
    }

    public void semicolon(int size) {
        this.tokens = size == 1 ? this.create(Token.NEWLINE) : this.create(Token.ERROR);
    }

    public void eof() {
        this.tokens = this.indentationTokens(-this.level, false);
        --this.level;
    }

    public static enum Token {
        NEWLINE_INDENT,
        DEDENT,
        NEWLINE,
        ERROR;

    }
}

