/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.model;

import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.NodeContainer;
import io.intino.magritte.lang.model.NodeRoot;
import io.intino.magritte.lang.model.Primitive;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.model.Variable;
import io.intino.magritte.lang.model.rules.Size;
import io.intino.magritte.lang.model.rules.variable.VariableRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class VariableImpl
implements Variable {
    private static final Logger LOG = Logger.getGlobal();
    private Node container;
    private Primitive type;
    private String name;
    private List<Object> defaultValues = new ArrayList<Object>();
    private String file;
    private int line;
    private int column;
    private List<Tag> flags = new ArrayList<Tag>();
    private String defaultExtension;
    private boolean inherited;
    private boolean overriden;
    private Size size = new Size(1, 1);
    private String uid;
    private VariableRule rule;
    private String scope;

    public VariableImpl(Node container, Primitive type, String name, String scope) {
        this.container = container;
        this.type = type;
        this.name = name;
        this.scope = scope;
    }

    public Primitive type() {
        return this.type;
    }

    public void type(Primitive type) {
        this.type = type;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public Node container() {
        return this.container;
    }

    public Node destinyOfReference() {
        return null;
    }

    public void container(Node container) {
        this.container = container;
    }

    public List<Tag> flags() {
        return this.flags;
    }

    public boolean isReference() {
        return false;
    }

    public void addFlags(Tag ... flags) {
        Collections.addAll(this.flags, flags);
    }

    public boolean isTerminal() {
        return this.flags.contains(Tag.Terminal);
    }

    public boolean isFinal() {
        return this.flags.contains(Tag.Final);
    }

    public boolean isPrivate() {
        return this.flags.contains(Tag.Private);
    }

    public boolean isInherited() {
        return this.inherited;
    }

    protected void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public boolean isMultiple() {
        return this.size().max() > 1;
    }

    public Size size() {
        return this.size;
    }

    public void size(Size size) {
        this.size = size;
    }

    public VariableRule rule() {
        return this.rule;
    }

    public void rule(VariableRule rule) {
        this.rule = rule;
    }

    public String scope() {
        return this.scope;
    }

    public void values(List<Object> values) {
        this.defaultValues.clear();
        this.defaultValues.addAll(values);
    }

    public List<Object> values() {
        return Collections.unmodifiableList(this.makeUp(this.model().resourcesRoot(), this.type(), this.defaultValues));
    }

    private NodeRoot model() {
        Node container = this.container();
        while (!(container instanceof NodeRoot)) {
            container = container.container();
        }
        return (NodeRoot)container;
    }

    public String defaultMetric() {
        return this.defaultExtension;
    }

    public void defaultMetric(String defaultExtension) {
        this.defaultExtension = defaultExtension;
    }

    public String getUID() {
        if (this.uid == null) {
            this.uid = "" + Variable.NativeCounter.next((NodeContainer)this.container(), (String)this.name());
        }
        return this.uid;
    }

    public String file() {
        return this.file;
    }

    public void file(String file) {
        this.file = file;
    }

    public int line() {
        return this.line;
    }

    public void line(int line) {
        this.line = line;
    }

    public int column() {
        return this.column;
    }

    public void column(int column) {
        this.column = column;
    }

    public Variable clone() throws CloneNotSupportedException {
        super.clone();
        VariableImpl clone = new VariableImpl(this.container, this.type, this.name, this.scope);
        clone.file(this.file);
        clone.line(this.line());
        clone.column(this.column());
        clone.size(this.size());
        clone.defaultMetric(this.defaultExtension);
        clone.rule(this.rule);
        this.flags.forEach(xva$0 -> clone.addFlags((Tag)xva$0));
        clone.values(this.defaultValues);
        clone.setInherited(true);
        return clone;
    }

    public Variable cloneIt(Node container) {
        try {
            Variable clone = this.clone();
            clone.container(container);
            return clone;
        }
        catch (CloneNotSupportedException ignored) {
            LOG.severe("Error cloning variable: " + this.name());
            return null;
        }
    }

    public String toString() {
        return this.type + ":" + this.name;
    }

    public boolean isOverriden() {
        return this.overriden;
    }

    public void overriden(boolean overriden) {
        this.overriden = overriden;
    }
}

