/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.dependencyresolution;

import io.intino.Configuration;
import io.intino.magritte.builder.model.Model;
import io.intino.magritte.builder.model.NodeReference;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.Tag;

public class TerminalResolver {
    private final Model model;
    private final Configuration.Artifact.Model.Level level;

    public TerminalResolver(Model model, Configuration.Artifact.Model.Level level) {
        this.model = model;
        this.level = level;
    }

    public void resolve() {
        this.resolveTerminals((Node)this.model);
    }

    private void resolveTerminals(Node node) {
        for (Node component : node.components()) {
            if (component instanceof NodeReference) continue;
            if (component.isTerminal()) {
                this.propagateTerminalToInside(component);
                continue;
            }
            if (Configuration.Artifact.Model.Level.Product.compareLevelWith(this.level) > 0) {
                this.resolveTerminals(component);
                continue;
            }
            if (!this.level.equals((Object)Configuration.Artifact.Model.Level.Product)) continue;
            component.addFlags(new Tag[]{Tag.Terminal});
            this.propagateTerminalToInside(component);
        }
    }

    private void propagateTerminalToInside(Node node) {
        for (Node component : node.components()) {
            if (component instanceof NodeReference) continue;
            if (!component.isTerminal()) {
                component.addFlags(new Tag[]{Tag.Terminal});
            }
            this.propagateTerminalToInside(component);
        }
        this.propagateTerminalToVariables(node);
    }

    private void propagateTerminalToVariables(Node node) {
        node.variables().stream().filter(variable -> !variable.isTerminal()).forEach(variable -> variable.addFlags(new Tag[]{Tag.Terminal}));
    }
}

