/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.core;

import io.intino.Configuration;
import io.intino.magritte.builder.core.errorcollection.TaraException;
import io.intino.magritte.builder.semantic.LanguageLoader;
import io.intino.magritte.builder.utils.FileSystemUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class CompilerConfiguration
implements Cloneable {
    public static final String REPOSITORY = "repository";
    private static final Logger LOG = Logger.getGlobal();
    private int warningLevel;
    private String sourceEncoding;
    private String project;
    private String module;
    private File outDirectory;
    private boolean debug;
    private final Locale languageForCodeGeneration = Locale.ENGLISH;
    private final List<File> sourceDirectories = new ArrayList<File>();
    private File resourcesDirectory;
    private File semanticRulesLib;
    private List<Integer> excludedPhases = new ArrayList<Integer>();
    private String groupID;
    private String artifactID;
    private String version;
    private final ModelConfiguration model;
    private boolean make;
    private boolean verbose;
    private File tempDirectory;
    private File intinoProjectDirectory;
    private File taraDirectory;
    private boolean test;
    private String workingPackage;
    private final String nativeLanguage = "java";
    private Map<String, String> packageParameters;
    private PrintStream out = System.out;

    public CompilerConfiguration() {
        this.setWarningLevel(1);
        this.setDebug(false);
        String encoding = System.getProperty("file.encoding", "UTF8");
        encoding = System.getProperty("tara.source.encoding", encoding);
        this.sourceEncoding(encoding);
        this.model = new ModelConfiguration();
        try {
            this.tempDirectory = Files.createTempDirectory("_tara_", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public int getWarningLevel() {
        return this.warningLevel;
    }

    public void setWarningLevel(int level) {
        this.warningLevel = level < 0 || level > 3 ? 1 : level;
    }

    public String sourceEncoding() {
        return this.sourceEncoding;
    }

    public void sourceEncoding(String encoding) {
        this.sourceEncoding = encoding == null ? "UTF8" : encoding;
    }

    public File getOutDirectory() {
        return this.outDirectory;
    }

    public void setOutDirectory(File directory) {
        if (directory != null) {
            this.outDirectory = directory;
            this.outDirectory.mkdirs();
        } else {
            this.outDirectory = null;
        }
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public File getTempDirectory() {
        return this.tempDirectory;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public File getTaraDirectory() {
        return this.taraDirectory;
    }

    public void setTaraDirectory(File taraDirectory) {
        this.taraDirectory = taraDirectory;
    }

    public String groupId() {
        return this.groupID;
    }

    public void groupId(String groupID) {
        this.groupID = groupID;
    }

    public String artifactId() {
        return this.artifactID;
    }

    public void artifactId(String artifactID) {
        this.artifactID = artifactID;
    }

    public String version() {
        return this.version;
    }

    public void version(String version) {
        this.version = version;
        this.model.outDslVersion(version);
    }

    public void workingPackage(String workingPackage) {
        this.workingPackage = workingPackage;
    }

    public String workingPackage() {
        return this.workingPackage == null || this.workingPackage.isEmpty() ? this.model.outDsl() : this.workingPackage;
    }

    public String dslGroupId() {
        return "tara.dsl";
    }

    public File resourcesDirectory() {
        return this.resourcesDirectory;
    }

    public void setResourcesDirectory(File resourcesDirectory) {
        this.resourcesDirectory = resourcesDirectory;
    }

    public void cleanTemp() {
        FileSystemUtils.removeDir(this.tempDirectory);
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public Locale getLocale() {
        return this.languageForCodeGeneration;
    }

    public File getSemanticRulesLib() {
        return this.semanticRulesLib;
    }

    public void setSemanticRulesLib(File semanticRulesURL) {
        this.semanticRulesLib = semanticRulesURL;
    }

    public void addLanguage(String name, String version) {
        this.model.language(new Language(name, version));
    }

    public void addLanguage(io.intino.magritte.Language taraLanguage) {
        this.model.language(new Language(taraLanguage));
    }

    private File languagesDirectory() {
        return new File(this.taraDirectory, REPOSITORY);
    }

    public String nativeLanguage() {
        return this.nativeLanguage;
    }

    public ModelConfiguration model() {
        return this.model;
    }

    List<Integer> getExcludedPhases() {
        return this.excludedPhases;
    }

    public void setExcludedPhases(List<Integer> excludedPhases) {
        this.excludedPhases = excludedPhases;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isMake() {
        return this.make;
    }

    public void setMake(boolean make) {
        this.make = make;
    }

    public void intinoProjectDirectory(File intinoPath) {
        this.intinoProjectDirectory = intinoPath;
    }

    public File intinoProjectDirectory() {
        return this.intinoProjectDirectory;
    }

    public File artifactsDirectory() {
        return new File(this.intinoProjectDirectory(), "artifacts");
    }

    private File getTaraProjectDirectory() {
        return new File(this.intinoProjectDirectory(), "tara");
    }

    public File getImportsFile() {
        return new File(this.getTaraProjectDirectory(), this.module + ".json");
    }

    public List<File> sourceDirectories() {
        return this.sourceDirectories;
    }

    public File srcDirectory() {
        return this.sourceDirectories.stream().filter(f -> f.getName().equals("src")).findAny().orElse(this.sourceDirectories.isEmpty() ? null : this.sourceDirectories.get(0));
    }

    public File rulesDirectory() {
        for (File sourceDirectory : this.sourceDirectories) {
            String rulesPackage;
            File file = new File(sourceDirectory, rulesPackage = (this.workingPackage() == null ? this.module.toLowerCase() : this.workingPackage().toLowerCase().replace(".", File.separator)) + File.separator + "rules");
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public File functionsDirectory() {
        for (File sourceDirectory : this.sourceDirectories) {
            String functionsPackage;
            File file = new File(sourceDirectory, functionsPackage = (this.workingPackage() == null ? this.module.toLowerCase() : this.workingPackage().toLowerCase().replace(".", File.separator)) + File.separator + "functions");
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public boolean isTest() {
        return this.test;
    }

    public void setTest(boolean test) {
        this.test = test;
    }

    public CompilerConfiguration clone() {
        try {
            return (CompilerConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.info(e.getMessage());
            return null;
        }
    }

    public Map<String, String> packageParameters() {
        return this.packageParameters;
    }

    public void packageParameters(Map<String, String> packageParameters) {
        this.packageParameters = packageParameters;
    }

    public PrintStream out() {
        return this.out;
    }

    public void out(PrintStream out) {
        this.out = out;
    }

    static {
        Logger.getGlobal().setLevel(Level.INFO);
        LOG.setUseParentHandlers(false);
        for (Handler handler : LOG.getHandlers()) {
            LOG.removeHandler(handler);
        }
        StreamHandler errorHandler = new StreamHandler(System.err, new SimpleFormatter());
        errorHandler.setLevel(Level.WARNING);
        LOG.addHandler(errorHandler);
        StreamHandler infoHandler = new StreamHandler(System.out, new SimpleFormatter());
        infoHandler.setLevel(Level.INFO);
        LOG.addHandler(infoHandler);
    }

    public class ModelConfiguration {
        private Language language;
        private String outLanguageName;
        private String outLanguageVersion;
        private Configuration.Artifact.Model.Level level;

        public Language language() {
            return this.language;
        }

        public void language(Language language) {
            this.language = language;
        }

        public void outDsl(String name) {
            this.outLanguageName = name;
        }

        public void outDslVersion(String version) {
            this.outLanguageVersion = version;
        }

        public String outDsl() {
            return this.outLanguageName;
        }

        public String outDslVersion() {
            return this.outLanguageVersion;
        }

        public void level(Configuration.Artifact.Model.Level level) {
            this.level = level;
        }

        public Configuration.Artifact.Model.Level level() {
            return this.level;
        }
    }

    public class Language {
        io.intino.magritte.Language language;
        String name;
        String version;
        String generationPackage;

        public Language(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public Language(io.intino.magritte.Language language) {
            this.language = language;
            this.name = this.language.languageName();
        }

        public io.intino.magritte.Language get() {
            return this.language == null ? (this.language = this.loadLanguage()) : this.language;
        }

        public String name() {
            return this.language == null ? this.name : this.language.languageName();
        }

        public String version() {
            return this.version;
        }

        public void version(String version) {
            this.version = version;
        }

        public String generationPackage() {
            return this.generationPackage;
        }

        void generationPackage(File language) {
            if (language.isDirectory() || !language.exists()) {
                this.generationPackage = this.name;
            } else {
                try {
                    Manifest manifest = new JarFile(language).getManifest();
                    Attributes tara = manifest.getAttributes("tara");
                    this.generationPackage = tara == null ? this.name : tara.getValue("generation.package".replace(".", "-"));
                }
                catch (IOException e) {
                    LOG.severe(e.getMessage());
                }
            }
        }

        private io.intino.magritte.Language loadLanguage() {
            try {
                io.intino.magritte.Language language = LanguageLoader.load(this.name, this.version, CompilerConfiguration.this.languagesDirectory().getAbsolutePath());
                this.generationPackage(LanguageLoader.getLanguagePath(this.name, this.version, CompilerConfiguration.this.languagesDirectory().getAbsolutePath()));
                return language;
            }
            catch (TaraException | NoClassDefFoundError e) {
                LOG.info("Language " + this.name() + " cannot be load");
                return null;
            }
        }
    }
}

