/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.parser;

import io.intino.magritte.Language;
import io.intino.magritte.builder.core.CompilerConfiguration;
import io.intino.magritte.builder.core.SourceUnit;
import io.intino.magritte.builder.model.Model;
import io.intino.magritte.builder.model.NodeImpl;
import io.intino.magritte.lang.model.Node;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ASTMerger {
    private final Collection<SourceUnit> sources;
    private final CompilerConfiguration conf;

    public ASTMerger(Collection<SourceUnit> sources, CompilerConfiguration conf) {
        this.sources = sources;
        this.conf = conf;
    }

    public Map<Language, Model> doMerge() {
        Map<Language, List<SourceUnit>> languageListMap = this.groupByLanguage();
        HashMap<Language, Model> models = new HashMap<Language, Model>();
        for (Language language : languageListMap.keySet()) {
            models.put(language, this.processByLanguage(language, languageListMap.get(language)));
        }
        return models;
    }

    private Model processByLanguage(Language language, List<SourceUnit> sourceUnits) {
        Model model = new Model(this.getName());
        model.setLanguage(language);
        model.setResourcesRoot(this.conf.resourcesDirectory());
        model.level(this.conf.model().level());
        for (SourceUnit unit : sourceUnits) {
            List<Node> components = unit.getModel().components();
            components.forEach(c -> {
                model.add((Node)c, unit.getModel().rulesOf((Node)c));
                ((NodeImpl)c).setDirty(unit.isDirty());
            });
            if (components.isEmpty()) continue;
            model.languageName(components.get(0).languageName());
        }
        for (Node node : model.components()) {
            node.container((Node)model);
        }
        return model;
    }

    private Map<Language, List<SourceUnit>> groupByLanguage() {
        HashMap<Language, List<SourceUnit>> list = new HashMap<Language, List<SourceUnit>>();
        for (SourceUnit source : this.sources) {
            if (source.getModel().components().isEmpty()) continue;
            if (!list.containsKey(source.getModel().language())) {
                list.put(source.getModel().language(), new ArrayList());
            }
            ((List)list.get(source.getModel().language())).add(source);
        }
        return list;
    }

    private String getName() {
        return this.conf.getProject() != null ? this.conf.getProject() + "." + this.conf.model().outDsl() : this.getPresentableName();
    }

    private String getPresentableName() {
        String name = new File(this.sources.iterator().next().getName()).getName();
        return name.substring(0, name.lastIndexOf("."));
    }
}

