/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.core.operation.sourceunit;

import io.intino.magritte.Language;
import io.intino.magritte.builder.core.CompilationUnit;
import io.intino.magritte.builder.core.SourceUnit;
import io.intino.magritte.builder.core.operation.sourceunit.SourceUnitCollectionOperation;
import io.intino.magritte.builder.model.Model;
import io.intino.magritte.builder.parser.ASTMerger;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnifyModelOperation
extends SourceUnitCollectionOperation {
    private static final Logger LOG = Logger.getGlobal();
    private final CompilationUnit unit;

    public UnifyModelOperation(CompilationUnit unit) {
        this.unit = unit;
    }

    @Override
    public void call(Collection<SourceUnit> sources) {
        try {
            if (this.unit.configuration().isVerbose()) {
                this.unit.configuration().out().println("@#$%@# Presentable:Tarac: Merging to global models");
            }
            Map<Language, Model> models = new ASTMerger(sources, this.unit.configuration()).doMerge();
            for (Language language : models.keySet()) {
                this.unit.addModel(language, models.get(language));
            }
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, "Error merging sources representations: " + e.getMessage(), e);
        }
    }
}

