/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.core.operation.model;

import io.intino.magritte.builder.codegeneration.language.LanguageSerializer;
import io.intino.magritte.builder.core.CompilationUnit;
import io.intino.magritte.builder.core.errorcollection.CompilationFailedException;
import io.intino.magritte.builder.core.errorcollection.TaraException;
import io.intino.magritte.builder.core.operation.model.ModelCollectionOperation;
import io.intino.magritte.builder.model.Model;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenerateLanguageOperation
extends ModelCollectionOperation {
    private static final Logger LOG = Logger.getGlobal();

    public GenerateLanguageOperation(CompilationUnit unit) {
        super(unit);
    }

    @Override
    public void call(Collection<Model> models) {
        try {
            if (this.compilationUnit.configuration().model().level().isSolution()) {
                return;
            }
            if (this.compilationUnit.configuration().isVerbose()) {
                this.compilationUnit.configuration().out().println("@#$%@# Presentable:[" + this.compilationUnit.configuration().getModule() + " - " + this.compilationUnit.configuration().model().outDsl() + "] Generating language...");
            }
            new LanguageSerializer(this.compilationUnit.configuration(), models).serialize();
            this.compilationUnit.getErrorCollector().failIfErrors();
        }
        catch (TaraException e) {
            LOG.log(Level.SEVERE, "Error during language generation: " + e.getMessage() + "\n", e);
            throw new CompilationFailedException(9, this.compilationUnit, e);
        }
    }
}

