/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.compiler.shared;

import io.intino.konos.compiler.shared.PostCompileActionMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PostCompileMethodActionMessage
extends PostCompileActionMessage {
    private final boolean isStatic;
    private final List<String> parameters;
    private final String returnType;
    private final List<String> exceptions;

    public PostCompileMethodActionMessage(String module, File file, String name, boolean isStatic, List<String> parameters, String returnType) {
        super(module, file, PostCompileActionMessage.ObjectType.METHOD, name);
        this.isStatic = isStatic;
        this.parameters = parameters;
        this.returnType = returnType;
        this.exceptions = new ArrayList<String>();
    }

    public PostCompileMethodActionMessage(String module, File file, String name, boolean isStatic, List<String> parameters, String returnType, List<String> exceptions) {
        super(module, file, PostCompileActionMessage.ObjectType.METHOD, name);
        this.isStatic = isStatic;
        this.parameters = parameters;
        this.returnType = returnType;
        this.exceptions = exceptions;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public List<String> parameters() {
        return this.parameters;
    }

    public String returnType() {
        return this.returnType;
    }

    public List<String> exceptions() {
        return this.exceptions;
    }

    @Override
    public String toString() {
        return super.toString() + "#%%#%%%#%%%%%%%%%#" + this.isStatic + "#%%#%%%#%%%%%%%%%#" + String.join((CharSequence)";", this.parameters()) + "#%%#%%%#%%%%%%%%%#" + this.returnType + "#%%#%%%#%%%%%%%%%#" + String.join((CharSequence)";", this.exceptions());
    }
}

