/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.analytic;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class CubeTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.type("cube"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[]{"validPackage"})}).output(new Rule.Output[]{this.literal(".analytic.cubes.schemas;\n\nimport io.intino.alexandria.led.HeapLedStreamBuilder;\nimport io.intino.alexandria.led.Schema;\nimport io.intino.alexandria.led.LedReader;\nimport io.intino.alexandria.led.LedWriter;\nimport io.intino.alexandria.led.LedStream;\nimport io.intino.alexandria.led.Led;\nimport io.intino.alexandria.led.allocators.SchemaFactory;\nimport io.intino.alexandria.led.buffers.store.ByteStore;\nimport io.intino.alexandria.led.buffers.store.ByteBufferStore;\nimport io.intino.alexandria.Timetag;\n\nimport java.util.stream.*;\nimport java.util.List;\nimport java.util.Arrays;\nimport java.util.Comparator;\nimport java.io.File;\nimport java.util.UUID;\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[]{"validPackage"})}).output(new Rule.Output[]{this.literal(".analytic.axes.*;\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(" extends Schema {\n\n\tpublic static final int SIZE = ")}).output(new Rule.Output[]{this.mark("size", new String[0])}).output(new Rule.Output[]{this.literal("; // Bytes\n\tpublic static final UUID SERIAL_UUID = UUID.fromString(\"")}).output(new Rule.Output[]{this.mark("serialUUID", new String[0])}).output(new Rule.Output[]{this.literal("\");\n\tpublic static final SchemaFactory<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> FACTORY = new SchemaFactory<>(")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(".class) {\n\t\t@Override\n\t\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(" newInstance(ByteStore store) {\n\t\t\treturn new ")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("(store);\n\t\t}\n\t};\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("() {\n\t\tsuper(new ByteBufferStore(SIZE));\n\t}\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("(ByteStore store) {\n\t\tsuper(store);\n\t}\n\n\t@Override\n\tpublic long id() {\n\t\treturn bitBuffer.getAlignedLong(0);\n\t}\n\n\t@Override\n\tpublic int size() {\n\t\treturn SIZE;\n\t}\n\n\t@Override\n\tpublic UUID serialUUID() {\n\t\treturn SERIAL_UUID;\n\t}\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("column", new String[]{"getter"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("column", new String[]{"setter"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t@Override\n\tpublic String toString() {\n\t\treturn \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("{\"\n\t\t\t\t+ \"id=\" + id()\n\t\t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("column", new String[]{"toString"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t\t\t\t+ '}';\n\t}\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("split", new String[0])})}).output(new Rule.Output[]{this.literal("\n\n\n\tpublic static class Builder extends HeapLedStreamBuilder<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> {\n\n\t\tpublic Builder() {\n\t\t\tthis(1_000_000);\n\t\t}\n\n\t\tpublic Builder(File tempDirectory) {\n\t\t\tthis(1_000_000, tempDirectory);\n\t\t}\n\n\t\tpublic Builder(int numSchemasPerBlock) {\n\t\t\tthis(numSchemasPerBlock, new File(System.getProperty(\"java.io.tmpdir\")));\n\t\t}\n\n\t\tpublic Builder(int numSchemasPerBlock, File tempDirectory) {\n\t\t\tsuper(")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(".class, numSchemasPerBlock, tempDirectory);\n\t\t}\n\t}\n\n\tpublic static class Tank {\n\n\t\tpublic static File get(File root) {\n\t\t\treturn new File(root, \"")}).output(new Rule.Output[]{this.mark("cube", new String[0])}).output(new Rule.Output[]{this.literal("\");\n\t\t}\n\n\t\tpublic static File get(File root, Divisiones.Component division) {\n\t\t\treturn new File(root, \"")}).output(new Rule.Output[]{this.mark("cube", new String[0])}).output(new Rule.Output[]{this.literal(".\" + division.id());\n\t\t}\n\n\t\tpublic static File on(File root, Timetag timetag) {\n\t\t\treturn new File(root, \"")}).output(new Rule.Output[]{this.mark("cube", new String[0])}).output(new Rule.Output[]{this.literal("/\" + timetag + \".led\");\n\t\t}\n\n\t\tpublic static File on(File root, Divisiones.Component division, Timetag timetag) {\n\t\t\treturn new File(root, \"")}).output(new Rule.Output[]{this.mark("cube", new String[0])}).output(new Rule.Output[]{this.literal(".\" + division.id() + \"/\" + timetag + \".led\");\n\t\t}\n\t}\n\n\tpublic static class Reader {\n\n\t\tpublic static List<LedStream<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(">> readAll(File root, Divisiones.Component division) {\n\t\t\tFile[] leds = getLedFiles(new File(root, \"")}).output(new Rule.Output[]{this.mark("cube", new String[0])}).output(new Rule.Output[]{this.literal(".\" + division.id()));\n\t\t\treturn Arrays.stream(leds).map(Reader::openLedStream).collect(Collectors.toList());\n\t\t}\n\n\t\tpublic static List<LedStream<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(">> read(File root, Divisiones.Component division, Timetag from, Timetag to) {\n\t\t\tFile[] leds = getLedFiles(new File(root, \"")}).output(new Rule.Output[]{this.mark("cube", new String[0])}).output(new Rule.Output[]{this.literal(".\" + division.id()));\n\t\t\treturn Arrays.stream(leds)\n\t\t\t\t.filter(led -> {\n\t\t\t\t\tfinal String name = led.getName();\n\t\t\t\t\tfinal Timetag timetag = Timetag.of(name.substring(0, name.indexOf('.')));\n\t\t\t\t\treturn (timetag.equals(from) || timetag.isAfter(from)) && (timetag.equals(to) || timetag.isBefore(to));\n\t\t\t\t})\n\t\t\t\t.map(Reader::openLedStream)\n\t\t\t\t.collect(Collectors.toList());\n\t\t}\n\n\t\tpublic static LedStream<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> read(File root, Divisiones.Component division, Timetag timetag) {\n\t\t\tFile[] leds = getLedFiles(new File(root, \"")}).output(new Rule.Output[]{this.mark("cube", new String[0])}).output(new Rule.Output[]{this.literal(".\" + division.id()));\n\t\t\treturn Arrays.stream(leds)\n\t\t\t\t.filter(led -> {\n\t\t\t\t\tfinal String name = led.getName();\n\t\t\t\t\tfinal Timetag t = Timetag.of(name.substring(0, name.indexOf('.')));\n\t\t\t\t\treturn t.equals(timetag);\n\t\t\t\t})\n\t\t\t\t.map(Reader::openLedStream)\n\t\t\t\t.findFirst().orElse(null);\n\t\t}\n\n\t\tpublic static LedStream<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> readFirst(File root, Divisiones.Component division) {\n\t\t\tFile[] leds = getLedFiles(new File(root, \"")}).output(new Rule.Output[]{this.mark("cube", new String[0])}).output(new Rule.Output[]{this.literal(".\" + division.id()));\n\t\t\tif(leds.length == 0) return LedStream.empty(")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(".class);\n\t\t\treturn openLedStream(leds[0]);\n\t\t}\n\n\t\tpublic static LedStream<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> readLast(File root, Divisiones.Component division) {\n\t\t\tFile[] leds = getLedFiles(new File(root, \"")}).output(new Rule.Output[]{this.mark("cube", new String[0])}).output(new Rule.Output[]{this.literal(".\" + division.id()));\n\t\t\tif(leds.length == 0) return LedStream.empty(")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(".class);\n\t\t\treturn openLedStream(leds[leds.length - 1]);\n\t\t}\n\n\t\tpublic static LedStream<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> readLedStream(File ledFile) {\n\t\t\treturn new LedReader(ledFile).read(")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(".class);\n\t\t}\n\n\t\tpublic static Led<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> readLed(File ledFile) {\n\t\t\treturn new LedReader(ledFile).readAll(")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(".class);\n\t\t}\n\n\t\tprivate static LedStream<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> openLedStream(File led) {\n\t\t\tif(led == null || !led.exists()) return LedStream.empty(")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(".class);\n\t\t\treturn new LedReader(led).read(")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(".class);\n\t\t}\n\n\t\tprivate static File[] getLedFiles(File dir) {\n\t\t\tFile[] leds = dir.listFiles(f -> f.getName().endsWith(\".led\"));\n\t\t\tif(leds == null || leds.length == 0) return new File[0];\n\t\t\tArrays.sort(leds, Comparator.comparing(File::getName));\n\t\t\treturn leds;\n\t\t}\n\t}\n\n\tpublic static class Writer {\n\n\t\tpublic static void write(File file, LedStream.Builder<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> builder) {\n\t\t\twrite(file, builder.build());\n\t\t}\n\n\t\tpublic static void write(File file, LedStream<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> ledStream) {\n\t\t\tnew LedWriter(file).write(ledStream);\n\t\t}\n\n\t\tpublic static void write(File file, Led<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> led) {\n\t\t\tnew LedWriter(file).write(led);\n\t\t}\n\t}\n}")}), this.rule().condition(this.trigger("axisimport"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("import ")}).output(new Rule.Output[]{this.mark("", new String[0])}).output(new Rule.Output[]{this.literal(".axis.*;")}), this.rule().condition(this.trigger("split"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public enum Split {\n\t")}).output(new Rule.Output[]{this.mark("enum", new String[]{"asEnum"}).multiple(", ")}).output(new Rule.Output[]{this.literal(";\n\n\tpublic abstract String qn();\n\n\tpublic static Split splitByQn(String qn) {\n\t\tfor(Split split : values()) {\n\t\t\tif(split.qn().equals(qn)) return split;\n\t\t}\n\t\treturn null;\n\t}\n}")}), this.rule().condition(this.trigger("asenum"), new Rule.Condition[0]).output(new Rule.Output[]{this.mark("value", new String[]{"snakeCaseToCamelCase"})}).output(new Rule.Output[]{this.literal(" {\n\tpublic String qn() {\n\t\treturn \"")}).output(new Rule.Output[]{this.mark("qn", new String[0])}).output(new Rule.Output[]{this.literal("\";\n\t}\n}")}), this.rule().condition(this.trigger("nbits"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("NBits")})});
    }
}

