/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.displays.components.data;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.ui.TemplateProvider;
import io.intino.konos.builder.codegeneration.ui.displays.components.ComponentRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.model.DataComponents;
import org.apache.commons.lang.StringEscapeUtils;

public class TextRenderer
extends ComponentRenderer<DataComponents.Text> {
    public TextRenderer(CompilationContext compilationContext, DataComponents.Text component, TemplateProvider provider, Target target) {
        super(compilationContext, component, provider, target);
    }

    @Override
    public void fill(FrameBuilder builder) {
        if (((DataComponents.Text)this.element).prefix() != null) {
            builder.add("prefix", (Object)((DataComponents.Text)this.element).prefix());
        }
        if (((DataComponents.Text)this.element).suffix() != null) {
            builder.add("suffix", (Object)((DataComponents.Text)this.element).suffix());
        }
        if (((DataComponents.Text)this.element).isCode()) {
            FrameBuilder codeFrame = new FrameBuilder(new String[]{DataComponents.Text.Code.class.getSimpleName()});
            if (((DataComponents.Text)this.element).asCode().value() != null) {
                codeFrame.add("value", (Object)this.escape(((DataComponents.Text)this.element).asCode().value()));
            }
            builder.add("code", (Object)codeFrame);
        }
        this.addHighlightMethods(builder);
    }

    private String escape(String value) {
        return StringEscapeUtils.escapeHtml((String)value).trim().replaceAll("\"", "'");
    }

    @Override
    public FrameBuilder properties() {
        FrameBuilder result = super.properties();
        this.addHighlight(result);
        result.add("mode", (Object)((DataComponents.Text)this.element).mode().name().toLowerCase());
        if (((DataComponents.Text)this.element).isPassword()) {
            result.add("type", (Object)"password");
        }
        if (((DataComponents.Text)this.element).isReadonly()) {
            result.add("readonly", (Object)((DataComponents.Text)this.element).isReadonly());
        }
        if (((DataComponents.Text)this.element).isFocused()) {
            result.add("focused", (Object)((DataComponents.Text)this.element).isFocused());
        }
        if (((DataComponents.Text)this.element).cropWithEllipsis() != -1) {
            result.add("cropWithEllipsis", (Object)((DataComponents.Text)this.element).cropWithEllipsis());
        }
        if (((DataComponents.Text)this.element).translate()) {
            result.add("translate", (Object)((DataComponents.Text)this.element).translate());
        }
        if (((DataComponents.Text)this.element).isCode()) {
            result.add(DataComponents.Text.Code.class.getSimpleName());
            result.add("language", (Object)((DataComponents.Text)this.element).asCode().language().name());
        }
        if (((DataComponents.Text)this.element).value() != null) {
            String value = ((DataComponents.Text)this.element).isCode() ? ((DataComponents.Text)this.element).value().replaceAll("\\n", "").replaceAll("\"", "\\\\\"") : ((DataComponents.Text)this.element).value();
            result.add("defaultValue", (Object)value);
        }
        this.addEditable(result);
        return result;
    }

    private void addHighlight(FrameBuilder result) {
        if (!((DataComponents.Text)this.element).isHighlighted()) {
            return;
        }
        DataComponents.Text.Highlighted highlight = ((DataComponents.Text)this.element).asHighlighted();
        FrameBuilder highlightedFrame = new FrameBuilder(new String[]{"highlighted"}).add("text", (Object)highlight.textColor()).add("background", (Object)highlight.backgroundColor());
        result.add("highlighted", (Object)highlightedFrame);
    }

    private void addHighlightMethods(FrameBuilder builder) {
        if (!((DataComponents.Text)this.element).isHighlighted()) {
            return;
        }
        if (((DataComponents.Text)this.element).isMultiple()) {
            return;
        }
        FrameBuilder result = this.addOwner(this.buildBaseFrame()).add("method").add(DataComponents.Text.Highlighted.class.getSimpleName());
        result.add("name", (Object)this.nameOf(this.element));
        builder.add("methods", (Object)result);
    }

    private void addEditable(FrameBuilder builder) {
        if (!((DataComponents.Text)this.element).isEditable()) {
            return;
        }
        DataComponents.Text.Editable editableText = ((DataComponents.Text)this.element).asEditable();
        this.addMemoEditable(builder);
        this.addValidation(builder);
        if (editableText.placeholder() != null && !editableText.placeholder().isEmpty()) {
            builder.add("placeholder", (Object)editableText.placeholder());
        }
        if (editableText.helperText() != null) {
            builder.add("helperText", (Object)editableText.helperText());
        }
        if (editableText.shrink()) {
            builder.add("shrink", (Object)true);
        }
    }

    private void addMemoEditable(FrameBuilder builder) {
        if (!((DataComponents.Text)this.element).isMemo()) {
            return;
        }
        builder.add("editionMode", (Object)((DataComponents.Text)this.element).asMemo().editionMode().name());
        builder.add("rows", (Object)((DataComponents.Text)this.element).asMemo().height());
    }

    private void addValidation(FrameBuilder builder) {
        DataComponents.Text.Editable.Validation validation = ((DataComponents.Text)this.element).asEditable().validation();
        if (validation == null) {
            return;
        }
        DataComponents.Text.Editable.Validation.Length length = validation.length();
        if (length == null) {
            return;
        }
        builder.add("maxLength", (Object)length.max());
    }

    @Override
    protected String className(Class clazz) {
        return super.className(clazz).replace("text", "");
    }
}

