/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.analytic;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class ContinuousAxisTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.type("continuous"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[]{"ValidPackage"})}).output(new Rule.Output[]{this.literal(".analytic.axes;\n\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[]{"ValidPackage"})}).output(new Rule.Output[]{this.literal(".analytic.Axis;\nimport java.util.*;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" implements Axis {\n\n\tpublic static final String TITLE = \"")}).output(new Rule.Output[]{this.mark("label", new String[0])}).output(new Rule.Output[]{this.literal("\";\n\n\tprivate static final class Singleton {\n\t\tprivate static final ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" INSTANCE = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("();\n\t}\n\n\t// === STATIC METHODS === //\n\n\tpublic static ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" get() {\n\t\treturn Singleton.INSTANCE;\n\t}\n\n\tpublic static String title() {\n\t\treturn TITLE;\n\t}\n\n\tpublic static int size() {\n\t\treturn get().getSize();\n\t}\n\n\tpublic static Range component(String id) {\n\t\treturn get().getComponent(id);\n\t}\n\n\tpublic static Range component(int index) {\n\t\treturn get().getComponent(index);\n\t}\n\n\tpublic static List<Range> ranges() {\n\t\treturn get().getRanges();\n\t}\n\n\tpublic static Range rangeOf(final double value) {\n\t\tfinal Range[] ranges = Singleton.INSTANCE.ranges;\n\t\tint index = binarySearch(ranges, value);\n\t\tindex = index < 0 ? (index + 1) * -1 : index;\n\t\treturn ranges[index >= ranges.length ? ranges.length - 1 : index];\n\t}\n\n\tprivate static int binarySearch(final Range[] ranges, final double value) {\n\t\tint low = 0;\n\t\tint high = ranges.length - 1;\n\n\t\twhile (low <= high) {\n\t\t\tfinal int mid = (low + high) >>> 1;\n\t\t\tfinal double midVal = ranges[mid].max;\n\t\t\tfinal int comparison = Double.compare(midVal, value);\n\n\t\t\tif (comparison < 0)\n\t\t\t\tlow = mid + 1;\n\t\t\telse if (comparison > 0)\n\t\t\t\thigh = mid - 1;\n\t\t\telse\n\t\t\t\treturn mid;\n\t\t}\n\t\treturn -(low + 1);\n\t}\n\n\t// === === //\n\n\tprivate final Range[] ranges = new Range[")}).output(new Rule.Output[]{this.mark("rangeSize", new String[0])}).output(new Rule.Output[]{this.literal("];\n\n\tprivate ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("() {\n\t\t")}).output(new Rule.Output[]{this.mark("range", new String[]{"init"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t}\n\n\t@Override\n\tpublic String getTitle() {\n\t\treturn TITLE;\n\t}\n\n\t@Override\n\tpublic Range getComponent(String id) {\n\t\treturn ranges[Integer.parseInt(id)];\n\t}\n\n\t@Override\n\tpublic Range getComponent(int index) {\n\t\treturn ranges[index];\n\t}\n\n\tpublic List<Range> getRanges() {\n\t\treturn new AbstractList<>() {\n\t\t\t@Override\n\t\t\tpublic Range get(int index) {\n\t\t\t\treturn ranges[index];\n\t\t\t}\n\n\t\t\t@Override\n\t\t\tpublic int size() {\n\t\t\t\treturn ranges.length;\n\t\t\t}\n\t\t};\n\t}\n\n\t@Override\n\tpublic int getSize() {\n\t\treturn ranges().size();\n\t}\n\n\t@Override\n\tpublic List<Range> getComponents() {\n\t\treturn ranges();\n\t}\n\n\t@Override\n\tpublic Stream<Range> toStream() {\n\t\treturn Arrays.stream(ranges);\n\t}\n\n\t@Override\n\tpublic String toString() {\n\t\treturn \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("\";\n\t}\n\n\tpublic class Range implements Component {\n\n\t\tprivate final int index;\n\t\tprivate final double min;\n\t\tprivate final double max;\n\t\tprivate final String label;\n\n\t\tpublic Range(int index, double min, double max, String label) {\n\t\t\tthis.index = index;\n\t\t\tthis.min = min;\n\t\t\tthis.max = max;\n\t\t\tthis.label = label;\n\t\t}\n\n\t\tpublic double min() {\n\t\t\treturn min;\n\t\t}\n\n\t\tpublic double max() {\n\t\t\treturn max;\n\t\t}\n\n\t\t@Override\n\t\tpublic int index() {\n\t\t\treturn index;\n\t\t}\n\n\t\t@Override\n\t\tpublic String id() {\n\t\t\treturn label;\n\t\t}\n\n\t\t@Override\n\t\tpublic String label() {\n\t\t\treturn label;\n\t\t}\n\n\t\t@Override\n\t\tpublic Axis axis() {\n\t\t\treturn ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".this;\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean equals(Object o) {\n\t\t\tif (this == o) return true;\n\t\t\tif (o == null || getClass() != o.getClass()) return false;\n\t\t\tRange range = (Range) o;\n\t\t\treturn index == range.index;\n\t\t}\n\n\t\t@Override\n\t\tpublic int hashCode() {\n\t\t\treturn index;\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn label;\n\t\t}\n\t}\n}")}), this.rule().condition(this.allTypes(new String[]{"range", "lower"}), new Rule.Condition[]{this.attribute("label"), this.trigger("init")}).output(new Rule.Output[]{this.literal("ranges[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("] = new Range(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(", Double.MIN_VALUE, ")}).output(new Rule.Output[]{this.mark("bound", new String[0])}).output(new Rule.Output[]{this.literal(", \"")}).output(new Rule.Output[]{this.mark("label", new String[0])}).output(new Rule.Output[]{this.literal("\");")}), this.rule().condition(this.allTypes(new String[]{"range", "upper"}), new Rule.Condition[]{this.attribute("label"), this.trigger("init")}).output(new Rule.Output[]{this.literal("ranges[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("] = new Range(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("bound", new String[0])}).output(new Rule.Output[]{this.literal(", Double.MAX_VALUE, \"")}).output(new Rule.Output[]{this.mark("label", new String[0])}).output(new Rule.Output[]{this.literal("\");")}), this.rule().condition(this.type("range"), new Rule.Condition[]{this.attribute("label"), this.trigger("init")}).output(new Rule.Output[]{this.literal("ranges[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("] = new Range(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("lower", new String[0])}).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("upper", new String[0])}).output(new Rule.Output[]{this.literal(", \"")}).output(new Rule.Output[]{this.mark("label", new String[0])}).output(new Rule.Output[]{this.literal("\");")}), this.rule().condition(this.allTypes(new String[]{"range", "lower"}), new Rule.Condition[]{this.trigger("init")}).output(new Rule.Output[]{this.literal("ranges[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("] = new Range(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(", Double.MIN_VALUE, ")}).output(new Rule.Output[]{this.mark("bound", new String[0])}).output(new Rule.Output[]{this.literal(", \"< ")}).output(new Rule.Output[]{this.mark("bound", new String[0])}).output(new Rule.Output[]{this.literal("\");")}), this.rule().condition(this.allTypes(new String[]{"range", "upper"}), new Rule.Condition[]{this.trigger("init")}).output(new Rule.Output[]{this.literal("ranges[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("] = new Range(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("bound", new String[0])}).output(new Rule.Output[]{this.literal(", Double.MAX_VALUE, \"> ")}).output(new Rule.Output[]{this.mark("bound", new String[0])}).output(new Rule.Output[]{this.literal("\");")}), this.rule().condition(this.type("range"), new Rule.Condition[]{this.trigger("init")}).output(new Rule.Output[]{this.literal("ranges[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("] = new Range(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("lower", new String[0])}).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("upper", new String[0])}).output(new Rule.Output[]{this.literal(", \"")}).output(new Rule.Output[]{this.mark("lower", new String[0])}).output(new Rule.Output[]{this.literal(" - ")}).output(new Rule.Output[]{this.mark("upper", new String[0])}).output(new Rule.Output[]{this.literal("\");")})});
    }
}

