/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.swagger;

import io.intino.alexandria.logger.Logger;
import io.intino.konos.builder.codegeneration.swagger.OpenApiDescriptor;
import io.intino.konos.model.Service;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;

public class SwaggerProfileGenerator {
    private final List<Service.REST> services;
    private final File directory;

    public SwaggerProfileGenerator(List<Service.REST> services, File directory) {
        this.services = services;
        this.directory = directory;
    }

    public void execute() {
        this.services.stream().filter(Service.REST::generateDocs).forEach(service -> this.writeFile((Service.REST)((Object)service), new OpenApiDescriptor((Service.REST)((Object)service)).createJSONDescriptor()));
    }

    private void writeFile(Service.REST service, String json) {
        try {
            Files.write(new File(this.directory, service.name$() + ".json").toPath(), json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]).toFile().getPath();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }
}

