/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.rest;

import cottons.utils.StringHelper;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zip.Zip;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.services.rest.ApiPortalConfigurationTemplate;
import io.intino.konos.builder.codegeneration.services.rest.RESTServiceTemplate;
import io.intino.konos.builder.codegeneration.services.rest.RestAuthenticatorTemplate;
import io.intino.konos.builder.codegeneration.swagger.SwaggerProfileGenerator;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.KonosGraph;
import io.intino.konos.model.Service;
import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Predicate;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;

public class RESTServiceRenderer
extends Renderer {
    private final List<Service.REST> services;
    private final KonosGraph graph;

    public RESTServiceRenderer(CompilationContext compilationContext, KonosGraph graph) {
        super(compilationContext, Target.Owner);
        this.services = graph.serviceList(Service::isREST).map(Service::asREST).collect(Collectors.toList());
        this.graph = graph;
    }

    @Override
    public void render() {
        this.services.forEach(service -> this.processService((Service.REST)service.a$(Service.REST.class), this.gen()));
        if (this.services.stream().anyMatch(Service.REST::generateDocs)) {
            this.generateApiPortal();
        }
    }

    private void generateApiPortal() {
        File api = new File(this.res(), "www" + File.separator + "api");
        this.copyAssets(api);
        File data = new File(api, "data");
        data.mkdirs();
        new SwaggerProfileGenerator(this.services, data).execute();
        this.createConfigFile(api);
    }

    private void copyAssets(File www) {
        try {
            Zip.unzip((ZipInputStream)new ZipInputStream(this.getClass().getResourceAsStream("/swagger/assets.zip")), (String)www.getAbsolutePath());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void createConfigFile(File api) {
        Template template = Formatters.customize(new ApiPortalConfigurationTemplate());
        FrameBuilder frame = new FrameBuilder(new String[]{"api"}).add("url", this.services.stream().filter(Service.REST::generateDocs).map(Layer::name$).toArray(String[]::new));
        Service.REST service = this.services.get(0);
        if (service.color() != null) {
            frame.add("color", (Object)service.color());
        }
        if (service.backgroundColor() != null) {
            frame.add("background", (Object)service.backgroundColor());
        }
        if (service.title() != null) {
            frame.add("title", (Object)service.title());
        }
        if (service.subtitle() != null) {
            frame.add("subtitle", (Object)service.subtitle());
        } else {
            frame.add("title", (Object)"API Portal");
        }
        if (service.logo() != null) {
            this.copyLogoToImages(new File(api, "images"), service.logo());
        }
        if (service.favicon() != null) {
            this.copyFaviconToImages(new File(api, "images"), service.favicon());
        }
        try {
            Files.write(new File(api, "config.json").toPath(), template.render((Object)frame).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void copyFaviconToImages(File images, String logo) {
        File resource = this.findResource(logo);
        if (resource == null) {
            return;
        }
        try {
            Files.copy(resource.toPath(), new File(images, "favicon.png").toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void copyLogoToImages(File images, String logo) {
        File resource = this.findResource(logo);
        if (resource == null) {
            return;
        }
        try {
            Files.copy(resource.toPath(), new File(images, "logo.png").toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private File findResource(String logo) {
        File resRoot = this.context.configuration().resDirectory();
        if (resRoot == null) {
            return null;
        }
        File file = new File(resRoot.getPath(), logo);
        return file.exists() ? file : null;
    }

    private void processService(Service.REST service, File gen) {
        String className = StringHelper.snakeCaseToCamelCase((String)service.name$()) + "Service";
        if (service.resourceList().isEmpty() && service.notificationList().isEmpty()) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"server"}).add("name", (Object)service.name$()).add("box", (Object)this.boxName()).add("package", (Object)this.packageName()).add("resource", (Object)this.framesOf(service.resourceList(), service.authentication()));
        if (!service.notificationList().isEmpty()) {
            builder.add("notification", (Object)this.notificationsFrame(service.notificationList()));
            if (this.graph.serviceList(Service::isUI).findAny().isEmpty()) {
                builder.add("hasNotifications", (Object)"true");
            }
        }
        if (service.authentication() != null) {
            if (service.authentication().isWithCertificate()) {
                Service.REST.Authentication.WithCertificate secure = service.authentication().asWithCertificate();
                if (secure != null && secure.store() != null) {
                    builder.add("authenticationWithCertificate", (Object)new FrameBuilder(new String[]{"secure"}).add("file", (Object)secure.store()).add("password", (Object)secure.storePassword()).toFrame());
                }
            } else {
                builder.add("authenticator", (Object)new FrameBuilder(new String[]{"authenticator"}).add("service", (Object)service.name$()));
                this.createAuthenticatorClass(service.authentication(), className);
            }
        }
        this.classes().put(((Object)((Object)service)).getClass().getSimpleName() + "#" + service.name$(), className);
        Commons.writeFrame(gen, className, this.template().render((Object)builder.toFrame()));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(service), Commons.javaFile(this.gen(), className).getAbsolutePath()));
    }

    private void createAuthenticatorClass(Service.REST.Authentication authentication, String service) {
        if (Commons.javaFile(this.src(), service + "Authenticator").exists()) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{this.typeOf(authentication)}).add("box", (Object)this.boxName()).add("service", (Object)service).add("package", (Object)this.packageName());
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(authentication), Commons.javaFile(this.src(), service + "Authenticator").getAbsolutePath()));
        Commons.writeFrame(this.src(), service + "Authenticator", this.authenticatorTemplate().render((Object)builder.toFrame()));
    }

    private String typeOf(Service.REST.Authentication authentication) {
        if (authentication.isBasic()) {
            return "basic";
        }
        if (authentication.isBearer()) {
            return "bearer";
        }
        if (authentication.isCustom()) {
            return "custom";
        }
        return "withCertificate";
    }

    private Frame[] notificationsFrame(List<Service.REST.Notification> list) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        for (Service.REST.Notification notification : list) {
            frames.add(new FrameBuilder(new String[]{"notification"}).add("path", (Object)notification.path()).add("package", (Object)this.packageName()).add("name", (Object)notification.name$()).toFrame());
        }
        return frames.toArray(new Frame[0]);
    }

    private Frame[] framesOf(List<Service.REST.Resource> resources, Service.REST.Authentication authentication) {
        return (Frame[])resources.stream().map(r -> this.processResource((Service.REST.Resource)((Object)r), authentication, r.operationList())).flatMap(Collection::stream).toArray(Frame[]::new);
    }

    private List<Frame> processResource(Service.REST.Resource resource, Service.REST.Authentication authentication, List<Service.REST.Resource.Operation> operations) {
        return operations.stream().map(operation -> this.frameOf((Service.REST.Resource.Operation)((Object)operation), resource, authentication)).collect(Collectors.toList());
    }

    private Frame frameOf(Service.REST.Resource.Operation operation, Service.REST.Resource resource, Service.REST.Authentication authentication) {
        FrameBuilder builder = new FrameBuilder(new String[]{"resource", ((Object)((Object)operation)).getClass().getSimpleName()}).add("name", (Object)resource.name$()).add("operation", (Object)((Object)((Object)operation)).getClass().getSimpleName()).add("path", (Object)Formatters.customize("path", Commons.path(resource))).add("method", (Object)((Object)((Object)operation)).getClass().getSimpleName());
        if (authentication != null) {
            builder.add("authenticate", (Object)new FrameBuilder((String[])authentication.core$().conceptList().stream().filter(Concept::isAspect).map(Predicate::name).toArray(String[]::new)));
        }
        return builder.toFrame();
    }

    private Template template() {
        return Formatters.customize(new RESTServiceTemplate());
    }

    private Template authenticatorTemplate() {
        return Formatters.customize(new RestAuthenticatorTemplate());
    }
}

