/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.rest;

import cottons.utils.MimeTypes;
import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.action.RESTNotificationActionRenderer;
import io.intino.konos.builder.codegeneration.action.RESTResourceActionRenderer;
import io.intino.konos.builder.codegeneration.services.rest.RestResourceTemplate;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Data;
import io.intino.konos.model.KonosGraph;
import io.intino.konos.model.Parameter;
import io.intino.konos.model.Redirect;
import io.intino.konos.model.Response;
import io.intino.konos.model.Service;
import io.intino.magritte.framework.Node;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;

public class RESTResourceRenderer
extends Renderer {
    public static final String RESOURCES_PACKAGE = "rest/resources";
    public static final String NOTIFICATIONS_PACKAGE = "rest/notifications";
    private final List<Service.REST> services;

    public RESTResourceRenderer(CompilationContext compilationContext, KonosGraph graph) {
        super(compilationContext, Target.Owner);
        this.services = graph.serviceList(Service::isREST).map(Service::asREST).collect(Collectors.toList());
    }

    @Override
    public void render() throws KonosException {
        for (Service.REST service : this.services) {
            this.processService(service);
        }
    }

    private void processService(Service.REST service) throws KonosException {
        for (Service.REST.Resource resource : service.core$().findNode(Service.REST.Resource.class)) {
            this.processResource(resource);
        }
        for (Service.REST.Notification notification : service.core$().findNode(Service.REST.Notification.class)) {
            this.processNotification(notification);
        }
    }

    private void processResource(Service.REST.Resource resource) throws KonosException {
        for (Service.REST.Resource.Operation operation : resource.operationList()) {
            Frame frame = this.frameOf(resource, operation);
            String className = StringHelper.snakeCaseToCamelCase((String)(((Object)((Object)operation)).getClass().getSimpleName() + "_" + resource.name$())) + "Resource";
            File resourcesPackage = new File(this.gen(), RESOURCES_PACKAGE);
            Commons.writeFrame(resourcesPackage, className, this.template().render((Object)frame));
            this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(resource), Commons.javaFile(resourcesPackage, className).getAbsolutePath()));
            this.createCorrespondingAction(operation);
        }
    }

    private void processNotification(Service.REST.Notification notification) throws KonosException {
        String className = StringHelper.snakeCaseToCamelCase((String)notification.name$()) + "Notification";
        Service.REST service = (Service.REST)notification.core$().ownerAs(Service.REST.class);
        FrameBuilder builder = new FrameBuilder(new String[]{"notification"}).add("path", (Object)notification.path());
        this.addCommons(notification.name$(), builder);
        builder.add("parameter", (Object)this.notificationParameters(notification.parameterList()));
        builder.add("returnType", (Object)this.notificationResponse());
        if (service.authentication() != null) {
            builder.add("throws", (Object)"Unauthorized");
        }
        File genNotifications = new File(this.gen(), NOTIFICATIONS_PACKAGE);
        Commons.writeFrame(genNotifications, className, this.template().render((Object)builder.toFrame()));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(service), Commons.javaFile(genNotifications, className).getAbsolutePath()));
        this.createCorrespondingAction(notification);
    }

    private void createCorrespondingAction(Service.REST.Resource.Operation operation) throws KonosException {
        new RESTResourceActionRenderer(this.context, operation).execute();
    }

    private void createCorrespondingAction(Service.REST.Notification notification) throws KonosException {
        new RESTNotificationActionRenderer(this.context, notification).execute();
    }

    private Frame frameOf(Service.REST.Resource resource, Service.REST.Resource.Operation operation) {
        FrameBuilder builder = new FrameBuilder(new String[]{"resource"});
        this.addCommons(resource.name$(), builder);
        builder.add("word", resource.parameterList().stream().filter(Data::isWord).map(RESTResourceRenderer::wordFrame).toArray(Frame[]::new));
        builder.add("word", operation.parameterList().stream().filter(Data::isWord).map(RESTResourceRenderer::wordFrame).toArray(Frame[]::new));
        builder.add("operation", (Object)((Object)((Object)operation)).getClass().getSimpleName());
        builder.add("throws", (Object)this.throwCodes(operation));
        this.authenticated((Service.REST)resource.core$().ownerAs(Service.REST.class), builder);
        builder.add("parameter", (Object)this.parameters(operation.parameterList()));
        builder.add("parameter", (Object)this.parameters(resource.parameterList()));
        if (this.hasResponse(operation)) {
            builder.add("returnType", (Object)this.frameOf(operation.response()));
        }
        if (!resource.graph().schemaList().isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName()).toFrame());
        }
        return builder.toFrame();
    }

    private static Frame wordFrame(Service.REST.Resource.Parameter p) {
        return new FrameBuilder(new String[]{"word"}).add("words", (Object)p.asWord().values().toArray()).add("name", (Object)p.name$()).toFrame();
    }

    private void authenticated(Service.REST service, FrameBuilder builder) {
        if (service.authentication() != null) {
            FrameBuilder b = new FrameBuilder(new String[]{"authenticationValidator"});
            if (service.authentication().isBasic()) {
                b.add("type", (Object)"Basic");
            } else {
                b.add("type", (Object)"Bearer");
            }
            builder.add("authenticationValidator", (Object)b.toFrame());
        }
    }

    private void addCommons(String name, FrameBuilder builder) {
        builder.add("package", (Object)this.packageName());
        builder.add("name", (Object)name);
        builder.add("box", (Object)this.boxName());
    }

    private boolean hasResponse(Service.REST.Resource.Operation operation) {
        return operation.response() != null && (operation.response().isType() || operation.response().i$(Redirect.class));
    }

    private Frame frameOf(Response response) {
        FrameBuilder builder = new FrameBuilder(new String[]{((Object)((Object)response)).getClass().getSimpleName()});
        if (response.asType() != null) {
            builder.add(((Object)((Object)response.asType())).getClass().getSimpleName());
        }
        builder.add("value", (Object)Commons.returnType(response, this.packageName()));
        if (response.isText() && response.dataFormat() != Response.DataFormat.html) {
            builder.add("format", (Object)MimeTypes.get((String)response.dataFormat().toString()));
        }
        return builder.toFrame();
    }

    private Frame notificationResponse() {
        return new FrameBuilder(new String[]{"Response"}).add("value", (Object)String.class.getSimpleName()).add("format", (Object)MimeTypes.get((String)"text")).toFrame();
    }

    private String[] throwCodes(Service.REST.Resource.Operation resource) {
        String[] stringArray;
        List<String> throwCodes = resource.exceptionList().stream().map(r -> r.code().toString()).collect(Collectors.toList());
        if (throwCodes.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "InternalServerError";
        } else {
            stringArray = throwCodes.toArray(new String[0]);
        }
        return stringArray;
    }

    private Frame[] parameters(List<? extends Service.REST.Resource.Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame[] notificationParameters(List<Service.REST.Notification.Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame parameter(Service.REST.Resource.Parameter parameter) {
        FrameBuilder builder = new FrameBuilder(new String[]{"parameter", parameter.in().toString(), ((Object)((Object)parameter.asType())).getClass().getSimpleName(), parameter.isRequired() ? "required" : "optional"});
        if (parameter.isList()) {
            builder.add("List");
        }
        builder.add("name", (Object)parameter.name$()).add("parameterType", (Object)this.parameterType(parameter)).add("in", (Object)parameter.in().name());
        if (parameter.isRequired()) {
            return builder.toFrame();
        }
        if (parameter.isBool()) {
            builder.add("defaultValue").add("defaultValue", (Object)parameter.asBool().defaultValue());
        } else if (parameter.isText() && parameter.asText().defaultValue() != null) {
            builder.add("defaultValue").add("defaultValue", (Object)parameter.asText().defaultValue());
        } else if (parameter.isReal()) {
            builder.add("defaultValue").add("defaultValue", (Object)parameter.asReal().defaultValue());
        } else if (parameter.isInteger()) {
            builder.add("defaultValue").add("defaultValue", (Object)parameter.asInteger().defaultValue());
        } else if (parameter.isLongInteger()) {
            builder.add("defaultValue").add("defaultValue", (Object)parameter.asLongInteger().defaultValue());
        }
        return builder.toFrame();
    }

    private Frame parameter(Service.REST.Notification.Parameter parameter) {
        FrameBuilder builder = new FrameBuilder(new String[]{"parameter", parameter.in().toString(), ((Object)((Object)parameter.asType())).getClass().getSimpleName(), parameter.isRequired() ? "required" : "optional"});
        if (parameter.isList()) {
            builder.add("List");
        }
        return builder.add("name", (Object)parameter.name$()).add("parameterType", (Object)this.parameterType(parameter)).add("in", (Object)parameter.in().name()).toFrame();
    }

    private Frame parameterType(Parameter parameter) {
        String innerPackage = parameter.isObject() && parameter.asObject().isComponent() != false ? String.join((CharSequence)".", this.packageName(), "schemas.") : "";
        FrameBuilder builder = new FrameBuilder();
        if (parameter.isWord()) {
            builder.add("value", (Object)(this.owner(parameter) + "." + Commons.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)parameter.name$()))));
        } else {
            builder.add("value", (Object)(innerPackage + parameter.asType().type()));
        }
        if (parameter.i$(Data.List.class)) {
            builder.add("list");
        }
        return builder.toFrame();
    }

    private Object owner(Parameter parameter) {
        Node owner = parameter.core$().owner();
        if (owner.is(Service.REST.Notification.class)) {
            return Commons.firstUpperCase(owner.name());
        }
        if (owner.is(Service.REST.Resource.Operation.class)) {
            return StringHelper.snakeCaseToCamelCase((String)(((Object)((Object)((Service.REST.Resource.Operation)owner.as(Service.REST.Resource.Operation.class)))).getClass().getSimpleName() + "_" + owner.owner().name())) + "Resource";
        }
        return Commons.firstUpperCase(owner.owner().name());
    }

    private Template template() {
        return Formatters.customize(new RestResourceTemplate());
    }
}

