/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui;

import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.templates.AbstractDesktopTemplate;
import io.intino.konos.builder.codegeneration.services.ui.templates.AbstractDisplayTemplate;
import io.intino.konos.builder.codegeneration.services.ui.templates.DisplayTemplate;
import io.intino.konos.builder.codegeneration.services.ui.templates.PassiveViewNotifierTemplate;
import io.intino.konos.builder.codegeneration.services.ui.templates.PassiveViewPushRequesterTemplate;
import io.intino.konos.builder.codegeneration.services.ui.templates.PassiveViewRequesterTemplate;
import io.intino.konos.builder.codegeneration.ui.TemplateProvider;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.model.PassiveView;
import io.intino.konos.model.Template;
import io.intino.magritte.framework.Layer;

public class ServiceTemplateProvider
implements TemplateProvider {
    @Override
    public Template srcTemplate(Layer layer, FrameBuilder builder) {
        if (builder.is("accessible")) {
            return null;
        }
        if (!ElementHelper.isRoot(layer)) {
            return null;
        }
        return this.setup(new DisplayTemplate());
    }

    @Override
    public Template genTemplate(Layer layer, FrameBuilder builder) {
        if (layer.i$(Template.Desktop.class)) {
            return this.setup(new AbstractDesktopTemplate());
        }
        return this.setup(new AbstractDisplayTemplate());
    }

    @Override
    public Template notifierTemplate(PassiveView element, FrameBuilder builder) {
        return this.setup(new PassiveViewNotifierTemplate());
    }

    @Override
    public Template requesterTemplate(PassiveView element, FrameBuilder builder) {
        return this.setup(new PassiveViewRequesterTemplate());
    }

    @Override
    public Template pushRequesterTemplate(PassiveView element, FrameBuilder builder) {
        return this.setup(new PassiveViewPushRequesterTemplate());
    }

    private Template setup(Template template) {
        return this.addFormats(template);
    }

    private Template addFormats(Template template) {
        return Formatters.customize(template);
    }
}

