/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.resource;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.services.ui.templates.ResourceTemplate;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.ui.resource.PageRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Service;
import io.intino.magritte.framework.Layer;
import java.util.List;
import java.util.stream.Collectors;

public class ResourceRenderer
extends UIRenderer {
    protected final Service.UI.Resource resource;

    public ResourceRenderer(CompilationContext compilationContext, Service.UI.Resource resource, Target target) {
        super(compilationContext, target);
        this.resource = resource;
    }

    @Override
    public void render() throws KonosException {
        Service.UI uiService = (Service.UI)this.resource.core$().ownerAs(Service.UI.class);
        FrameBuilder builder = this.buildFrame().add("resource").add("name", (Object)this.resource.name$()).add("parameter", (Object)this.parameters(this.resource));
        if (this.resource.isStaticPage()) {
            builder.add("static");
        }
        if (uiService.googleApiKey() != null) {
            builder.add("googleApiKey", (Object)Formatters.customize("googleApiKey", uiService.googleApiKey()));
        }
        if (this.resource.isConfidential()) {
            builder.add("confidential", (Object)"");
        }
        Commons.writeFrame(CodeGenerationHelper.resourceFolder(this.gen(), this.target), CodeGenerationHelper.resourceFilename(this.resource.name$()), this.setup(new ResourceTemplate()).render((Object)builder.toFrame()));
        if (this.target.equals((Object)Target.Owner)) {
            this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(this.resource), Commons.javaFile(CodeGenerationHelper.resourceFolder(this.gen(), this.target), CodeGenerationHelper.resourceFilename(this.resource.name$())).getAbsolutePath()));
        }
        new PageRenderer(this.context, this.resource).execute();
    }

    private FrameBuilder[] parameters(Service.UI.Resource resource) {
        List<String> parameters = Commons.extractUrlPathParameters(resource.path());
        parameters.addAll(resource.parameterList().stream().map(Layer::name$).collect(Collectors.toList()));
        return (FrameBuilder[])parameters.stream().map(parameter -> new FrameBuilder().add("parameter").add("name", parameter)).toArray(FrameBuilder[]::new);
    }
}

