/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.passiveview;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.ui.ElementRenderer;
import io.intino.konos.builder.codegeneration.ui.TemplateProvider;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.model.Block;
import io.intino.konos.model.CatalogComponents;
import io.intino.konos.model.Component;
import io.intino.konos.model.DataComponents;
import io.intino.konos.model.Display;
import io.intino.konos.model.Editable;
import io.intino.konos.model.HelperComponents;
import io.intino.konos.model.InteractionComponents;
import io.intino.konos.model.KonosGraph;
import io.intino.konos.model.Multiple;
import io.intino.konos.model.OtherComponents;
import io.intino.konos.model.PassiveView;
import io.intino.konos.model.VisualizationComponents;
import io.intino.magritte.framework.Layer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class PassiveViewRenderer<C extends PassiveView>
extends ElementRenderer<C> {
    private Display virtualParent;
    public static final String ProjectComponentImport = "projectComponentImport";
    public static final String AlexandriaComponentImport = "alexandriaComponentImport";

    protected PassiveViewRenderer(CompilationContext compilationContext, C element, TemplateProvider templateProvider, Target target) {
        super(compilationContext, element, templateProvider, target);
    }

    public Display virtualParent() {
        return this.virtualParent;
    }

    public void virtualParent(Display parent) {
        this.virtualParent = parent;
    }

    @Override
    public FrameBuilder buildFrame() {
        return this.buildFrame(false);
    }

    public FrameBuilder buildFrame(boolean accessible) {
        FrameBuilder result = super.buildFrame();
        if (accessible) {
            result.add("accessible");
        }
        if (((PassiveView)this.element).i$(ElementHelper.conceptOf(CatalogComponents.Collection.class))) {
            result.add("collection");
        }
        FrameBuilder extensionFrame = this.extensionFrame(accessible);
        String type = this.type();
        result.add("id", (Object)this.shortId(this.element, this.virtualParent != null ? this.virtualParent.name$() : ""));
        result.add("type", (Object)type);
        this.addParentImport(result);
        result.add("parentType", (Object)extensionFrame);
        result.add("import", (Object)extensionFrame);
        result.add("proxy", (Object)extensionFrame);
        if (!type.equalsIgnoreCase("display")) {
            result.add("packageType", (Object)type.toLowerCase());
        }
        result.add("packageTypeRelativeDirectory", (Object)this.packageTypeRelativeDirectory((PassiveView)this.element));
        result.add("componentDirectory", (Object)this.componentDirectoryOf((PassiveView)this.element, false));
        result.add("name", (Object)this.nameOf(this.element));
        result.add("notification", (Object)this.framesOfNotifications(((PassiveView)this.element).notificationList()));
        result.add("event", (Object)this.framesOfEvents((PassiveView)this.element));
        result.add("request", (Object)this.framesOfRequests(((PassiveView)this.element).requestList()));
        return result;
    }

    protected void createPassiveViewFiles(FrameBuilder elementBuilder) {
        boolean modified = this.context.cache().isModified(this.element);
        File requesterFile = Commons.javaFile(CodeGenerationHelper.displayRequesterFolder(this.gen(), this.target), this.nameOfPassiveViewFile((PassiveView)this.element, elementBuilder.toFrame(), "Requester"));
        if (modified || !requesterFile.exists()) {
            this.writeRequester(elementBuilder);
        }
        File pushRequesterFile = Commons.javaFile(CodeGenerationHelper.displayRequesterFolder(this.gen(), this.target), this.nameOfPassiveViewFile((PassiveView)this.element, elementBuilder.toFrame(), "PushRequester"));
        if (modified || !pushRequesterFile.exists()) {
            this.writePushRequester(elementBuilder);
        }
        File notifierFile = Commons.javaFile(CodeGenerationHelper.displayNotifierFolder(this.gen(), this.target), this.nameOfPassiveViewFile((PassiveView)this.element, elementBuilder.toFrame(), "Notifier"));
        if (modified || !notifierFile.exists()) {
            this.writeNotifier(elementBuilder);
        }
    }

    protected String type() {
        return this.typeOf(((PassiveView)this.element).a$(Display.class));
    }

    protected void writeRequester(PassiveView element, FrameBuilder builder) {
        Frame frame = builder.toFrame();
        String name = this.nameOfPassiveViewFile(element, frame, "Requester");
        if (this.hasConcreteRequester(element)) {
            this.writeFrame(CodeGenerationHelper.displayRequesterFolder(this.gen(), this.target), name, this.displayRequesterTemplate(builder).render((Object)frame));
            this.registerClass(builder, CodeGenerationHelper.displayRequesterFolder(this.gen(), this.target), "Requester");
        }
    }

    protected void writePushRequester(PassiveView element, FrameBuilder builder) {
        Frame frame = builder.toFrame();
        Template template = this.displayPushRequesterTemplate(builder);
        boolean accessible = this.isAccessible(frame);
        if (accessible || template == null) {
            return;
        }
        String name = this.nameOfPassiveViewFile(element, frame, "PushRequester");
        if (this.hasConcreteRequester(element)) {
            this.writeFrame(CodeGenerationHelper.displayRequesterFolder(this.gen(), this.target), name, template.render((Object)frame));
            this.registerClass(builder, CodeGenerationHelper.displayRequesterFolder(this.gen(), this.target), "PushRequester");
        }
    }

    protected void writeNotifier(PassiveView element, FrameBuilder builder) {
        Frame frame = builder.toFrame();
        String name = this.nameOfPassiveViewFile(element, frame, "Notifier");
        if (this.hasConcreteNotifier(element)) {
            this.writeFrame(CodeGenerationHelper.displayNotifierFolder(this.gen(), this.target), name, this.displayNotifierTemplate(builder).render((Object)frame));
            this.registerClass(builder, CodeGenerationHelper.displayNotifierFolder(this.gen(), this.target), "Notifier");
        }
    }

    protected void registerClass(FrameBuilder builder, File folder, String suffix) {
        if (!this.target.equals((Object)Target.Owner)) {
            return;
        }
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(this.element), Commons.javaFile(folder, this.nameOfPassiveViewFile((PassiveView)this.element, builder.toFrame(), suffix)).getAbsolutePath()));
    }

    protected String nameOfPassiveViewFile(PassiveView element, Frame frame, String suffix) {
        return this.nameOfPassiveViewFile(element, this.isAccessible(frame), suffix);
    }

    protected String nameOfPassiveViewFile(PassiveView element, boolean accessible, String suffix) {
        return StringHelper.snakeCaseToCamelCase((String)(element.name$() + (accessible ? "Proxy" : "") + suffix));
    }

    protected void addGeneric(PassiveView element, FrameBuilder builder) {
        if (!this.isGeneric(element)) {
            return;
        }
        builder.add("generic");
        if (element.isExtensionOf()) {
            builder.add("isExtensionOf");
        }
        builder.add("parent", (Object)this.genericParent(element));
    }

    protected boolean isGeneric(PassiveView element) {
        return element.isExtensionOf() || KonosGraph.isParent(this.context.graphName(), element);
    }

    protected String genericParent(PassiveView element) {
        if (element.isExtensionOf()) {
            return Formatters.firstUpperCase(element.asExtensionOf().parentView().name$());
        }
        return (this.target != Target.Accessor ? "io.intino.alexandria.ui.displays." : "") + Formatters.firstUpperCase(this.typeOf(element));
    }

    protected String packageTypeRelativeDirectory(PassiveView passiveView) {
        return this.typeOf(passiveView).equalsIgnoreCase("display") ? "" : "../";
    }

    protected void addComponentsImports(FrameBuilder builder) {
        if (((PassiveView)this.element).i$(ElementHelper.conceptOf(HelperComponents.Row.class))) {
            this.addComponentsImports(((HelperComponents.Row)((PassiveView)this.element).a$(HelperComponents.Row.class)).items().stream().map(i -> (Component)i.a$(Component.class)).collect(Collectors.toList()), builder);
        } else {
            this.addComponentsImports(this.components((PassiveView)this.element), builder);
        }
    }

    protected void addComponentsImports(List<Component> componentList, FrameBuilder builder) {
        HashSet<String> imported = new HashSet<String>();
        this.addComponentsImports(imported, componentList, builder);
        if (!imported.contains("Block") && ((PassiveView)this.element).i$(ElementHelper.conceptOf(io.intino.konos.model.Template.class))) {
            builder.add("alexandriaBlockImport", (Object)new FrameBuilder(new String[]{"alexandriaImport"}).add("name", (Object)"Block"));
        }
    }

    protected List<Component> components(PassiveView passiveView) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (passiveView.i$(ElementHelper.conceptOf(Block.class))) {
            components.addAll(((Block)passiveView.a$(Block.class)).componentList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(io.intino.konos.model.Template.class))) {
            components.addAll(((io.intino.konos.model.Template)passiveView.a$(io.intino.konos.model.Template.class)).componentList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.Snackbar.class))) {
            components.addAll(((OtherComponents.Snackbar)passiveView.a$(OtherComponents.Snackbar.class)).componentList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(VisualizationComponents.Stepper.class))) {
            components.addAll(((VisualizationComponents.Stepper)passiveView.a$(VisualizationComponents.Stepper.class)).stepList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(VisualizationComponents.Stepper.Step.class))) {
            components.addAll(((VisualizationComponents.Stepper.Step)passiveView.a$(VisualizationComponents.Stepper.Step.class)).componentList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(VisualizationComponents.Header.class))) {
            components.addAll(((VisualizationComponents.Header)passiveView.a$(VisualizationComponents.Header.class)).componentList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.Selector.class))) {
            if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.Selector.CollectionBox.class)) && ((OtherComponents.Selector.CollectionBox)passiveView.a$(OtherComponents.Selector.CollectionBox.class)).source() != null) {
                components.add(((OtherComponents.Selector.CollectionBox)passiveView.a$(OtherComponents.Selector.CollectionBox.class)).source());
            } else {
                components.addAll(((OtherComponents.Selector)passiveView.a$(OtherComponents.Selector.class)).componentList());
            }
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.User.class))) {
            components.addAll(((OtherComponents.User)passiveView.a$(OtherComponents.User.class)).componentList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(CatalogComponents.Table.class))) {
            components.addAll(((CatalogComponents.Table)passiveView.a$(CatalogComponents.Table.class)).moldList().stream().filter(m -> m.heading() != null).map(CatalogComponents.Moldable.Mold::heading).collect(Collectors.toList()));
        }
        if (passiveView.i$(ElementHelper.conceptOf(CatalogComponents.DynamicTable.class))) {
            components.addAll(((CatalogComponents.DynamicTable)passiveView.a$(CatalogComponents.DynamicTable.class)).moldList().stream().filter(m -> m.heading() != null).map(CatalogComponents.Moldable.Mold::heading).collect(Collectors.toList()));
        }
        if (passiveView.i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Heading.class))) {
            components.addAll(((CatalogComponents.Moldable.Mold.Heading)passiveView.a$(CatalogComponents.Moldable.Mold.Heading.class)).componentList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Item.class))) {
            components.addAll(((CatalogComponents.Moldable.Mold.Item)passiveView.a$(CatalogComponents.Moldable.Mold.Item.class)).componentList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(InteractionComponents.Toolbar.class))) {
            components.addAll(((InteractionComponents.Toolbar)passiveView.a$(InteractionComponents.Toolbar.class)).componentList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.Dialog.class))) {
            components.addAll(((OtherComponents.Dialog)passiveView.a$(OtherComponents.Dialog.class)).componentList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.DecisionDialog.class))) {
            components.add(((OtherComponents.DecisionDialog)passiveView.a$(OtherComponents.DecisionDialog.class)).selector());
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.CollectionDialog.class))) {
            components.add(((OtherComponents.CollectionDialog)passiveView.a$(OtherComponents.CollectionDialog.class)).collection());
        }
        return components;
    }

    protected void addFacets(PassiveView passiveView, FrameBuilder builder) {
        List<String> facets = this.facets(passiveView);
        facets.forEach(facet -> builder.add("facet", facet));
    }

    private List<String> facets(PassiveView passiveView) {
        ArrayList<String> result = new ArrayList<String>();
        if (passiveView.i$(ElementHelper.conceptOf(InteractionComponents.Switch.class))) {
            result.add("Switch");
        }
        if (passiveView.i$(ElementHelper.conceptOf(InteractionComponents.AbstractSplitButton.class))) {
            result.add("Split");
        }
        if (passiveView.i$(ElementHelper.conceptOf(InteractionComponents.Toggle.class)) || passiveView.i$(ElementHelper.conceptOf(InteractionComponents.IconToggle.class)) || passiveView.i$(ElementHelper.conceptOf(InteractionComponents.MaterialIconToggle.class))) {
            result.add("Toggle");
        }
        if (passiveView.i$(ElementHelper.conceptOf(Editable.class))) {
            result.add("Editable");
        }
        if (passiveView.i$(ElementHelper.conceptOf(DataComponents.Text.Code.class))) {
            result.add("Code");
        }
        if (passiveView.i$(ElementHelper.conceptOf(Block.Drawer.class))) {
            result.add("Drawer");
        }
        if (passiveView.i$(ElementHelper.conceptOf(Block.Badge.class))) {
            result.add("Badge");
        }
        if (passiveView.i$(ElementHelper.conceptOf(Block.Conditional.class))) {
            result.add("Conditional");
        }
        if (passiveView.i$(ElementHelper.conceptOf(Block.Popover.class))) {
            result.add("Popover");
        }
        if (passiveView.i$(ElementHelper.conceptOf(Block.Splitter.class))) {
            result.add("Splitter");
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.Selector.Tabs.class))) {
            result.add("Tabs");
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.Selector.Menu.class))) {
            result.add("Menu");
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.Selector.ToggleBox.class))) {
            result.add("ToggleBox");
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.Selector.ComboBox.class))) {
            result.add("ComboBox");
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.Selector.CollectionBox.class))) {
            result.add("CollectionBox");
        }
        if (passiveView.i$(ElementHelper.conceptOf(CatalogComponents.Grouping.ComboBox.class))) {
            result.add("ComboBox");
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.Selector.ListBox.class))) {
            result.add("ListBox");
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.Selector.RadioBox.class))) {
            result.add("RadioBox");
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.Selector.CheckBox.class))) {
            result.add("CheckBox");
        }
        if (passiveView.i$(ElementHelper.conceptOf(DataComponents.Image.Avatar.class))) {
            result.add("Avatar");
        }
        if (passiveView.i$(ElementHelper.conceptOf(CatalogComponents.Sorting.OrderBy.class))) {
            result.add("OrderBy");
        }
        if (passiveView.i$(ElementHelper.conceptOf(Block.Parallax.class))) {
            result.add("Parallax");
        }
        if (passiveView.i$(ElementHelper.conceptOf(VisualizationComponents.Dashboard.Shiny.class))) {
            result.add("Shiny");
        }
        if (passiveView.i$(ElementHelper.conceptOf(VisualizationComponents.Dashboard.Metabase.class))) {
            result.add("Metabase");
        }
        if (passiveView.i$(ElementHelper.conceptOf(DataComponents.DigitalSignature.AutoFirma.class))) {
            result.add("AutoFirma");
        }
        return result;
    }

    private FrameBuilder importOf(PassiveView passiveView, String container, boolean multiple) {
        FrameBuilder result = new FrameBuilder(new String[]{container});
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.OwnerTemplateStamp.class))) {
            result.add("ownertemplatestamp");
        }
        result.add("name", (Object)this.importNameOf(passiveView));
        result.add("type", this.importTypeOf(passiveView, multiple));
        result.add("directory", (Object)this.directoryOf(passiveView));
        String componentDirectory = this.componentDirectoryOf(passiveView, multiple);
        result.add("componentTarget", (Object)(componentDirectory != null && componentDirectory.equals("components") || this.hasAbstractClass(passiveView) ? "src" : "gen"));
        result.add("componentDirectory", (Object)componentDirectory);
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.OwnerTemplateStamp.class))) {
            result.add("ownerModuleName", (Object)StringHelper.camelCaseToSnakeCase((String)((OtherComponents.OwnerTemplateStamp)passiveView.a$(OtherComponents.OwnerTemplateStamp.class)).owner().service()));
        }
        if (this.context.webModuleDirectory().exists()) {
            result.add("webModuleName", (Object)this.context.webModuleDirectory().getName());
        }
        if (!multiple) {
            this.addFacets(passiveView, result);
        }
        return result;
    }

    private String importNameOf(PassiveView passiveView) {
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.OwnerTemplateStamp.class))) {
            return ((OtherComponents.OwnerTemplateStamp)passiveView.a$(OtherComponents.OwnerTemplateStamp.class)).template();
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.TemplateStamp.class))) {
            return ((OtherComponents.TemplateStamp)passiveView.a$(OtherComponents.TemplateStamp.class)).template().name$();
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.DisplayStamp.class))) {
            Display display = ((OtherComponents.DisplayStamp)passiveView.a$(OtherComponents.DisplayStamp.class)).display();
            return display != null ? display.name$() : this.nameOf(passiveView);
        }
        return this.nameOf(passiveView);
    }

    protected Object importTypeOf(PassiveView passiveView, boolean multiple) {
        if (multiple) {
            return passiveView.i$(ElementHelper.conceptOf(DataComponents.Image.class)) ? "MultipleImage" : "multiple";
        }
        if (passiveView.i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Item.class)) || passiveView.i$(ElementHelper.conceptOf(HelperComponents.Row.class))) {
            return passiveView.name$();
        }
        return this.typeOf(passiveView);
    }

    protected PassiveView componentOf(PassiveView passiveView) {
        PassiveView component = passiveView;
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.TemplateStamp.class))) {
            component = ((OtherComponents.TemplateStamp)passiveView.a$(OtherComponents.TemplateStamp.class)).template();
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.DisplayStamp.class))) {
            Display display = ((OtherComponents.DisplayStamp)passiveView.a$(OtherComponents.DisplayStamp.class)).display();
            component = display != null ? display : passiveView;
        }
        return component;
    }

    private String directoryOf(PassiveView passiveView) {
        PassiveView component = this.componentOf(passiveView);
        return ElementHelper.isRoot(component) && this.hasAbstractClass(component) ? "src" : "gen";
    }

    private String componentDirectoryOf(PassiveView passiveView, boolean multiple) {
        if (multiple && passiveView.i$(ElementHelper.conceptOf(Multiple.class))) {
            return "components";
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.TemplateStamp.class))) {
            io.intino.konos.model.Template template = ((OtherComponents.TemplateStamp)passiveView.a$(OtherComponents.TemplateStamp.class)).template();
            return template != null ? this.componentDirectoryOf(template, multiple) : null;
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.DisplayStamp.class))) {
            Display display = ((OtherComponents.DisplayStamp)passiveView.a$(OtherComponents.DisplayStamp.class)).display();
            return display != null ? this.componentDirectoryOf(display, multiple) : null;
        }
        if (passiveView.i$(ElementHelper.conceptOf(io.intino.konos.model.Template.class))) {
            return "templates";
        }
        if (passiveView.i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Item.class))) {
            return "items";
        }
        if (passiveView.i$(ElementHelper.conceptOf(HelperComponents.Row.class))) {
            return "rows";
        }
        if (passiveView.i$(ElementHelper.conceptOf(Component.class))) {
            return "components";
        }
        return null;
    }

    private void writeRequester(FrameBuilder builder) {
        this.writeRequester((PassiveView)this.element, builder);
    }

    private void writePushRequester(FrameBuilder builder) {
        this.writePushRequester((PassiveView)this.element, builder);
    }

    private boolean isAccessible(Frame frame) {
        return frame.is("accessible");
    }

    private void writeNotifier(FrameBuilder builder) {
        this.writeNotifier((PassiveView)this.element, builder);
    }

    private Template displayNotifierTemplate(FrameBuilder builder) {
        return this.setup(this.notifierTemplate(builder));
    }

    private Template displayRequesterTemplate(FrameBuilder builder) {
        return this.setup(this.requesterTemplate(builder));
    }

    private Template displayPushRequesterTemplate(FrameBuilder builder) {
        Template template = this.pushRequesterTemplate(builder);
        return template != null ? this.setup(template) : null;
    }

    private FrameBuilder extensionFrame(boolean accessible) {
        String type = this.type();
        FrameBuilder result = new FrameBuilder().add(type, (Object)"").add("value", (Object)type).add("type", (Object)type);
        if (((PassiveView)this.element).isExtensionOf()) {
            result.add("extensionOf", (Object)"extensionOf");
            result.add("parent", (Object)((PassiveView)this.element).asExtensionOf().parentView().name$());
        }
        if (type.equalsIgnoreCase("Component")) {
            result.add("component", (Object)"component");
        } else if (accessible && ((PassiveView)this.element).i$(ElementHelper.conceptOf(Display.Accessible.class))) {
            result.add("accessible", (Object)"accessible");
        } else if (this.isBaseType((PassiveView)this.element) && !type.equalsIgnoreCase("Display")) {
            result.add("baseType", (Object)"baseType");
        }
        return result;
    }

    private Frame[] framesOfNotifications(List<PassiveView.Notification> notifications) {
        return (Frame[])notifications.stream().map(this::frameOf).toArray(Frame[]::new);
    }

    private Frame frameOf(PassiveView.Notification notification) {
        FrameBuilder result = new FrameBuilder().add("notification");
        result.add("name", (Object)notification.name$());
        result.add("target", (Object)notification.to().name());
        if (notification.isType()) {
            FrameBuilder parameterFrame = new FrameBuilder().add("parameter").add(notification.asType().type()).add(((Object)((Object)notification.asType())).getClass().getSimpleName().replace("Data", "")).add("value", (Object)notification.asType().type());
            if (notification.isList()) {
                parameterFrame.add("list");
            }
            result.add("parameter", (Object)parameterFrame);
        }
        return result.toFrame();
    }

    private Frame[] framesOfEvents(C element) {
        if (!element.i$(ElementHelper.conceptOf(Display.Accessible.class))) {
            return new Frame[0];
        }
        List<String> events = ((Display.Accessible)element.a$(Display.Accessible.class)).events();
        return (Frame[])events.stream().map(e -> new FrameBuilder(new String[]{"event"}).add("name", e).toFrame()).toArray(Frame[]::new);
    }

    private Frame[] framesOfRequests(List<PassiveView.Request> requests) {
        return (Frame[])requests.stream().map(r -> PassiveViewRenderer.frameOf(this.element, r, this.packageName())).toArray(Frame[]::new);
    }

    private Template notifierTemplate(FrameBuilder builder) {
        return this.templateProvider.notifierTemplate((PassiveView)this.element, builder);
    }

    private Template requesterTemplate(FrameBuilder builder) {
        return this.templateProvider.requesterTemplate((PassiveView)this.element, builder);
    }

    private Template pushRequesterTemplate(FrameBuilder builder) {
        return this.templateProvider.pushRequesterTemplate((PassiveView)this.element, builder);
    }

    private void addParentImport(FrameBuilder builder) {
        FrameBuilder result = new FrameBuilder().add("value", (Object)this.type());
        if (this.isGeneric((PassiveView)this.element) && ((PassiveView)this.element).isExtensionOf()) {
            result.add("parent", (Object)this.genericParent((PassiveView)this.element));
            result.add("parentDirectory", (Object)this.componentDirectoryOf(((PassiveView)this.element).asExtensionOf().parentView(), false));
        } else if (this.typeOf(this.element).equalsIgnoreCase("component")) {
            result.add("baseComponent", (Object)"");
        } else if (builder.is("accessible")) {
            result.add("accessible", (Object)"");
        } else if (this.typeOf(this.element).equalsIgnoreCase("display")) {
            result.add("baseDisplay", (Object)"");
        } else if (((PassiveView)this.element).i$(ElementHelper.conceptOf(Component.class))) {
            if (this.isEmbeddedComponent((Component)((PassiveView)this.element).a$(Component.class))) {
                result.add("embeddedComponent", (Object)"");
            } else {
                result.add("component", (Object)"");
            }
        } else if (ElementHelper.isRoot(this.element)) {
            result.add("abstract", (Object)"");
        }
        builder.add("parent", (Object)result);
    }

    private void addComponentsImports(Set<String> imported, List<Component> componentList, FrameBuilder builder) {
        componentList.forEach(c -> {
            boolean multiple = c.i$(ElementHelper.conceptOf(Multiple.class));
            String baseType = this.importTypeOf((PassiveView)((Object)c), multiple) + String.join((CharSequence)"", this.facets((PassiveView)((Object)c)));
            String type = multiple && !c.i$(ElementHelper.conceptOf(DataComponents.Image.class)) ? "multiple" : baseType;
            boolean isProjectComponent = this.isProjectComponent((Component)((Object)c));
            String key = this.keyOf((Component)((Object)c), type);
            String importType = this.isProjectComponent((Component)((Object)c)) ? ProjectComponentImport : AlexandriaComponentImport;
            this.registerConcreteImports((Component)((Object)c), builder);
            this.registerMultipleImport(imported, multiple, type, (Component)((Object)c), builder);
            if (key != null && !imported.contains(key)) {
                builder.add(importType, (Object)this.importOf((PassiveView)((Object)c), importType, isProjectComponent ? false : multiple));
            }
            if (key != null) {
                imported.add(key);
            }
            if (c.i$(ElementHelper.conceptOf(CatalogComponents.Moldable.class))) {
                this.registerMoldableImports(imported, (Component)((Object)c), builder);
            }
            if (c.i$(ElementHelper.conceptOf(HelperComponents.Row.class))) {
                this.registerRowImports(imported, (Component)((Object)c), builder);
            }
            if (!c.i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Item.class)) && !c.i$(ElementHelper.conceptOf(io.intino.konos.model.Template.class))) {
                this.addComponentsImports(imported, this.components((PassiveView)((Object)c)), builder);
            }
        });
    }

    protected void registerConcreteImports(Component component, FrameBuilder builder) {
        if (component.i$(ElementHelper.conceptOf(OtherComponents.TemplateStamp.class)) && !builder.contains("alexandriaTemplateStampImport")) {
            builder.add("alexandriaTemplateStampImport", (Object)new FrameBuilder(new String[]{"alexandriaImport"}).add("name", (Object)"TemplateStamp"));
        }
        if (component.i$(ElementHelper.conceptOf(OtherComponents.DisplayStamp.class)) && !builder.contains("alexandriaDisplayStampImport")) {
            builder.add("alexandriaDisplayStampImport", (Object)new FrameBuilder(new String[]{"alexandriaImport"}).add("name", (Object)"DisplayStamp"));
        }
    }

    protected boolean isProjectComponent(Component component) {
        if (component.i$(ElementHelper.conceptOf(OtherComponents.ProxyStamp.class))) {
            return false;
        }
        if (component.i$(ElementHelper.conceptOf(OtherComponents.BaseStamp.class))) {
            return true;
        }
        if (component.i$(ElementHelper.conceptOf(HelperComponents.Row.class))) {
            return true;
        }
        return component.i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Item.class));
    }

    protected boolean isEmbeddedComponent(Component component) {
        if (!component.i$(ElementHelper.conceptOf(CatalogComponents.Collection.class))) {
            return false;
        }
        return component.core$().graph().rootList().contains(component.core$());
    }

    private String keyOf(Component component, String type) {
        if (component == null) {
            return type;
        }
        if (component.i$(ElementHelper.conceptOf(OtherComponents.OwnerTemplateStamp.class))) {
            return ((OtherComponents.OwnerTemplateStamp)component.a$(OtherComponents.OwnerTemplateStamp.class)).template();
        }
        if (component.i$(ElementHelper.conceptOf(OtherComponents.TemplateStamp.class))) {
            io.intino.konos.model.Template template = ((OtherComponents.TemplateStamp)component.a$(OtherComponents.TemplateStamp.class)).template();
            return template != null ? template.name$() : null;
        }
        if (component.i$(ElementHelper.conceptOf(OtherComponents.DisplayStamp.class))) {
            Display display = ((OtherComponents.DisplayStamp)component.a$(OtherComponents.DisplayStamp.class)).display();
            return display != null ? display.name$() : null;
        }
        return type;
    }

    private void registerMultipleImport(Set<String> imported, boolean multiple, String type, Component component, FrameBuilder builder) {
        if (!multiple || imported.contains(type)) {
            return;
        }
        builder.add(AlexandriaComponentImport, (Object)this.importOf(component, AlexandriaComponentImport, true));
        imported.add(type);
    }

    private void registerRowImports(Set<String> imported, Component component, FrameBuilder builder) {
        this.addComponentsImports(imported, ((HelperComponents.Row)component.a$(HelperComponents.Row.class)).items().stream().map(i -> (Component)i.a$(Component.class)).collect(Collectors.toList()), builder);
    }

    private void registerMoldableImports(Set<String> imported, Component component, FrameBuilder builder) {
        if (component.i$(ElementHelper.conceptOf(CatalogComponents.Table.class)) || component.i$(ElementHelper.conceptOf(CatalogComponents.DynamicTable.class))) {
            String name = component.name$().toLowerCase();
            this.addComponentsImports(imported, component.graph().rowsDisplays(this.context.graphName()).stream().filter(r -> r.name$().toLowerCase().startsWith(name)).map(r -> (Component)r.a$(Component.class)).collect(Collectors.toList()), builder);
        } else {
            this.addComponentsImports(imported, ((CatalogComponents.Moldable)component.a$(CatalogComponents.Moldable.class)).moldList().stream().map(CatalogComponents.Moldable.Mold::item).collect(Collectors.toList()), builder);
        }
    }

    public static Frame frameOf(Layer element, PassiveView.Request request, String packageName) {
        FrameBuilder result = new FrameBuilder().add("request");
        result.add("display", (Object)element.name$());
        if (request.responseType().equals((Object)PassiveView.Request.ResponseType.Asset)) {
            result.add("asset");
        }
        if (request.isFile()) {
            result.add("file");
        }
        result.add("name", (Object)request.name$());
        if (request.isType()) {
            FrameBuilder parameterFrame = new FrameBuilder().add("parameter").add(request.asType().type()).add(((Object)((Object)request.asType())).getClass().getSimpleName().replace("Data", "")).add("value", (Object)PassiveViewRenderer.parameter(request, packageName));
            if (request.isList()) {
                parameterFrame.add("list");
            }
            result.add("parameter", (Object)parameterFrame);
            result.add("parameterSignature", (Object)"value");
        }
        if (request.responseType() == PassiveView.Request.ResponseType.Asset) {
            result.add("method", (Object)new FrameBuilder().add("download", (Object)"download"));
        } else if (request.isFile()) {
            result.add("method", (Object)new FrameBuilder().add("upload", (Object)"upload"));
        } else {
            result.add("method", (Object)new FrameBuilder());
        }
        return result.toFrame();
    }

    private static String parameter(PassiveView.Request request, String packageName) {
        return request.isObject() ? packageName.toLowerCase() + ".schemas." + request.asType().type() : request.asType().type();
    }
}

