/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.CompilerConfiguration;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.BoxTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.KonosGraph;
import io.intino.magritte.dsl.Meta;
import io.intino.magritte.dsl.Proteo;
import java.lang.invoke.CallSite;
import java.util.ArrayList;

public class BoxRenderer
extends Renderer {
    private final KonosGraph graph;
    private final boolean hasModel;

    BoxRenderer(CompilationContext context, KonosGraph graph, boolean hasModel) {
        super(context, Target.Owner);
        this.graph = graph;
        this.hasModel = hasModel;
    }

    @Override
    public void render() {
        if (this.configuration() == null) {
            return;
        }
        String name = this.context.boxName();
        if (Commons.javaFile(this.src(), StringHelper.snakeCaseToCamelCase((String)name) + "Box").exists()) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"Box"}).add("package", (Object)this.packageName()).add("name", (Object)name);
        if (this.hasModel) {
            builder.add("tara", (Object)this.fillTara());
        }
        if (!this.graph.uiServiceList().isEmpty()) {
            builder.add("hasUi", (Object)new FrameBuilder().add("package", (Object)this.packageName()));
        }
        this.context.compiledFiles().add(new OutputItem(this.src().getAbsolutePath(), Commons.javaFile(this.src(), StringHelper.snakeCaseToCamelCase((String)name) + "Box").getAbsolutePath()));
        Commons.writeFrame(this.src(), StringHelper.snakeCaseToCamelCase((String)name) + "Box", this.template().render((Object)builder.toFrame()));
    }

    private Frame fillTara() {
        FrameBuilder builder = new FrameBuilder();
        CompilerConfiguration configuration = this.configuration();
        builder.add("name", (Object)this.context.boxName());
        if (configuration.model() != null && configuration.model().outDsl() != null) {
            builder.add("outDSL", (Object)configuration.model().outDsl());
        }
        builder.add("wrapper", (Object)this.dsls());
        return builder.toFrame();
    }

    private String[] dsls() {
        CompilerConfiguration configuration = this.configuration();
        ArrayList<CallSite> dsls = new ArrayList<CallSite>();
        if (configuration.model() == null) {
            return new String[0];
        }
        String language = configuration.model().language();
        if (!Meta.class.getSimpleName().equals(language) && !Proteo.class.getSimpleName().equals(language)) {
            String genPackage = configuration.model().generationPackage();
            dsls.add((CallSite)((Object)((String)(genPackage == null ? "" : genPackage.toLowerCase() + ".") + Formatters.firstUpperCase(language))));
        }
        if (!configuration.model().level().isSolution()) {
            dsls.add((CallSite)((Object)(configuration.generationPackage().toLowerCase() + "." + Formatters.firstUpperCase(configuration.model().outDsl()))));
        }
        return dsls.toArray(new String[0]);
    }

    private Template template() {
        return Formatters.customize(new BoxTemplate());
    }
}

