/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.schema;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.schema.SchemaTemplate;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Data;
import io.intino.konos.model.Schema;
import io.intino.konos.model.Service;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SchemaRenderer
extends Renderer {
    private final Schema schema;
    private final File destination;
    private final boolean serializationAnnotations;
    private final String packageName;

    public SchemaRenderer(CompilationContext compilationContext, Schema schema, File destination, String packageName, boolean serializationAnnotations) {
        super(compilationContext, Target.Owner);
        this.schema = schema;
        this.destination = destination != null ? destination : this.gen();
        this.serializationAnnotations = serializationAnnotations;
        this.packageName = packageName != null ? packageName : compilationContext.packageName();
    }

    @Override
    public void render() {
        String rootPackage = this.packageName;
        String subPackage = this.subPackage(this.schema);
        File packageFolder = this.schemaFolder(this.schema);
        String packageName = subPackage.isEmpty() ? rootPackage : rootPackage + "." + subPackage.replace(File.separator, ".");
        Frame frame = this.createSchemaFrame(this.schema, packageName);
        this.classes().put(Schema.class.getSimpleName() + "#" + this.schema.name$(), subPackage.replace(File.separator, ".") + "." + this.schema.name$());
        Commons.writeFrame(packageFolder, this.schema.name$(), this.template().render((Object)new FrameBuilder(new String[]{"root"}).add("root", (Object)rootPackage).add("package", (Object)packageName).add("schema", (Object)frame)));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(this.schema), Commons.javaFile(packageFolder, this.schema.name$()).getAbsolutePath()));
    }

    public Frame createSchemaFrame(Schema schema, String packageName) {
        return this.createSchemaFrame(schema, packageName, new HashSet<Schema>());
    }

    private String subPackage(Schema schema) {
        return this.subPackage((Service)schema.core$().ownerAs(Service.class));
    }

    private String subPackage(Service service) {
        return "schemas" + (String)(service != null ? File.separator + service.name$().toLowerCase() : "");
    }

    private File schemaFolder(Schema schema) {
        return new File(this.destination, this.subPackage(schema));
    }

    private Frame createSchemaFrame(Schema schema, String packageName, Set<Schema> processed) {
        Frame[] components;
        FrameBuilder builder = new FrameBuilder(new String[]{"schema"}).add("name", (Object)schema.name$()).add("package", (Object)packageName);
        if (schema.core$().owner().is(Schema.class)) {
            builder.add("inner", (Object)"static");
        }
        builder.add("attribute", (Object)this.collectAttributes(schema));
        if (schema.isExtensionOf()) {
            builder.add("parent", (Object)schema.asExtensionOf().parent().name$());
        }
        if ((components = this.components(schema, packageName, processed)).length > 0) {
            builder.add("schema", (Object)components);
        }
        return builder.toFrame();
    }

    private Frame[] components(Schema schema, String packageName, Set<Schema> processed) {
        return (Frame[])schema.schemaList().stream().filter(processed::add).map(s -> this.createSchemaFrame((Schema)((Object)s), packageName, processed)).toArray(Frame[]::new);
    }

    private FrameBuilder[] collectAttributes(Schema schema) {
        ArrayList attributes = new ArrayList();
        Collections.addAll(attributes, this.processAttributes(schema.attributeList()));
        Collections.addAll(attributes, this.processSchemasAsAttribute(schema.schemaList()));
        attributes.forEach(f -> f.add("element", (Object)schema.name$()));
        return attributes.toArray(new FrameBuilder[0]);
    }

    private FrameBuilder[] processAttributes(List<Schema.Attribute> attributes) {
        return (FrameBuilder[])attributes.stream().map(this::process).filter(Objects::nonNull).map(fb -> this.serializationAnnotations ? fb.add("annotated") : fb).toArray(FrameBuilder[]::new);
    }

    private FrameBuilder[] processSchemasAsAttribute(List<Schema> schemas) {
        return (FrameBuilder[])schemas.stream().map(s -> this.processSchema((Schema)((Object)s), s.name$(), s.multiple())).toArray(FrameBuilder[]::new);
    }

    private FrameBuilder process(Schema.Attribute attribute) {
        if (attribute.isReal()) {
            return this.process(attribute.asReal());
        }
        if (attribute.isInteger()) {
            return this.process(attribute.asInteger());
        }
        if (attribute.isBool()) {
            return this.process(attribute.asBool());
        }
        if (attribute.isText()) {
            return this.process(attribute.asText());
        }
        if (attribute.isDateTime()) {
            return this.process(attribute.asDateTime());
        }
        if (attribute.isDate()) {
            return this.process(attribute.asDate());
        }
        if (attribute.isFile()) {
            return this.process(attribute.asFile());
        }
        if (attribute.isLongInteger()) {
            return this.process(attribute.asLongInteger());
        }
        if (attribute.isWord()) {
            return this.process(attribute.asWord());
        }
        if (attribute.isMap()) {
            return this.process(attribute.asMap());
        }
        if (attribute.isObject()) {
            return this.processObjectAttribute(attribute.asObject().schema(), attribute.name$(), attribute.isList());
        }
        return null;
    }

    private FrameBuilder process(Data.Real attribute) {
        return new FrameBuilder(new String[]{"primitive", this.multiple(attribute) ? "multiple" : "single", "double"}).add("name", (Object)((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()).add("type", (Object)(!this.multiple(attribute) ? "double" : attribute.type())).add("defaultValue", (Object)attribute.defaultValue());
    }

    private FrameBuilder process(Data.Integer attribute) {
        return new FrameBuilder(new String[]{"primitive", this.multiple(attribute) ? "multiple" : "single", attribute.type()}).add("name", (Object)((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()).add("type", (Object)(!this.multiple(attribute) ? "int" : attribute.type())).add("defaultValue", (Object)attribute.defaultValue());
    }

    private FrameBuilder process(Data.LongInteger attribute) {
        return new FrameBuilder(new String[]{"primitive", this.multiple(attribute) ? "multiple" : "single", attribute.type()}).add("name", (Object)((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()).add("type", (Object)attribute.type()).add("defaultValue", (Object)(attribute.defaultValue() + "L"));
    }

    private FrameBuilder process(Data.File attribute) {
        return new FrameBuilder(new String[]{"primitive", this.multiple(attribute) ? "multiple" : "single", attribute.type()}).add("name", (Object)((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()).add("type", (Object)attribute.type());
    }

    private FrameBuilder process(Data.Bool attribute) {
        return new FrameBuilder(new String[]{"primitive", this.multiple(attribute) ? "multiple" : "single", attribute.type()}).add("name", (Object)((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()).add("type", (Object)attribute.type()).add("defaultValue", (Object)attribute.defaultValue());
    }

    private FrameBuilder process(Data.Text attribute) {
        FrameBuilder builder = new FrameBuilder(new String[]{this.multiple(attribute) ? "multiple" : "single", attribute.type()}).add("name", (Object)((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()).add("type", (Object)attribute.type());
        if (attribute.defaultValue() != null) {
            builder.add("defaultValue", (Object)("\"" + attribute.defaultValue() + "\""));
        }
        return builder;
    }

    private FrameBuilder process(Data.DateTime attribute) {
        return new FrameBuilder(new String[]{"primitive", this.multiple(attribute) ? "multiple" : "single", attribute.type()}).add("name", (Object)((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()).add("type", (Object)attribute.type());
    }

    private FrameBuilder process(Data.Date attribute) {
        return new FrameBuilder(new String[]{"primitive", this.multiple(attribute) ? "multiple" : "single", attribute.type()}).add("name", (Object)((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()).add("type", (Object)attribute.type());
    }

    private FrameBuilder process(Data.Word attribute) {
        Schema.Attribute a = (Schema.Attribute)attribute.a$(Schema.Attribute.class);
        return new FrameBuilder(new String[]{"word", this.multiple(attribute) ? "multiple" : "single", attribute.type()}).add("name", (Object)a.name$()).add("words", (Object)attribute.values().toArray(new String[0])).add("type", (Object)a.name$());
    }

    private FrameBuilder process(Data.Map attribute) {
        return new FrameBuilder(new String[]{"map", attribute.value().isList() ? "valueList" : "valueSingle", attribute.key().isList() ? "keyList" : "keySingle"}).add("name", (Object)((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()).add("key", (Object)new FrameBuilder(new String[]{attribute.key().isList() ? "list" : "single"}).add("type", (Object)attribute.key().asType().type())).add("value", (Object)new FrameBuilder(new String[]{attribute.value().isList() ? "list" : "single"}).add("type", (Object)attribute.value().asType().type()));
    }

    private FrameBuilder processObjectAttribute(Schema schema, String name, boolean multiple) {
        return new FrameBuilder(new String[]{multiple ? "multiple" : "single", "object", schema.name$()}).add("name", (Object)name).add("type", (Object)schema.name$()).add("package", (Object)this.packageOf(schema));
    }

    private FrameBuilder processSchema(Schema schema, String name, boolean multiple) {
        return new FrameBuilder(new String[]{multiple ? "multiple" : "single", "schema", schema.name$()}).add("name", (Object)name).add("type", (Object)schema.name$()).add("package", (Object)this.packageOf(schema));
    }

    private String packageOf(Schema schema) {
        Service service = (Service)schema.core$().ownerAs(Service.class);
        String rootPackage = this.packageName;
        String subPackage = "schemas" + (String)(service != null ? File.separator + service.name$().toLowerCase() : "");
        return subPackage.isEmpty() ? rootPackage : rootPackage + "." + subPackage.replace(File.separator, ".");
    }

    private boolean multiple(Data.Type attribute) {
        return attribute.asData().isList();
    }

    private Template template() {
        return Formatters.customize(new SchemaTemplate()).add("typeFormat", value -> {
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        });
    }
}

