/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datahub;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.datahub.DatalakeTemplate;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Datalake;
import io.intino.konos.model.KonosGraph;
import java.io.File;

public class DatalakeRenderer
extends Renderer {
    private final CompilationContext context;
    private final KonosGraph graph;
    private final File genDirectory;

    public DatalakeRenderer(CompilationContext context, KonosGraph graph) {
        super(context, Target.Owner);
        this.graph = graph;
        this.context = context;
        this.genDirectory = context.gen(Target.Owner);
    }

    @Override
    protected void render() throws KonosException {
        Datalake datalake = this.graph.datalake();
        if (datalake == null || !datalake.isNfsMirrored() && !datalake.isSshMirrored()) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"datalake", datalake.isNfsMirrored() ? "nfs" : "ssh"}).add("package", (Object)this.context.packageName());
        this.context.classes().put("Datalake", "Datalake");
        File destination = this.genDirectory;
        if (!Commons.javaFile(destination, "Datalake").exists()) {
            Commons.writeFrame(destination, "Datalake", Formatters.customize(new DatalakeTemplate()).render((Object)builder.toFrame()));
            this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(datalake), Commons.javaFile(destination, "Datalake").getAbsolutePath()));
        }
    }
}

