/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.jmx;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.accessor.jmx.JMXAccessorTemplate;
import io.intino.konos.builder.codegeneration.schema.SchemaListRenderer;
import io.intino.konos.builder.codegeneration.services.jmx.JMXServerTemplate;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Data;
import io.intino.konos.model.Parameter;
import io.intino.konos.model.Service;
import java.io.File;
import java.util.List;

public class JMXAccessorRenderer
extends Renderer {
    private final Service.JMX service;
    private final File destination;
    private final String packageName;

    public JMXAccessorRenderer(CompilationContext compilationContext, Service.JMX restService, File destination) {
        super(compilationContext, Target.Owner);
        this.service = restService;
        this.destination = destination;
        this.destination.mkdirs();
        this.packageName = compilationContext.packageName() + ".box";
    }

    @Override
    public void render() throws KonosException {
        new SchemaListRenderer(this.context, this.service.graph(), this.destination, this.packageName).execute();
        this.createInterface(this.service);
        this.createService(this.service);
    }

    private void createInterface(Service.JMX service) {
        FrameBuilder frame = new FrameBuilder(new String[]{"jmx", "interface"});
        this.fillFrame(service, frame);
        Commons.writeFrame(this.destinationPackage(), service.name$() + "MBean", this.interfaceTemplate().render((Object)frame));
    }

    private File destinationPackage() {
        return new File(this.destination, "jmx");
    }

    private void createService(Service.JMX service) {
        FrameBuilder builder = new FrameBuilder(new String[]{"accessor"});
        this.fillFrame(service, builder);
        Commons.writeFrame(this.destination, StringHelper.snakeCaseToCamelCase((String)service.name$()) + "JMXAccessor", this.template().render((Object)builder.toFrame()));
    }

    private void fillFrame(Service.JMX service, FrameBuilder builder) {
        builder.add("name", (Object)service.name$());
        builder.add("package", (Object)this.packageName);
        if (!service.graph().schemaList().isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName));
        }
        for (Service.JMX.Operation operation : service.operationList()) {
            builder.add("operation", (Object)this.frameOf(operation));
        }
    }

    private Frame frameOf(Service.JMX.Operation operation) {
        FrameBuilder builder = new FrameBuilder(new String[]{"operation"}).add("name", (Object)operation.name$()).add("action", (Object)operation.name$()).add("package", (Object)this.packageName).add("returnType", (Object)(operation.response() == null ? "void" : this.formatType(operation.response().asType())));
        this.setupParameters(operation.parameterList(), builder);
        return builder.toFrame();
    }

    private String formatType(Data.Type typeData) {
        return (String)(typeData.i$(Data.Object.class) ? this.packageName + ".schemas." : "") + typeData.type();
    }

    private void setupParameters(List<Parameter> parameters, FrameBuilder builder) {
        for (Parameter parameter : parameters) {
            builder.add("parameter", (Object)new FrameBuilder(new String[]{"parameter"}).add("name", (Object)parameter.name$()).add("type", (Object)this.formatType(parameter.asType())).toFrame());
        }
    }

    private Template template() {
        return Formatters.customize(new JMXAccessorTemplate());
    }

    private Template interfaceTemplate() {
        return Formatters.customize(new JMXServerTemplate());
    }
}

