/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.analytic;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.analytic.AxisInterfaceRenderer;
import io.intino.konos.builder.codegeneration.analytic.CategoricalAxisRenderer;
import io.intino.konos.builder.codegeneration.analytic.ContinuousAxisRenderer;
import io.intino.konos.builder.codegeneration.analytic.CubeRenderer;
import io.intino.konos.builder.codegeneration.facts.FactRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.model.Axis;
import io.intino.konos.model.Cube;
import io.intino.konos.model.KonosGraph;
import java.io.File;
import java.util.List;

public class AnalyticRenderer
extends Renderer {
    private final File src;
    private final File gen;
    private final KonosGraph graph;
    private final FactRenderer factRenderer;
    private final CategoricalAxisRenderer categoricalAxisRenderer;
    private final ContinuousAxisRenderer continuousAxisRenderer;
    private final CubeRenderer cubeRenderer;

    public AnalyticRenderer(CompilationContext context, KonosGraph graph) {
        super(context, Target.Owner);
        this.src = new File(context.src(Target.Owner), "analytic");
        this.gen = new File(context.gen(Target.Owner), "analytic");
        File res = context.res(Target.Owner).getAbsoluteFile();
        this.graph = graph;
        this.factRenderer = new FactRenderer();
        this.categoricalAxisRenderer = new CategoricalAxisRenderer(context, this.gen, res);
        this.continuousAxisRenderer = new ContinuousAxisRenderer(context, this.gen);
        this.cubeRenderer = new CubeRenderer(this.src, this.gen, context, this.factRenderer);
    }

    @Override
    protected void render() {
        this.renderAxes(this.graph.axisList());
        this.renderCubes(this.graph.cubeList());
    }

    private void renderAxes(List<Axis> axes) {
        if (axes.isEmpty()) {
            return;
        }
        axes.stream().filter(Axis::isCategorical).map(Axis::asCategorical).forEach(this.categoricalAxisRenderer::render);
        axes.stream().filter(Axis::isContinuous).map(Axis::asContinuous).forEach(this.continuousAxisRenderer::render);
        AxisInterfaceRenderer.render(this.gen, this.context, axes);
    }

    private void renderCubes(List<Cube> cubeList) {
        for (Cube cube : cubeList) {
            FrameBuilder fb = new FrameBuilder(new String[]{"cube"}).add("package", (Object)this.context.packageName()).add("name", (Object)cube.name$());
            this.cubeRenderer.render(cube, fb);
        }
    }
}

