/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.action;

import cottons.utils.StringHelper;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.action.ActionTemplate;
import io.intino.konos.builder.codegeneration.action.ActionUpdater;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Data;
import io.intino.konos.model.Exception;
import io.intino.konos.model.Parameter;
import io.intino.konos.model.Response;
import io.intino.konos.model.Schema;
import io.intino.magritte.framework.Layer;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class ActionRenderer
extends Renderer {
    private final String[] types;

    public ActionRenderer(CompilationContext context, String ... types) {
        super(context, Target.Owner);
        this.types = types;
    }

    protected ContextType contextType() {
        return ContextType.Default;
    }

    protected boolean alreadyRendered(File destiny, String action) {
        return Commons.javaFile(this.destinationPackage(destiny), this.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)action)) + this.suffix()).exists();
    }

    protected File destinationPackage(File destiny) {
        return new File(destiny, "actions");
    }

    protected void execute(String name, String serviceName, Response response, Map<String, ? extends Parameter> parameters, List<Exception> exceptions, List<Schema> schemas) {
        File destiny = this.destination();
        if (!this.alreadyRendered(destiny, name)) {
            this.createNewClass(name, serviceName, response, parameters, exceptions, schemas);
        } else {
            File newDestination = Commons.javaFile(this.destinationPackage(destiny), this.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)name)) + this.suffix());
            new ActionUpdater(this.context, newDestination, this.packageName(), parameters, exceptions, response).update();
        }
    }

    protected void execute(String name, String serviceName, Response response, List<? extends Parameter> parameters, List<Exception> exceptions, List<Schema> schemas) {
        File destiny = this.destination();
        if (!this.alreadyRendered(destiny, name)) {
            this.createNewClass(name, serviceName, response, this.toMap(parameters), exceptions, schemas);
        } else {
            File newDestination = Commons.javaFile(this.destinationPackage(destiny), this.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)name)) + this.suffix());
            new ActionUpdater(this.context, newDestination, this.packageName(), this.toMap(parameters), exceptions, response).update();
        }
    }

    private Map<String, ? extends Parameter> toMap(List<? extends Parameter> parameters) {
        return parameters.stream().collect(Collectors.toMap(Layer::name$, p -> p));
    }

    protected String suffix() {
        return "Action";
    }

    private void createNewClass(String name, String serviceName, Response response, Map<String, ? extends Parameter> parameters, List<Exception> exceptions, List<Schema> schemas) {
        String packageName = this.packageName();
        FrameBuilder builder = new FrameBuilder(new String[]{"action"}).add("name", (Object)name).add("service", (Object)serviceName).add("package", (Object)packageName).add("box", (Object)this.boxName()).add("returnType", (Object)Commons.returnType(response, packageName));
        Arrays.stream(this.types).forEach(arg_0 -> ((FrameBuilder)builder).add(arg_0));
        builder.add("contextProperty", (Object)this.contextPropertyFrame());
        this.setupParameters(parameters, builder);
        if (!exceptions.isEmpty()) {
            builder.add("throws", exceptions.stream().map(e -> e.code().name()).toArray(String[]::new));
        }
        if (!schemas.isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)packageName).toFrame());
        }
        File packageFolder = this.destinationPackage(this.destination());
        this.context.compiledFiles().add(new OutputItem(packageFolder.getAbsolutePath(), Commons.javaFile(packageFolder, this.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)name)) + this.suffix()).getAbsolutePath()));
        Commons.writeFrame(packageFolder, this.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)name)) + this.suffix(), this.template().render((Object)builder.toFrame()));
    }

    protected FrameBuilder contextPropertyFrame() {
        FrameBuilder result = new FrameBuilder(new String[]{"contextProperty"});
        if (this.contextType() == ContextType.Spark) {
            result.add("spark");
        }
        return result;
    }

    private void setupParameters(Map<String, ? extends Parameter> parameters, FrameBuilder builder) {
        for (Map.Entry<String, ? extends Parameter> parameter : parameters.entrySet()) {
            FrameBuilder parameterBuilder = new FrameBuilder(new String[]{"parameter", ((Object)((Object)parameter.getValue().asType())).getClass().getSimpleName()});
            if (parameter.getValue().isList()) {
                parameterBuilder.add("list");
            }
            builder.add("parameter", (Object)parameterBuilder.add("name", Formatters.snakeCaseToCamelCase().format((Object)parameter.getKey())).add("type", (Object)this.formatType(parameter.getValue().asType())).toFrame());
        }
    }

    private String formatType(Data.Type typeData) {
        return (String)(typeData.i$(Data.Object.class) ? this.packageName() + ".schemas." : "") + typeData.type();
    }

    protected String firstUpperCase(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    protected Template template() {
        return Formatters.customize(new ActionTemplate());
    }

    private File destination() {
        return this.src();
    }

    public static enum ContextType {
        Default,
        Spark;

    }
}

