/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui.templates;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class AppTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.type("app"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("__webpack_public_path__ = loadAppUrl();\n\nimport React from \"react\";\nimport ReactDOM from \"react-dom\";\n")}).output(new Rule.Output[]{this.mark("page", new String[]{"import"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\nimport PushService from \"alexandria-ui-elements/src/services/PushService\";\nimport FileService from \"alexandria-ui-elements/src/services/FileService\";\nimport TranslatorService from \"alexandria-ui-elements/src/services/TranslatorService\";\nimport GoogleApiLoader from \"alexandria-ui-elements/src/displays/components/geo/GoogleApiLoader\";\nimport DisplayRouter from \"alexandria-ui-elements/src/displays/DisplayRouter\";\n\nvar launchApplication = function () {\n\tvar configuration = loadConfiguration();\n\n\twindow.Application = (function(configuration) {\n\t\tvar self = {};\n\n\t\tself.configuration = configuration;\n\t\tself.configuration.appUrls = loadUrls(configuration.baseUrls);\n\t\tself.configuration.appUrl = (app) => {\n\t\t\treturn self.configuration.appUrls[app] != null ? self.configuration.appUrls[app] : self.configuration.baseUrl;\n\t\t};\n\t\tself.services = {\n\t\t\tpushService: PushService,\n\t\t\tfileService: FileService.create(configuration),\n\t\t\ttranslatorService: TranslatorService.create(configuration)\n\t\t};\n\n\t\treturn self;\n\t})(configuration);\n\n\trenderApplication();\n\n\tfunction loadConfiguration() {\n\t\treturn document.configuration;\n\t}\n\n\tfunction loadUrls(urlList) {\n\t\tlet result = {};\n\t\tif (urlList == null) return result;\n\t\tfor (let i=0; i<urlList.length; i++) {\n\t\t\tconst urlInfo = urlList[i].split(\"_##_\");\n\t\t\tresult[urlInfo[0]] = urlInfo[1];\n\t\t}\n\t\treturn result;\n\t}\n\n\tfunction renderApplication() {\n\t\t")}).output(new Rule.Output[]{this.mark("page", new String[]{"render"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\t}\n\n\tfunction openPushService() {\n\t\twindow.setTimeout(() => {\n\t\t\tconst pushConnections = Application.configuration.pushConnections;\n\t\t\tfor (let i=0; i<pushConnections.length; i++) {\n\t\t\t\tconst connection = pushConnections[i].split(\"_##_\");\n\t\t\t\tif (connection[0].toLowerCase() !== \"default\") continue;\n\t\t\t\tPushService.openConnection(connection[0], connection[1]);\n\t\t\t}\n\t\t}, 100);\n\t}\n\n};\n\nfunction loadAppUrl() {\n\tlet url = window.location.pathname !== \"/\" ? window.location.pathname : \"\";\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("pattern", new String[0]).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\tif (url.lastIndexOf(\"/\") > 0) url = url.substr(0, window.location.pathname.lastIndexOf('/'));\n\tif (url === \"/\") url = \"\";\n\treturn url + \"/")}).output(new Rule.Output[]{this.mark("webModuleName", new String[0])}).output(new Rule.Output[]{this.literal("/\";\n}\n\nlaunchApplication();")}), this.rule().condition(this.type("pattern"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("url = url.replace(new RegExp(\"")}).output(new Rule.Output[]{this.mark("value", new String[0])}).output(new Rule.Output[]{this.literal("\", 'g'), \"\");")}), this.rule().condition(this.type("page"), new Rule.Condition[]{this.trigger("import")}).output(new Rule.Output[]{this.literal("import ")}).output(new Rule.Output[]{this.mark("templateName", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Page from \"../pages/")}).output(new Rule.Output[]{this.mark("templateName", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Page\";")}), this.rule().condition(this.type("page"), new Rule.Condition[]{this.trigger("render")}).output(new Rule.Output[]{this.literal("const requireGoogleApi = Application.configuration.googleApiKey != null && Application.configuration.googleApiKey !== \"\";\nconst content = requireGoogleApi ? <GoogleApiLoader onLoad={openPushService()}><")}).output(new Rule.Output[]{this.mark("templateName", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Page/></GoogleApiLoader> : <")}).output(new Rule.Output[]{this.mark("templateName", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Page/>;\nconst ")}).output(new Rule.Output[]{this.mark("templateName", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" = document.getElementById(\"")}).output(new Rule.Output[]{this.mark("templateName", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("\");\nif (")}).output(new Rule.Output[]{this.mark("templateName", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(") ReactDOM.render(<DisplayRouter id=\"__router__\" owner={()=>\"\"} context={()=>\"\"}>{content}</DisplayRouter>, ")}).output(new Rule.Output[]{this.mark("templateName", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(");\nif (!requireGoogleApi) openPushService();")})});
    }
}

