/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.rest;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.accessor.rest.RESTAccessorTemplate;
import io.intino.konos.builder.codegeneration.schema.SchemaListRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Exception;
import io.intino.konos.model.Response;
import io.intino.konos.model.Service;
import io.intino.konos.model.rules.ExceptionCodes;
import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Predicate;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RESTAccessorRenderer
extends Renderer {
    private final Service.REST service;
    private final File destination;
    private final Map<String, List<Service.REST.Resource.Parameter>> enumParameters;

    public RESTAccessorRenderer(CompilationContext compilationContext, Service.REST restService, File destination) {
        super(compilationContext, Target.Owner);
        this.service = restService;
        this.destination = destination;
        this.destination.mkdirs();
        this.enumParameters = new HashMap<String, List<Service.REST.Resource.Parameter>>();
    }

    @Override
    public void render() throws KonosException {
        new SchemaListRenderer(this.context, this.service.graph(), this.destination, true).execute();
        this.processService(this.service);
    }

    private void processService(Service.REST service) {
        FrameBuilder builder = new FrameBuilder(new String[]{"accessor"});
        builder.add("name", (Object)service.name$());
        builder.add("package", (Object)this.packageName());
        this.setupAuthentication(service, builder);
        if (!service.graph().schemaList().isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName()));
        }
        builder.add("resource", service.core$().findNode(Service.REST.Resource.class).stream().map(this::framesOf).flatMap(Collection::stream).toArray(Frame[]::new));
        builder.add("notification", service.notificationList().stream().map(this::frameOf).toArray(Frame[]::new));
        for (Service.REST.Resource.Parameter enumParameter : this.enumParameters.values().stream().flatMap(Collection::stream).collect(Collectors.toList())) {
            builder.add("enumParameter", (Object)new FrameBuilder(new String[]{"enumParameter"}).add("name", (Object)enumParameter.name$()).add("class", (Object)(((Service.REST.Resource)enumParameter.core$().ownerAs(Service.REST.Resource.class)).name$() + Commons.firstUpperCase(enumParameter.name$()))).add("value", enumParameter.asWord().values().toArray(String[]::new)));
        }
        Commons.writeFrame(this.destination, StringHelper.snakeCaseToCamelCase((String)service.name$()) + "Accessor", this.template().render((Object)builder));
    }

    private void setupAuthentication(Service.REST restService, FrameBuilder builder) {
        if (restService.authentication() != null) {
            builder.add("authentication", (Object)new FrameBuilder(new String[]{"authentication", this.authentication()}));
        }
    }

    private String authentication() {
        return this.service.authentication().core$().conceptList().stream().filter(Concept::isAspect).map(Predicate::name).findFirst().orElse(null);
    }

    private List<Frame> framesOf(Service.REST.Resource resource) {
        return resource.operationList().stream().map(operation -> this.processOperation((Service.REST.Resource.Operation)((Object)operation), this.service.authentication())).collect(Collectors.toList());
    }

    private Frame frameOf(Service.REST.Notification notification) {
        FrameBuilder builder = new FrameBuilder(new String[]{"notification"}).add("path", (Object)notification.path()).add("name", (Object)notification.name$());
        if (this.service.authentication() != null) {
            builder.add("auth", (Object)new FrameBuilder(new String[]{"authentication", this.authentication()}));
        }
        builder.add("parameter", (Object)this.notificationParameters(notification.parameterList()));
        return builder.toFrame();
    }

    private Frame processOperation(Service.REST.Resource.Operation operation, Service.REST.Authentication authentication) {
        FrameBuilder builder = new FrameBuilder(new String[]{"resource"}).add("path", (Object)this.processPath(Commons.path((Service.REST.Resource)operation.core$().ownerAs(Service.REST.Resource.class)))).add("response", (Object)new FrameBuilder(this.responseType(operation.response())).add("value", (Object)this.customizeMultipart(operation.response(), Commons.returnType(operation.response(), this.packageName())))).add("method", (Object)((Object)((Object)operation)).getClass().getSimpleName()).add("name", (Object)operation.core$().owner().name()).add("parameter", (Object)this.parameters(((Service.REST.Resource)operation.core$().ownerAs(Service.REST.Resource.class)).parameterList())).add("parameter", (Object)this.parameters(operation.parameterList())).add("exceptionResponses", (Object)this.exceptionResponses(operation, authentication));
        if (authentication != null) {
            builder.add("auth", (Object)new FrameBuilder(new String[]{"authentication", this.authentication()}));
        }
        return builder.toFrame();
    }

    private String customizeMultipart(Response response, String returnType) {
        return response != null && response.isMultiPart() ? returnType.replace(".rest.", ".restaccessor.") : returnType;
    }

    private String[] responseType(Response response) {
        ArrayList<String> types = new ArrayList<String>(List.of(response != null && response.isType() ? response.asType().type() : "void"));
        if (response != null) {
            types.addAll(response.core$().layerList().stream().map(l -> l.contains("$") ? l.substring(l.indexOf("$") + 1) : l).collect(Collectors.toList()));
        }
        return types.toArray(new String[0]);
    }

    private Frame[] parameters(List<Service.REST.Resource.Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame[] notificationParameters(List<Service.REST.Notification.Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame parameter(Service.REST.Resource.Parameter parameter) {
        return new FrameBuilder(new String[]{"parameter", parameter.isList() ? "list" : "single", parameter.in().toString(), parameter.isRequired() ? "required" : "optional", ((Object)((Object)parameter.asType())).getClass().getSimpleName()}).add("name", (Object)parameter.name$()).add("parameterType", (Object)this.parameterType(parameter)).toFrame();
    }

    private Frame parameter(Service.REST.Notification.Parameter parameter) {
        return new FrameBuilder(new String[]{"parameter", parameter.isList() ? "list" : "single", parameter.in().toString(), parameter.isRequired() ? "required" : "optional", ((Object)((Object)parameter.asType())).getClass().getSimpleName()}).add("name", (Object)parameter.name$()).add("parameterType", (Object)this.parameterType(parameter)).toFrame();
    }

    private String parameterType(Service.REST.Resource.Parameter parameter) {
        Object type;
        if (parameter.isWord()) {
            String resource = ((Service.REST.Resource)parameter.core$().ownerAs(Service.REST.Resource.class)).name$();
            this.enumParameters.putIfAbsent(resource, new ArrayList());
            List<Service.REST.Resource.Parameter> parameters = this.enumParameters.get(resource);
            if (parameters.stream().noneMatch(p -> p.name$().equals(parameter.name$()))) {
                this.enumParameters.get(resource).add(parameter);
            }
            type = Commons.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)resource) + Commons.firstUpperCase(parameter.name$()));
        } else {
            type = (parameter.isObject() && parameter.asObject().isComponent() != false ? String.join((CharSequence)".", this.packageName(), "schemas.") : "") + parameter.asType().type();
        }
        return parameter.isList() ? "List<" + (String)type + ">" : type;
    }

    private String parameterType(Service.REST.Notification.Parameter parameter) {
        String type = (parameter.isObject() && parameter.asObject().isComponent() != false ? String.join((CharSequence)".", this.packageName(), "schemas.") : "") + parameter.asType().type();
        return parameter.isList() ? "List<" + type + ">" : type;
    }

    private String processPath(String path) {
        StringBuilder builder = new StringBuilder();
        for (String pathPortion : path.split("/")) {
            if (pathPortion.startsWith(":")) {
                builder.append(" + \"/\" + ").append(this.asMethodParameter(pathPortion.substring(1)));
                continue;
            }
            builder.append(" + \"/").append(pathPortion).append("\"");
        }
        return builder.toString().substring(3);
    }

    private String asMethodParameter(String parameter) {
        String toCamelCase = StringHelper.snakeCaseToCamelCase((String)parameter);
        return Character.toLowerCase(toCamelCase.charAt(0)) + toCamelCase.substring(1);
    }

    private FrameBuilder exceptionResponses(Service.REST.Resource.Operation operation, Service.REST.Authentication authentication) {
        List<Exception> exceptions = operation.exceptionList();
        if (exceptions.isEmpty()) {
            if (authentication == null) {
                return new FrameBuilder(new String[]{"exceptionResponses", "none"});
            }
            return new FrameBuilder(new String[]{"exceptionResponses"}).add("exceptionResponse", (Object)this.unauthorizedExceptionResponse());
        }
        return new FrameBuilder(new String[]{"exceptionResponses"}).add("exceptionResponse", (Object)this.exceptionResponses(exceptions, authentication));
    }

    private Frame[] exceptionResponses(List<Exception> exceptions, Service.REST.Authentication authentication) {
        List<Frame> collect = exceptions.stream().map(this::exceptionResponse).collect(Collectors.toList());
        if (authentication != null && exceptions.stream().noneMatch(e -> e.code().equals((Object)ExceptionCodes.Unauthorized))) {
            collect.add(this.unauthorizedExceptionResponse());
        }
        return collect.toArray(new Frame[0]);
    }

    private Frame exceptionResponse(Exception exception) {
        return new FrameBuilder(new String[]{"exceptionResponse"}).add("code", (Object)exception.code().value()).add("exceptionName", (Object)exception.code().toString()).toFrame();
    }

    private Frame unauthorizedExceptionResponse() {
        return new FrameBuilder(new String[]{"exceptionResponse"}).add("code", (Object)ExceptionCodes.Unauthorized.value()).add("exceptionName", (Object)ExceptionCodes.Unauthorized.name()).toFrame();
    }

    private Template template() {
        return Formatters.customize(new RESTAccessorTemplate());
    }

    public static String firstLowerCase(String value) {
        return value.substring(0, 1).toLowerCase() + value.substring(1);
    }
}

