/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.action;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.compiler.shared.PostCompileActionMessage;
import io.intino.konos.compiler.shared.PostCompileFieldActionMessage;
import io.intino.konos.compiler.shared.PostCompileMethodActionMessage;
import io.intino.konos.model.Data;
import io.intino.konos.model.Exception;
import io.intino.konos.model.Parameter;
import io.intino.konos.model.Response;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ActionUpdater {
    private final CompilationContext context;
    private final File destination;
    private final String packageName;
    private final Map<String, ? extends Parameter> parameters;
    private final List<Exception> exceptions;
    private final Response response;

    public ActionUpdater(CompilationContext context, File destination, String packageName, Map<String, ? extends Parameter> parameters, List<Exception> exceptions, Response response) {
        this.context = context;
        this.destination = destination;
        this.packageName = packageName;
        this.parameters = parameters;
        this.exceptions = exceptions;
        this.response = response;
    }

    public void update() {
        String box = this.context.packageName() + "." + StringHelper.snakeCaseToCamelCase((String)this.context.boxName()) + "Box";
        this.parameters.forEach((key, value) -> this.context.postCompileActionMessages().add((PostCompileActionMessage)new PostCompileFieldActionMessage(this.context.module(), this.destination, "public", false, this.formatType(value.asType(), value.isList()), this.nameOf((String)key))));
        this.context.postCompileActionMessages().add((PostCompileActionMessage)new PostCompileFieldActionMessage(this.context.module(), this.destination, "public", false, box, "box"));
        this.context.postCompileActionMessages().add((PostCompileActionMessage)new PostCompileMethodActionMessage(this.context.module(), this.destination, "execute", false, Collections.emptyList(), this.response == null ? "void" : this.returnType(), this.exceptions()));
    }

    private String returnType() {
        String type = Commons.fullReturnType(this.response, this.packageName);
        return !type.contains(".") && !type.equals("void") ? "java.lang." + type : type;
    }

    private List<String> exceptions() {
        return this.exceptions.stream().map(e -> e.core$().owner().owner() == null ? this.exceptionReference((Exception)((Object)e)) : e.code().name()).collect(Collectors.toList());
    }

    private String exceptionReference(Exception exception) {
        return this.packageName + ".exceptions." + Commons.firstUpperCase(exception.name$());
    }

    private String nameOf(String parameter) {
        return Formatters.firstLowerCase(Formatters.snakeCaseToCamelCase().format((Object)parameter).toString());
    }

    private String formatType(Data.Type typeData, boolean list) {
        if (typeData == null || typeData.type() == null) {
            return "void";
        }
        String type = (String)(typeData.i$(Data.Object.class) ? this.packageName + ".schemas." : "") + typeData.type();
        return list ? "List<" + type + ">" : type;
    }
}

