/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.displays.components;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.ui.TemplateProvider;
import io.intino.konos.builder.codegeneration.ui.displays.components.ComponentRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.model.CatalogComponents;
import io.intino.konos.model.Display;
import io.intino.konos.model.OtherComponents;

public class SelectorRenderer
extends ComponentRenderer<OtherComponents.Selector> {
    public SelectorRenderer(CompilationContext compilationContext, OtherComponents.Selector component, TemplateProvider provider, Target target) {
        super(compilationContext, component, provider, target);
    }

    @Override
    protected void fill(FrameBuilder builder) {
        super.fill(builder);
        this.addBinding(builder);
        this.addAddressableMethod(builder);
    }

    @Override
    public FrameBuilder properties() {
        FrameBuilder result = super.properties();
        result.add("multipleSelection", (Object)(((OtherComponents.Selector)this.element).multipleSelection() ? "true" : "false"));
        if (((OtherComponents.Selector)this.element).isReadonly()) {
            result.add("readonly", (Object)((OtherComponents.Selector)this.element).isReadonly());
        }
        if (((OtherComponents.Selector)this.element).isFocused()) {
            result.add("readonly", (Object)((OtherComponents.Selector)this.element).isFocused());
        }
        this.addTabsProperties(result);
        this.addMenuProperties(result);
        this.addComboBoxProperties(result);
        this.addCollectionBoxProperties(result);
        this.addCheckBoxProperties(result);
        this.addRadioBoxProperties(result);
        this.addAddressableProperties(result);
        this.addToggleBoxProperties(result);
        return result;
    }

    private void addTabsProperties(FrameBuilder builder) {
        if (!((OtherComponents.Selector)this.element).isTabs()) {
            return;
        }
        OtherComponents.Selector.Tabs.ScrollButtons scrollButtons = ((OtherComponents.Selector)this.element).asTabs().scrollButtons();
        if (scrollButtons == OtherComponents.Selector.Tabs.ScrollButtons.Off) {
            return;
        }
        builder.add("scrollButtons", (Object)scrollButtons);
    }

    private void addMenuProperties(FrameBuilder builder) {
        if (!((OtherComponents.Selector)this.element).isMenu()) {
            return;
        }
        OtherComponents.Selector.Menu.Layout layout = ((OtherComponents.Selector)this.element).asMenu().layout();
        if (layout == null) {
            return;
        }
        builder.add("layout", (Object)layout.name());
    }

    private void addComboBoxProperties(FrameBuilder builder) {
        OtherComponents.Selector.ComboBox.View view;
        if (!((OtherComponents.Selector)this.element).isComboBox()) {
            return;
        }
        OtherComponents.Selector.ComboBox comboBox = ((OtherComponents.Selector)this.element).asComboBox();
        builder.add("maxMenuHeight", (Object)comboBox.maxMenuHeight());
        String placeholder = comboBox.placeholder();
        if (placeholder != null && !placeholder.isEmpty()) {
            builder.add("placeholder", (Object)placeholder);
        }
        if ((view = comboBox.view()) != null && view != OtherComponents.Selector.ComboBox.View.FieldView) {
            builder.add("view", (Object)view.name());
        }
    }

    private void addCollectionBoxProperties(FrameBuilder builder) {
        String placeholder;
        if (!((OtherComponents.Selector)this.element).isCollectionBox()) {
            return;
        }
        OtherComponents.Selector.CollectionBox collectionBox = ((OtherComponents.Selector)this.element).asCollectionBox();
        if (collectionBox.allowOther()) {
            builder.add("allowOther", (Object)true);
        }
        if ((placeholder = collectionBox.placeholder()) != null && !placeholder.isEmpty()) {
            builder.add("placeholder", (Object)placeholder);
        }
    }

    private void addCheckBoxProperties(FrameBuilder builder) {
        if (!((OtherComponents.Selector)this.element).isCheckBox()) {
            return;
        }
        builder.add("layout", (Object)((OtherComponents.Selector)this.element).asCheckBox().layout().name());
    }

    private void addRadioBoxProperties(FrameBuilder builder) {
        if (!((OtherComponents.Selector)this.element).isRadioBox()) {
            return;
        }
        String selected = ((OtherComponents.Selector)this.element).asRadioBox().selected();
        builder.add("layout", (Object)((OtherComponents.Selector)this.element).asRadioBox().layout().name());
        if (selected == null || selected.isEmpty()) {
            return;
        }
        builder.add("selected", (Object)selected);
    }

    private void addToggleBoxProperties(FrameBuilder builder) {
        if (!((OtherComponents.Selector)this.element).isToggleBox()) {
            return;
        }
        OtherComponents.Selector.ToggleBox toggleBox = ((OtherComponents.Selector)this.element).asToggleBox();
        String selected = toggleBox.selected();
        if (selected != null && !selected.isEmpty()) {
            builder.add("selected", (Object)selected);
        }
        OtherComponents.Selector.ToggleBox.Layout layout = toggleBox.layout();
        builder.add("layout", (Object)layout.name());
        builder.add("size", (Object)toggleBox.size().name());
    }

    private void addBinding(FrameBuilder builder) {
        this.addCollectionBoxBinding(builder);
    }

    private void addCollectionBoxBinding(FrameBuilder builder) {
        CatalogComponents.Collection collection;
        if (!((OtherComponents.Selector)this.element).isCollectionBox()) {
            return;
        }
        OtherComponents.Selector.CollectionBox collectionBox = ((OtherComponents.Selector)this.element).asCollectionBox();
        CatalogComponents.Collection collection2 = collection = collectionBox.source() != null ? collectionBox.source() : collectionBox.collection();
        if (collection == null) {
            return;
        }
        FrameBuilder binding = this.buildBaseFrame().add("binding").add("collectionbox");
        if (collectionBox.source() != null) {
            binding.add("add");
        }
        if (!this.belongsToAccessible((Display)this.element)) {
            binding.add("concreteBox", (Object)this.boxName());
        }
        binding.add("name", (Object)this.nameOf(this.element));
        binding.add("collection", (Object)this.nameOf(collection));
        builder.add("binding", (Object)binding);
    }

    private void addAddressableMethod(FrameBuilder builder) {
        if (!((OtherComponents.Selector)this.element).isAddressable()) {
            return;
        }
        builder.add("methods", (Object)this.addressedMethod());
    }

    private FrameBuilder addressedMethod() {
        FrameBuilder result = this.addOwner(this.buildBaseFrame()).add("method").add(OtherComponents.Selector.class.getSimpleName()).add("addressable");
        result.add("name", (Object)this.nameOf(this.element));
        return result;
    }

    private void addAddressableProperties(FrameBuilder builder) {
        if (!((OtherComponents.Selector)this.element).isAddressable()) {
            return;
        }
        OtherComponents.Selector.Addressable addressable = ((OtherComponents.Selector)this.element).asAddressable();
        builder.add("path", (Object)(addressable.addressableResource() != null ? addressable.addressableResource().path() : ""));
    }

    @Override
    protected String className(Class clazz) {
        return super.className(clazz).replace("selector", "");
    }
}

