/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model;

import io.intino.konos.model.KonosGraph;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.ResourceLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Workflow
extends Layer
implements Terminal {
    protected String directory;
    protected List<Process> processList = new ArrayList<Process>();

    public Workflow(Node node) {
        super(node);
    }

    public String directory() {
        return this.directory;
    }

    public Workflow directory(String value) {
        this.directory = value;
        return this;
    }

    public List<Process> processList() {
        return Collections.unmodifiableList(this.processList);
    }

    public Process process(int index) {
        return this.processList.get(index);
    }

    public List<Process> processList(Predicate<Process> predicate) {
        return this.processList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Process process(Predicate<Process> predicate) {
        return this.processList().stream().filter(predicate).findFirst().orElse(null);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Process>(this.processList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("directory", new ArrayList<String>(Collections.singletonList(this.directory)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Workflow$Process")) {
            this.processList.add((Process)node.as(Process.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Workflow$Process")) {
            this.processList.remove(node.as(Process.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("directory")) {
            this.directory = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("directory")) {
            this.directory = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Process
    extends Layer
    implements Terminal {
        protected URL bpmn;

        public Process(Node node) {
            super(node);
        }

        public URL bpmn() {
            return this.bpmn;
        }

        public Process bpmn(URL url, String destination) {
            this.bpmn = url == null ? null : this.graph().core$().save(url, destination, this.bpmn, this.core$());
            return this;
        }

        public Process bpmn(InputStream stream, String destination) {
            this.bpmn = stream == null ? null : this.graph().core$().save(stream, destination, this.bpmn, this.core$());
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("bpmn", new ArrayList<URL>(Collections.singletonList(this.bpmn)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("bpmn")) {
                this.bpmn = (URL)ResourceLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("bpmn")) {
                this.bpmn = (URL)values.get(0);
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public class Clear {
        public void process(Predicate<Process> filter) {
            new ArrayList<Process>(Workflow.this.processList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Process process() {
            Process newElement = (Process)Workflow.this.core$().graph().concept(Process.class).createNode(this.name, Workflow.this.core$()).as(Process.class);
            return newElement;
        }
    }
}

