/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datahub.adapter;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.datahub.adapter.AdapterTemplate;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Adapter;
import io.intino.konos.model.KonosGraph;
import java.io.File;
import java.util.List;

public class AdapterRenderer {
    private final CompilationContext context;
    private final List<Adapter> adapters;

    public AdapterRenderer(CompilationContext context, KonosGraph graph) {
        this.context = context;
        this.adapters = graph.adapterList();
    }

    public void execute() {
        for (Adapter adapter : this.adapters) {
            FrameBuilder builder = new FrameBuilder(new String[]{"adapter"}).add("box", (Object)this.context.boxName()).add("package", (Object)this.context.packageName()).add("name", (Object)adapter.name$());
            File directory = new File(this.context.src(Target.Owner), "adapters");
            String adapterName = adapter.name$();
            this.context.classes().put(((Object)((Object)adapter)).getClass().getSimpleName() + "#" + adapter.name$(), "adapters." + adapterName);
            if (this.alreadyRendered(directory, adapterName)) continue;
            Commons.writeFrame(directory, adapterName, Formatters.customize(new AdapterTemplate()).render((Object)builder.toFrame()));
            this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(adapter), Commons.javaFile(directory, adapterName).getAbsolutePath()));
        }
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }
}

