/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import io.intino.konos.builder.codegeneration.AbstractBoxRenderer;
import io.intino.konos.builder.codegeneration.BoxConfigurationRenderer;
import io.intino.konos.builder.codegeneration.BoxRenderer;
import io.intino.konos.builder.codegeneration.accessor.PomGenerator;
import io.intino.konos.builder.codegeneration.accessor.analytic.AnalyticBuilderRenderer;
import io.intino.konos.builder.codegeneration.accessor.messaging.MessagingAccessorRenderer;
import io.intino.konos.builder.codegeneration.accessor.rest.RESTAccessorRenderer;
import io.intino.konos.builder.codegeneration.accessor.ui.ServiceListRenderer;
import io.intino.konos.builder.codegeneration.analytic.AnalyticRenderer;
import io.intino.konos.builder.codegeneration.bpm.BpmRenderer;
import io.intino.konos.builder.codegeneration.datahub.DatalakeRenderer;
import io.intino.konos.builder.codegeneration.datahub.adapter.AdapterRenderer;
import io.intino.konos.builder.codegeneration.datahub.messagehub.MessageHubRenderer;
import io.intino.konos.builder.codegeneration.datahub.mounter.MounterFactoryRenderer;
import io.intino.konos.builder.codegeneration.datahub.mounter.MounterRenderer;
import io.intino.konos.builder.codegeneration.datahub.subscriber.SubscriberRenderer;
import io.intino.konos.builder.codegeneration.exception.ExceptionRenderer;
import io.intino.konos.builder.codegeneration.feeder.FeederRenderer;
import io.intino.konos.builder.codegeneration.main.MainRenderer;
import io.intino.konos.builder.codegeneration.schema.SchemaListRenderer;
import io.intino.konos.builder.codegeneration.sentinel.ListenerRenderer;
import io.intino.konos.builder.codegeneration.sentinel.SentinelsRenderer;
import io.intino.konos.builder.codegeneration.services.agenda.AgendaServiceRenderer;
import io.intino.konos.builder.codegeneration.services.jmx.JMXOperationsServiceRenderer;
import io.intino.konos.builder.codegeneration.services.jmx.JMXServerRenderer;
import io.intino.konos.builder.codegeneration.services.messaging.MessagingRequestRenderer;
import io.intino.konos.builder.codegeneration.services.messaging.MessagingServiceRenderer;
import io.intino.konos.builder.codegeneration.services.rest.RESTResourceRenderer;
import io.intino.konos.builder.codegeneration.services.rest.RESTServiceRenderer;
import io.intino.konos.builder.codegeneration.services.slack.SlackRenderer;
import io.intino.konos.builder.codegeneration.services.soap.SoapOperationRenderer;
import io.intino.konos.builder.codegeneration.services.soap.SoapServiceRenderer;
import io.intino.konos.builder.codegeneration.ui.displays.components.ComponentRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.compiler.shared.KonosBuildConstants;
import io.intino.konos.model.KonosGraph;
import io.intino.konos.model.Service;
import java.io.File;

public class FullRenderer {
    private final KonosGraph graph;
    private final CompilationContext context;
    private final boolean hasModel;

    public FullRenderer(KonosGraph graph, CompilationContext context) {
        this.graph = graph;
        this.context = context;
        this.hasModel = this.hasModel();
    }

    public void execute() throws KonosException {
        this.render();
    }

    private void render() throws KonosException {
        if (this.context.mode().equals((Object)KonosBuildConstants.Mode.Normal)) {
            this.agendas();
            this.schemas();
            this.exceptions();
            this.rest();
            this.soap();
            this.tasks();
            this.jmx();
            this.jms();
            this.datalake();
            this.messageHub();
            this.subscribers();
            this.mounters();
            this.adapters();
            this.feeders();
            this.processes();
            this.analytic();
            this.slack();
            this.box();
            this.main();
            this.ui();
            this.context.saveCache();
        } else if (this.context.mode().equals((Object)KonosBuildConstants.Mode.OnlyElements)) {
            this.ui();
        } else {
            this.accessors();
        }
    }

    private void analytic() throws KonosException {
        new AnalyticRenderer(this.context, this.graph).execute();
    }

    private void accessors() throws KonosException {
        File dir;
        PomGenerator pomGenerator = new PomGenerator(this.context);
        for (Service.REST rest : this.graph.restServiceList()) {
            dir = this.genDirectory(this.context.configuration().genDirectory(), "rest#", rest.name$());
            new RESTAccessorRenderer(this.context, rest, dir).render();
            pomGenerator.generate("rest", dir);
        }
        for (Service.Messaging service : this.graph.messagingServiceList()) {
            dir = this.genDirectory(this.context.configuration().genDirectory(), "messaging#", service.name$());
            new MessagingAccessorRenderer(this.context, service, dir).render();
            pomGenerator.generate("messaging", dir);
        }
        if (!this.graph.cubeList().isEmpty()) {
            File dir2 = this.analyticBasePath();
            new AnalyticBuilderRenderer(this.context, this.graph, new File(dir2, "src"), new File(this.analyticBasePath(), "res")).render();
            pomGenerator.generate("analytic", dir2);
        }
    }

    private File analyticBasePath() {
        return new File(this.context.configuration().genDirectory(), "analytic#analytic");
    }

    private File genDirectory(File tempDirectory, String serviceType, String serviceName) {
        return new File(tempDirectory, serviceType + serviceName + File.separator + "src");
    }

    private void schemas() throws KonosException {
        new SchemaListRenderer(this.context, this.graph).execute();
    }

    private void exceptions() throws KonosException {
        new ExceptionRenderer(this.context, this.graph).execute();
    }

    private void rest() throws KonosException {
        new RESTResourceRenderer(this.context, this.graph).execute();
        new RESTServiceRenderer(this.context, this.graph).execute();
    }

    private void soap() throws KonosException {
        new SoapOperationRenderer(this.context, this.graph).execute();
        new SoapServiceRenderer(this.context, this.graph).execute();
    }

    private void jmx() throws KonosException {
        new JMXOperationsServiceRenderer(this.context, this.graph).execute();
        new JMXServerRenderer(this.context, this.graph).execute();
    }

    private void jms() throws KonosException {
        new MessagingRequestRenderer(this.context, this.graph).execute();
        new MessagingServiceRenderer(this.context, this.graph).execute();
    }

    private void tasks() throws KonosException {
        new ListenerRenderer(this.context, this.graph).execute();
        new SentinelsRenderer(this.context, this.graph).execute();
    }

    private void agendas() throws KonosException {
        new AgendaServiceRenderer(this.context, this.graph).execute();
    }

    private void datalake() throws KonosException {
        new DatalakeRenderer(this.context, this.graph).execute();
    }

    private void messageHub() {
        new MessageHubRenderer(this.context, this.graph).execute();
    }

    private void mounters() throws KonosException {
        new MounterFactoryRenderer(this.context, this.graph).execute();
        new MounterRenderer(this.context, this.graph).execute();
    }

    private void subscribers() throws KonosException {
        new SubscriberRenderer(this.context, this.graph).execute();
    }

    private void adapters() {
        new AdapterRenderer(this.context, this.graph).execute();
    }

    private void processes() throws KonosException {
        new BpmRenderer(this.context, this.graph).execute();
    }

    private void feeders() {
        new FeederRenderer(this.context, this.graph).execute();
    }

    private void slack() throws KonosException {
        new SlackRenderer(this.context, this.graph).execute();
    }

    private void ui() throws KonosException {
        ComponentRenderer.clearCache();
        if (this.context.mode() == KonosBuildConstants.Mode.Normal) {
            this.uiServer();
        }
        this.uiClient();
    }

    private void uiServer() throws KonosException {
        new io.intino.konos.builder.codegeneration.services.ui.ServiceListRenderer(this.context, this.graph).execute();
    }

    private void uiClient() throws KonosException {
        new ServiceListRenderer(this.context, this.graph).execute();
    }

    private void box() throws KonosException {
        AbstractBoxRenderer renderer = new AbstractBoxRenderer(this.context, this.graph);
        renderer.execute();
        new BoxRenderer(this.context, this.graph, this.hasModel).execute();
        new BoxConfigurationRenderer(this.context, this.hasModel, renderer.customParameters()).execute();
    }

    private void main() {
        new MainRenderer(this.context, this.hasModel, this.graph).execute();
    }

    private boolean hasModel() {
        return this.context.configuration().model() != null && this.context.configuration().model().language() != null;
    }
}

