/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.futures;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.futures.AbstractFutureTemplate;
import io.intino.konos.builder.codegeneration.futures.FutureSchemaTemplate;
import io.intino.konos.builder.codegeneration.futures.FutureTemplate;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Data;
import io.intino.konos.model.graph.Parameter;
import io.intino.konos.model.graph.Service;
import io.intino.magritte.framework.Layer;
import java.io.File;
import java.util.List;
import java.util.stream.IntStream;

public class FutureRenderer
extends Renderer {
    private final Service.Agenda.Future future;

    public FutureRenderer(CompilationContext context, Service.Agenda.Future future) {
        super(context, Target.Owner);
        this.future = future;
    }

    @Override
    protected void render() throws KonosException {
        FrameBuilder builder = this.futureFrame().add("package", (Object)this.packageName()).add("box", (Object)this.boxName());
        if (!this.future.graph().schemaList().isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName()).toFrame());
        }
        Frame frame = builder.toFrame();
        this.renderSrc(frame);
        this.renderAbstract(frame);
        this.renderSchema(frame);
    }

    private void renderSrc(Frame frame) {
        File agendaPackage = new File(this.src(), "agenda");
        File file = Commons.javaFile(agendaPackage, Formatters.firstUpperCase(this.future.name$()));
        if (file.exists()) {
            return;
        }
        Commons.writeFrame(agendaPackage, Formatters.firstUpperCase(this.future.name$()), this.template().render((Object)frame));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf((Layer)this.future), Commons.javaFile(agendaPackage, Formatters.firstUpperCase(this.future.name$())).getAbsolutePath()));
    }

    private void renderAbstract(Frame frame) {
        Commons.writeFrame(new File(this.gen(), "agenda"), "Abstract" + Formatters.firstUpperCase(this.future.name$()), this.abstractTemplate().render((Object)frame));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf((Layer)this.future), Commons.javaFile(new File(this.gen(), "agenda"), "Abstract" + Formatters.firstUpperCase(this.future.name$())).getAbsolutePath()));
    }

    private void renderSchema(Frame frame) {
        Commons.writeFrame(new File(this.gen(), "agenda"), Formatters.firstUpperCase(this.future.name$()) + "Schema", this.schemaTemplate().render((Object)frame));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf((Layer)this.future), Commons.javaFile(new File(this.gen(), "agenda"), Formatters.firstUpperCase(this.future.name$()) + "Schema").getAbsolutePath()));
    }

    private FrameBuilder futureFrame() {
        return new FrameBuilder(new String[]{"future"}).add("name", (Object)this.future.name$()).add("parameter", (Object)this.framesOf(this.future.parameterList())).add("option", this.future.optionList().stream().map(option -> this.frameOf((Service.Agenda.Future.Option)option, this.future)).map(FrameBuilder::toFrame).toArray(Frame[]::new));
    }

    private FrameBuilder frameOf(Service.Agenda.Future.Option option, Service.Agenda.Future future) {
        return new FrameBuilder(new String[]{"option"}).add("name", (Object)option.name$()).add("future", (Object)option.core$().owner().name()).add("parameter", (Object)this.framesOf(future.parameterList())).add("optionParameter", (Object)this.framesOf(option.parameterList()));
    }

    private Frame[] framesOf(List<Parameter> parameters) {
        return (Frame[])IntStream.range(0, parameters.size()).mapToObj(i -> this.frameOf((Parameter)parameters.get(i), i)).toArray(Frame[]::new);
    }

    private Frame frameOf(Parameter param, int index) {
        FrameBuilder builder = new FrameBuilder(new String[]{"parameter"}).add("name", (Object)param.name$()).add("owner", (Object)param.core$().owner().name()).add("index", (Object)index);
        this.parameterType(param, builder);
        if (param.i$(Data.List.class)) {
            builder.add("list");
        }
        return builder.toFrame();
    }

    private void parameterType(Parameter param, FrameBuilder builder) {
        String innerPackage;
        String string = innerPackage = param.isObject() && param.asObject().isComponent() != false ? String.join((CharSequence)".", this.packageName(), "schemas.") : "";
        if (param.isWord()) {
            builder.add("type", (Object)"java.lang.String");
        } else {
            builder.add("type", (Object)(innerPackage + param.asType().type()));
        }
    }

    private Template abstractTemplate() {
        return Formatters.customize(new AbstractFutureTemplate());
    }

    private Template template() {
        return Formatters.customize(new FutureTemplate());
    }

    private Template schemaTemplate() {
        return Formatters.customize(new FutureSchemaTemplate());
    }
}

